#!/bin/bash

echo "OPP/FTP Paring & Connection Script"

echo -e "SCANNING BLUETOOTH DEVICES ...."
echo -n "Please Put OPP device in Pairing mode & Press Enter.."

read nil
hcitool scan
echo "If device is not in the list press Enter"
echo "Copy the bluetooth address of the OPP/FTP Device and paste it below ="
read bdaddr
if [[ -z "${bdaddr}" ]]; then
   echo "Not a valid BD_ADDR"
   exit 0
fi

echo "Starting- Pairing with OPP Device"
sdptool add OPUSH
sdptool add FTP
python /usr/local/sbin/agent.py hci0 $bdaddr 
echo "Pairing Done"

echo "Creating a connection\n"

echo "Enter a number for the <dev> rfcomm id to be used"
echo "make sure that /dev/rfcomm id not being used before, OTHERWISE enter number 0 "
echo "Example to use /dev/rfcomm0, enter number 0"

read rfcommId
if [[ -z "${rfcommId}" ]]; then
   rfcommId=0
fi

sdptool browse $bdaddr

echo "Scroll and find the RFCOMM channel for either OPP or FTP"
echo "Enter the channel id for profile under use"
read channel

echo "defaul rfcomm device /dev/rfcomm1, else change the script"
sudo rfcomm bind $rfcommId $bdaddr $channel 

# for /dev/rfcomm0/
# rfcomm bind 0 $bdaddr $channel 

hcitool con

rfcomm -a

echo "Connection done"

echo "/dev/rfcomm$rfcommId created"
echo "Run OBEX server[sudo obexd --help]/client and send/receive files !"
echo "For OOP client use "ussp-push" and for FTP client use "obexftp""

