
 /************************************************************************
  * Copyright 2005-2010 by Freescale Semiconductor, Inc.
  * All modifications are confidential and proprietary information
  * of Freescale Semiconductor, Inc. ALL RIGHTS RESERVED.
  ************************************************************************/


#ifndef _ASF_API_
#define _ASF_API_

#include <stdio.h>
#define STRING_SIZE 255



#ifdef _LINUX_
typedef unsigned long long  ASF_U64;
typedef long long  ASF_I64;


#else
typedef unsigned __int64  ASF_U64;
typedef __int64  ASF_I64;

#endif

typedef long             ASF_Long;
typedef unsigned short   ASF_Ushort;
typedef unsigned long    ASF_Ulong;
typedef int              ASF_Int;
typedef char             ASF_Char;
typedef unsigned char    ASF_Uchar;

typedef void *           ASF_HANDLE;
typedef void             ASF_Void;


#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif


#define ASF_MAX_PAYLOADS    100
#define ASF_AUDIO_TYPE      1
#define ASF_VIDEO_TYPE      2
#define ASF_INDEX_OBJ_SIZE  56
#define MAX_INDEX           8096

#define ASF_MIN_OBJECT_SIZE 24 /* 16-byte guid + 8-byte size */
#define ASF_GUID_SIZE 16
 

#ifdef ASF_DEBUG

#define LOG_DEBUG       printf
#define LOG_DEBUG_FILE  fprintf 

#else
//#define printf
//#define fprintf
#define LOG_DEBUG     //printf
#define LOG_DEBUG_FILE//  fprintf


#endif



typedef struct t_asf_index
{
	ASF_Ulong  packet_number;
	ASF_Ushort  packet_count;
	
}asf_index;

typedef struct t_simple_index_object
{

	ASF_U64   index_interval ;
	ASF_Ulong max_packet_count ;
	ASF_Ulong index_enties_count ;
	asf_index index_element[MAX_INDEX];
	
}simple_index_object;




typedef struct tAudioStreamInfo
{	
	ASF_Long        bHasValidAudio;  	/** if there is a valid audio stream 	*/
	ASF_Ushort     	u16WMAVersion;    	/* WMA version number, 1 or 2. 		*/

	
	/**** WAVEFORMATEX ****/
	ASF_Ushort      wFormatTag;				/* Format Tag ID				*/
	ASF_Ushort     	u16Channels;      		/* number of channels, 1 or 2. 	*/
	ASF_Ulong      	u32SamplesPerSec; 		/* sampling rate                */
	ASF_Ulong       nAvgBytesPerSec;		/* Average bytes per second		*/
	ASF_Ushort      nBlockAlign;			/* Block Align					*/
	ASF_Ushort     	u16BitsPerSample; 		/* bits per sample				*/
	ASF_Ushort		u16AudioExtraDataSize;	/* Audio Extra Data Length		*/
	ASF_Uchar		AudioExtraData[18];		/* Audio Extra Data	(modified for WMA10) */
	/************************/

	ASF_Ulong      	u32Duration;      		/* duration in miliseconds      */
	ASF_Long       	bHasDRM;                /* if there is a DRM           	*/

	ASF_Ulong      	u32BitRate;       		/* bitrate, in bits per second 	*/

	ASF_Int		stream_num;

	ASF_Int bIsCompressedPayload;//required for raw data decoding

} AudioStreamInfo;



typedef struct tVideoStreamInfo
{
    ASF_Long              bHasValidVideo;	  /* if there is a valid video stream */
    ASF_Ulong     u32CompressionType; /* the compression type if the video stream, e.g., FOURCC_WMV1*/
    ASF_Ulong     u32Width;			  /* image width */
    ASF_Ulong     u32Height;          /* image height */
    double    dbFrameRate;
    ASF_Ulong     u32VideoOutputPixelType;
    ASF_Ushort    u16VideoOutputBitCount; /* Output bitcount*/
    ASF_Uchar     bPalette[3*256];        /* Palette*/
    ASF_Long              bHasDRM;				  /* if there is a DRM*/
	ASF_Uchar	  ExtraInfo[1024];		  /* Video type specific data */
    ASF_Ulong	  ExtraDataLength;		  /* Video type specific data length */
	ASF_Int					stream_num;
	ASF_Ulong  biSize; 
	ASF_Ushort    biPlanes; 
	
	ASF_Ulong  biSizeImage; 
	ASF_Long		biXPelsPerMeter; 
	ASF_Long		biYPelsPerMeter; 
	ASF_Ulong  biClrUsed; 
	ASF_Ulong  biClrImportant;


} VideoStreamInfo;

typedef struct tag_file_properties
{
    ASF_I64    num_packets;	  
    ASF_U64     file_size; 
    ASF_Ulong     ms_duration;	
    ASF_Ulong     send_duration;  
    ASF_Ulong     pre_roll;
    ASF_Ulong    packet_size; 
    ASF_Ulong     seekable;    
    ASF_Long              max_bitrate;
	
} asf_parser_file_properties;


typedef struct t_asf_parser_content_descriptor
{
	ASF_Int				meta_data_present;
	ASF_Uchar			Title[STRING_SIZE];			/* basic title string     */
	ASF_Uchar			Author[STRING_SIZE];		/* basic Author string    */
	ASF_Uchar			Copyright[STRING_SIZE];		/* basic copyright string */
	ASF_Uchar			Description[STRING_SIZE];	/* basic description string */
	ASF_Uchar			Rating[STRING_SIZE];		/* basic rating string    */
	ASF_Uchar			Temp[STRING_SIZE];			/* basic extra string     */

}asf_parser_content_descriptor;


typedef struct t_asf_parser_extended_content_descriptor
{
	ASF_Int				meta_data_present; /* whether this info is available */
	ASF_Uchar			AlbumTitle[STRING_SIZE];	/* album name     */
	ASF_Uchar			AlbumArtist[STRING_SIZE];		/* author    */
	ASF_Uchar			Year[STRING_SIZE];		/* year */
	ASF_Uchar			Genre[STRING_SIZE];	/* genre */    
    //ASF_Uchar			IsVBR;		/* 1 for VBR, 0 for CBR   */
	//ASF_Int			Track;			/* Track position? */
    ASF_Uchar			Publisher[STRING_SIZE];			/* basic extra string     */
    ASF_Uchar			Composer[STRING_SIZE];			/* basic extra string     */
 
}asf_parser_extended_content_descriptor;



#ifdef _LINUX_
typedef unsigned long long u64;
#else
typedef unsigned __int64 u64;
#endif

typedef struct tag_asf_parser_raw_streams{
	ASF_Int pres_time; /* time stamp in ms */
	ASF_Int stream_type;
	ASF_Int object_size;
	ASF_Char *payload;
    ASF_Int is_key_frame;
}asf_parser_raw_streams;

typedef struct asf_out{
	ASF_Int num_payloads;
	asf_parser_raw_streams raw_streams[ASF_MAX_PAYLOADS];
}asf_parser_stream;


typedef enum t_asf_error{
	ASF_OK,
	ASF_ERROR,
	ASF_PARSING_DONE,
	ASF_NEED_MORE_DATA = 300
}asf_error;

/* File I/O callback */
typedef asf_error (asf_get_data)(ASF_HANDLE hDecoder,ASF_Char* pBuffer,
							ASF_Ulong cbSize,u64 cbOffset,
							ASF_Ulong *Read);

typedef ASF_I64 (asf_check_available_bytes)(ASF_HANDLE hDecoder, ASF_I64 cbRequestedSize);

/* Memory management callback */
typedef ASF_Void * (asf_allocate_mem)(ASF_Ulong size);
typedef ASF_Void  (asf_free_mem)( ASF_Void *memblock );


const char * asf_parser_version_info(); /* API to get version info */

ASF_HANDLE  asf_parser_init(asf_get_data *parser_get_data,
                            asf_check_available_bytes * parser_check_available_bytes,
                            asf_allocate_mem * parser_malloc,
                            asf_free_mem * parser_free,
                            int isLiveSource,
                            int *error_code,
                            void *pvappcontext);



ASF_Int     asf_parse_get_hdr_size(ASF_HANDLE h_asf_parser);
asf_error   asf_parse_index(ASF_HANDLE h_asf_parser, simple_index_object *index);
asf_error   asf_parse_seek(ASF_HANDLE h_asf_parser, ASF_Ulong packet_number,ASF_Ulong *pdwSCR);
asf_error   asf_parse_get_file_properties(ASF_HANDLE h_asf_parser, asf_parser_file_properties *info);

asf_error   asf_parse_get_content_descriptors(ASF_HANDLE h_asf_parser,asf_parser_content_descriptor *info);
asf_error   asf_parse_get_extended_content_descriptors(ASF_HANDLE h_asf_parser,asf_parser_extended_content_descriptor *info);


asf_error   asf_parse_get_video_stream_info(ASF_HANDLE h_asf_parser,VideoStreamInfo *info);
asf_error   asf_parse_get_audio_stream_info(ASF_HANDLE h_asf_parser,AudioStreamInfo *info);
asf_error   asf_parser_close(ASF_HANDLE h_asf_parser);
asf_error   asf_parser_parse_packet(ASF_HANDLE h_asf_parser, asf_parser_stream *str_in);
//ASF_Void    *asf_parser_allocate_mem(size_t size);
//ASF_Void    asf_parser_free_mem( ASF_Void *memblock );







#endif



