
//+-------------------------------------------------------------------------
//
//  Microsoft Windows Media
//
//  Copyright (C) Microsoft Corporation, 1999 - 1999
//
//  File:       loadStuff.h
//
//--------------------------------------------------------------------------


/************************************************************************
* Copyright 2005-2010 by Freescale Semiconductor, Inc.
* All modifications are confidential and proprietary information
* of Freescale Semiconductor, Inc.
************************************************************************/


#ifndef LOADSTUFF_H
#define LOADSTUFF_H

#include "wmf_types.h"
#include "asfguids.h"


void LoadGuid(GUID_WMF *a, const U8_WMF **buf);
void LoadQword(U64_WMF *a, const U8_WMF **buf);
void LoadDword(U32_WMF *a, const U8_WMF **buf);
void Loadword(U16_WMF *a, const U8_WMF **buf);
void Loadbyte(U8_WMF *a, const U8_WMF **buf);
void  get_dword(const U8_WMF *buf, U32_WMF *dw);
void get_word(const U8_WMF *buf, U16_WMF *w);




#if defined(_MSC_VER) || defined(LINUX_x86)
#define LITTLE_ENDIAN
#endif


#define LoadBYTE( w, p )    Loadbyte(&w , &p)    
#define LoadWORD( w, p )    Loadword(&w , &p)
#define LoadDWORD( dw, p )  LoadDword(&dw , &p)
#define LoadQWORD( qw, p )  LoadQword(&qw , &p)

#define LoadGUID( g, p )    LoadGuid(&g , &p)

#define GetUnalignedDword( pb, dw ) get_dword(pb, &dw)

#define GetUnalignedWord( pb, dw ) get_word(pb, &dw)

#endif  // LOADSTUFF_H


