//*@@@+++@@@@******************************************************************
//
// Microsoft Windows Media
// Copyright (C) Microsoft Corporation. All rights reserved.
//
//*@@@---@@@@******************************************************************

#ifndef _COMPUTE_MASK_TBL_H_
#define _COMPUTE_MASK_TBL_H_

//-------------------- tables for prvComputeMaskFromSubBarkExcitation ---------------------------------------//

    // elements of g_pow10Tbl[] are in 3.29 format, stepsize of 0.025
    // g_pow10Tbl[i] = (U32)( pow( 10, i * 0.025 ) * ( 1<<29 ) )

const U32 g_pow10Tbl[] = 
{
    0x20000000,     0x21e56811,     0x23e7933e,     0x260835d2,
    0x28491df1,     0x2aac3523,     0x2d3381ef,     0x2fe12999,
    0x32b771ed,     0x35b8c334,     0x38e7aa38,     0x3c46da74,
    0x3fd9305a,     0x43a1b3c4,     0x47a39a83,     0x4be24b1c,
    0x50615fa7,     0x5524a8e1,     0x5a303166,     0x5f884121,
    0x653160eb,     0x6b305e68,     0x718a5016,     0x784499a4,
    0x7f64f07d,     0x86f160a7,     0x8ef051e2,     0x97688d17,
    0xa0614218,     0xa9e20dbd,     0xb3f30059,     0xbe9ca48e
};

    // elements of g_pow10invTbl[] are in 1.15 format, stepsize of -0.025
    // g_pow10Tbl[i] = (U32)( pow( 10, i * -0.025 ) * ( 1<<15 ) + 0.5 )

const U16 g_pow10invTbl[] = 
{
    0x8000,    0x78d7,    0x7215,    0x6bb3,
    0x65ad,    0x5ffd,    0x5a9e,    0x558c,
    0x50c3,    0x4c3f,    0x47fb,    0x43f4,
    0x4027,    0x3c90,    0x392d,    0x35fa,
    0x32f5,    0x301b,    0x2d6b,    0x2ae0,
    0x287a,    0x2637,    0x2413,    0x220f,
    0x2027,    0x1e5b,    0x1ca8,    0x1b0d,
    0x198a,    0x181c,    0x16c3,    0x157d
};

    // elements of g_earTbl_xx were computed as exponent / mantissa pairs
    // these may not cover all possible cases for each sampling frequency
    // table entries generated from floating-point codebase with:
    //
    //        int   exp = 0;
    //        float man = frexp( pow( rgfltMeanOuterEarInSubBark[i], -4.0 ), &exp );
    //        int   hex = (U32)( man * 0x100000000 ); assert( 1 > man >= 0.5 );
    //        printf( "{ %2d,\t0x%x },\n", exp, hex );

const U32 g_earTbl_48[][2] =
{
    {  0,	0xe7adc900 },    {  0, 	 0xe7adc900 },    {  0,	  0xe7adc900 },    {  0,   0xe7adc900 },
    {  0,	0xe7adc900 },    {  0,	 0xe7adc900 },    {  0,	  0xe7adc900 },    {  0,   0xe7adc900 },
    {  0,	0xe7adc900 },    {  0,	 0xe7adc900 },    {  0,	  0xe7adc900 },    {  0,   0xe7adc900 },
    {  0,	0xe7adc900 },    {  0,	 0xe7adc900 },    {  0,	  0xe7add700 },    {  0,   0xe7add700 },
    {  0,	0xe7adec00 },    {  0,	 0xe7adfa00 },    {  0,	  0xf2cd8000 },    {  1,   0xc4367500 },
    {  2,	0x858da600 },    {  2,	 0xe0bad600 },    {  4,	  0xcb056f00 },    {  9,   0x9e7ff200 },
    { 20,	0xf2d8ca00 }
};

const U32 g_earTbl_44[][2] =
{
    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },
    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },
    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },
    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7add700 },    {  0,   0xe7adde00 },
    {  0,   0xe7adf300 },    {  0,   0xe7adfa00 },    {  0,   0xf2af1e00 },    {  1,   0xc41f6c00 },
    {  2,   0x85de7500 },    {  2,   0xe1d8c400 },    {  4,   0xcc814200 },    {  9,   0x9f5b5c00 },
    { 20,   0xa785fc00 }
};

const U32 g_earTbl_32[][2] =
{
    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },
    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },
    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },
    {  0,   0xe7add700 },    {  0,   0xe7adde00 },    {  0,   0xe7adec00 },    {  0,   0xe7adfa00 },
    {  0,   0xe7adfa00 },    {  0,   0xe7ae0900 },    {  0,   0xf3e48700 },    {  1,   0xc4a1a800 },
    {  2,   0x855f9400 },    {  2,   0xe01e8c00 },    {  4,   0xca213200 },    {  9,   0x9d5f8600 },
    { 14,   0xd1054700 }
};

const U32 g_earTbl_22[][2] =
{
    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },
    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },
    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },
    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7add700 },    {  0,   0xe7adde00 },
    {  0,   0xe7adf300 },    {  0,   0xe7adfa00 },    {  0,   0xf2af1e00 },    {  1,   0xc41f6c00 },
    {  2,   0x85de7500 },    {  2,   0xe1d8c400 },    {  4,   0x8d17cf00 }
};

const U32 g_earTbl_16[][2] =
{
    {  0,   0xe7adc900 },    {  0,   0xe7add000 },    {  0,   0xe7adc900 },    {  0,   0xe7add000 },
    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },
    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },
    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },    {  0,   0xe7adc900 },
    {  0,   0xe7add700 },    {  0,   0xe7ade500 },    {  0,   0xf32f4200 },    {  1,   0xc3794b00 },
    {  2,   0x84c1d500 },    {  2,   0xa6812600 }
};

#endif // _COMPUTE_MASK_TBL_H_
