//*@@@+++@@@@******************************************************************
//
// Microsoft Windows Media
// Copyright (C) Microsoft Corporation. All rights reserved.
//
//*@@@---@@@@******************************************************************

/*************************************************************************

Copyright(c) 1996  Microsoft Corporation

Module Name:

    lpcenc.h

Abstract:

    Header file for lpcenc.c

Author:

    Wei-ge Chen(wchen) 11-March-1998

Revision History:

    Thumpudi Naveen (tnaveen) 3-May-2000
    Branched-off from MSAudioEnc.h

*************************************************************************/

#ifndef __LPCENC_H_
#define __LPCENC_H_

#ifdef __cplusplus
extern "C" {
#endif
    
    INLINE Void prvComputeLevinsonRecursion(CAudioObjectEncoder *pauenc,
        Float R[], Float a[]);
    WMARESULT prvGetLpcSpectrum(CAudioObjectEncoder *pauenc, PerChannelInfoENC *pcinfoENC);
    WMARESULT prvGetLpcSpectrumFromMask(CAudioObjectEncoder *pauenc,
        PerChannelInfoENC *pcinfoENC);
    WMARESULT prvGetLspFreq(CAudioObjectEncoder *pauenc, Float *pfltAlpha, Float *freq,
        float *lastfreq);
    WMARESULT prvQuantizeLsf(CAudioObjectEncoder *pauenc, Float* pfltLsf, 
        Float* rgfltRA, U8* pbLsfQ);
    
#ifdef WMA_TARGET_X86
    WMARESULT prvGetLpcSpectrum_KNI(CAudioObjectEncoder *pauenc, PerChannelInfo *pcinfo);
#endif // WMA_TARGET_X86
    
#if defined (STABLE_LPC)
    WMARESULT prvQuantizeLsfWithStability(CAudioObjectEncoder *pauenc, 
        Float* rgfltLsfIn, Float* rgfltRA, 
        U8* pbLsfQ, Float* rgfltLsfOut);
    WMARESULT prvGetLsdMeasure(CAudioObjectEncoder *pauenc, Float* rgfltRA, 
        Float* rgfltLsf, Float* rgfltLspSensitivity);
    Void prvFillLsdJacobian(CAudioObject* pau, Float* rgfltLsf, 
        Float rgrgfltJ[LPCORDER][LPCORDER]);
    WMARESULT prvLsdQuantizeLsf(CAudioObjectEncoder *pauenc, Float* pfltLsfIn, 
        Float* rgfltLspSensitivity, U8* pbLsfQ,
        Float* pfltLsfOut);
    Void prvConvolveLsd(CAudioObject* pau, LpType *rglpIn1, Int cIn1, LpType *rglpIn2, Int cIn2, LpType *rglpOut, Int *pcOut);
#endif // STABLE_LPC
        
#ifdef __cplusplus
}; // extern "C"
#endif

#endif  //__LPCENC_H_
