//*@@@+++@@@@******************************************************************
//
// Microsoft Windows Media
// Copyright (C) Microsoft Corporation. All rights reserved.
//
//*@@@---@@@@******************************************************************

//+-------------------------------------------------------------------------
//
//  Microsoft Windows Media
//
//  Copyright (C) Microsoft Corporation, 1999 - 1999
//
//  File:       lpfilter.h
//
//--------------------------------------------------------------------------


// To calculate scale, I usually compute T = sum(abs(coef)) for all coefficients
// Then, scale * 0x7FFF * T = 0x7FFFFFFF, solve for scale.
#define FOURTAP_FILTER_COEFS(HiMedLow, NumDen, a,b,c,d, scale)              \
    const Float rgfltCoef##NumDen##HiMedLow [] = {(a), (b), (c), (d)};      \
    const Float fltScale##NumDen##HiMedLow = (Float)(scale);                \
    const Float fltInvScale##NumDen##HiMedLow = 1.0F / (Float)(scale);      \
    const I16 rgiCoef##NumDen##HiMedLow [] = {(I16)((a)*(scale)),           \
        (I16)((b)*(scale)), (I16)((c)*(scale)), (I16)((d)*(scale))}         \


#define FIVETAP_FILTER_COEFS(HiMedLow, NumDen, a,b,c,d,e, scale)            \
    const Float rgfltCoef##NumDen##HiMedLow [] = {(a), (b), (c), (d), (e)}; \
    const Float fltScale##NumDen##HiMedLow = (Float)(scale);                \
    const Float fltInvScale##NumDen##HiMedLow = 1.0F / (Float)(scale);      \
    const I16 rgiCoef##NumDen##HiMedLow [] = {(I16)((a)*(scale)),           \
        (I16)((b)*(scale)), (I16)((c)*(scale)), (I16)((d)*(scale)),         \
        (I16)((e)*(scale))}                                                 \


#define SEVENTAP_FILTER_COEFS(HiMedLow, NumDen, a,b,c,d,e,f,g, scale)       \
    const Float rgfltCoef##NumDen##HiMedLow [] = {(a), (b), (c), (d),       \
        (e), (f), (g)};                                                     \
    const Float fltScale##NumDen##HiMedLow = (Float)(scale);                \
    const Float fltInvScale##NumDen##HiMedLow = 1.0F / (Float)(scale);      \
    const I16 rgiCoef##NumDen##HiMedLow [] = {(I16)((a)*(scale)),           \
        (I16)((b)*(scale)), (I16)((c)*(scale)), (I16)((d)*(scale)),         \
        (I16)((e)*(scale)), (I16)((f)*(scale)), (I16)((g)*(scale))}         \


#define EIGHTTAP_FILTER_COEFS(HiMedLow, NumDen, a,b,c,d,e,f,g,h, scale)     \
    const Float rgfltCoef##NumDen##HiMedLow [] = {(a), (b), (c), (d),       \
        (e), (f), (g), (h)};                                                \
    const Float fltScale##NumDen##HiMedLow = (Float)(scale);                \
    const Float fltInvScale##NumDen##HiMedLow = 1.0F / (Float)(scale);      \
    const I16 rgiCoef##NumDen##HiMedLow [] = {(I16)((a)*(scale)),           \
        (I16)((b)*(scale)), (I16)((c)*(scale)), (I16)((d)*(scale)),         \
        (I16)((e)*(scale)), (I16)((f)*(scale)), (I16)((g)*(scale)),         \
        (I16)((h)*(scale))}                                                 \


#define GET_LOW_MED_HI_ARGS const Int cCoefLow, const Int cCoefMed, const Int cCoefHi,  \
                            U32* piPower,                                      \
                            const I16 *piSource, const Int iSourceLength,               \
                            const Int iSliceWidth, const Int iSliceIncr,                \
                            const I16 cChannel,                                         \
                            I16 *piTransientSrcLow, Int *piTransientSrcCurrLow,         \
                            I32 *pIntTransientDstLow, Int *piTransientDstCurrLow,\
                            I16 *piTransientSrcMed,Int *piTransientSrcCurrMed,          \
                            I32 *pIntTransientDstMed, Int *piTransientDstCurrMed,\
                            I16 *piTransientSrcHi,Int *piTransientSrcCurrHi,            \
                            I32 *pIntTransientDstHi, Int *piTransientDstCurrHi


#ifdef __cplusplus
extern "C" {
#endif

void g_GetLowMedHiPower_48(GET_LOW_MED_HI_ARGS);
void g_GetLowMedHiPower_44(GET_LOW_MED_HI_ARGS);
void g_GetLowMedHiPower_32(GET_LOW_MED_HI_ARGS);
void g_GetLowMedHiPower_22(GET_LOW_MED_HI_ARGS);
void g_GetLowMedHiPower_16(GET_LOW_MED_HI_ARGS);

#ifdef WMA_TARGET_X86
void g_GetLowMedHiPower_48_MMX(GET_LOW_MED_HI_ARGS);
void g_GetLowMedHiPower_44_MMX(GET_LOW_MED_HI_ARGS);
void g_GetLowMedHiPower_32_MMX(GET_LOW_MED_HI_ARGS);
void g_GetLowMedHiPower_22_MMX(GET_LOW_MED_HI_ARGS);
void g_GetLowMedHiPower_16_MMX(GET_LOW_MED_HI_ARGS);

// MMX has a built-in perf penalty because it needs an intermediate buffer.
// Tests have found that MMX mono is no faster than C code (without intermediate buf).
// Therefore, disable MMX mono. It was a useful step in producing the stereo MMX code.
#ifdef MMXMONO
void g_GetLowMedHiPower_48MONO_MMX(GET_LOW_MED_HI_ARGS);
void g_GetLowMedHiPower_44MONO_MMX(GET_LOW_MED_HI_ARGS);
void g_GetLowMedHiPower_32MONO_MMX(GET_LOW_MED_HI_ARGS);
void g_GetLowMedHiPower_22MONO_MMX(GET_LOW_MED_HI_ARGS);
void g_GetLowMedHiPower_16MONO_MMX(GET_LOW_MED_HI_ARGS);
#endif  // MMXMONO

void g_GetLowMedHiPower_44_KNI(GET_LOW_MED_HI_ARGS);
#endif // WMA_TARGET_X86

#ifdef __cplusplus
}
#endif

