/*
 ***********************************************************************
 * Copyright 2005-2009 by Freescale Semiconductor, Inc.
 * All modifications are confidential and proprietary information
 * of Freescale Semiconductor, Inc. ALL RIGHTS RESERVED.
 ***********************************************************************
 */
//*@@@+++@@@@******************************************************************
//
// Microsoft Windows Media
// Copyright (C) Microsoft Corporation. All rights reserved.
//
//*@@@---@@@@******************************************************************

/*        rawio.h
******************************************************************************
Copyright (c), 2001 - Analog Devices Company Inc.
Three Technology Way
Norwood, MA  02062-9106  USA
This software is PROPRIETARY & CONFIDENTIAL
******************************************************************************
Project:        
Title:        
Author:        Wei Zhang

Description:

******************************************************************************
        Tab Setting:              
        Target Processor:      
        Target Tools Revision: 

        Last Modified:                  $Date: 2002/11/21 21:03:39 $
******************************************************************************

Modification History:
====================

******************************************************************************
*/

#include <stdio.h>
//#include "macros.h"
#include "tchar.h"

//***********************************************************************
//   Data type 
//***********************************************************************
typedef unsigned char		  RAW_UINT8;
typedef char			        RAW_INT8;
typedef unsigned short		RAW_UINT16;
typedef short		        	RAW_INT16;
typedef unsigned int		  RAW_UINT32;
typedef int			          RAW_INT32;
typedef RAW_UINT32        RAW_Bool;
#if _WIN32
typedef unsigned __int64        RAW_UINT64;
typedef __int64                 RAW_INT64;
#else
typedef unsigned long long      RAW_UINT64;
typedef long long               RAW_INT64;
#endif

#ifndef _Embedded_x86
#pragma COMPILER_PACKALIGN(1)
#pragma COMPILER_PACKALIGN_DEFAULT
#endif

#ifndef MMSYSERR_NOERROR
#define MMSYSERR_NOERROR     0
#define MMSYSERR_ERROR       1
#define MMSYSERR_NOMEM       7
#define MMSYSERR_READERROR   16
#define MMSYSERR_WRITEERROR  17
#endif /* MMSYSERR_NOERROR */

/* flag for RawFileIO */
enum
{
    rfioModeRead = 0,
    rfioModeWrite
};

/* ===========================================================================
 * RawFileIO struct
 */
typedef struct RawFileIO_tag
{
    RAW_INT32      m_mode;

    FILE    *m_fpRaw;

    RAW_UINT32   m_sizeData;

} RawFileIO;


/* ---------------------------------------------------------------------------
 * member functions
 */

RawFileIO * rfioNew();
void rfioDelete(RawFileIO *prfio);

RAW_INT32 rfioOpen(RawFileIO *prfio, const TCHAR *szFile,  RAW_INT32 mode);
void rfioClose(RawFileIO *prfio);

/* origin can be SEEK_SET, SEEK_CUR */
RAW_INT32 rfioSeek(RawFileIO *prfio, RAW_INT32 position, RAW_INT32 origin);
RAW_INT32 rfioRead(RawFileIO *prfio, RAW_UINT8 *pBuf, RAW_INT32 cbBuf);
RAW_INT32 rfioWrite(RawFileIO *prfio, RAW_UINT8 *pBuf, RAW_INT32 cbBuf);
RAW_INT32 rfioIsOpened(RawFileIO *prfio);
RAW_INT64 rfioTell(RawFileIO *prfio );









