/*
 * Copyright (C) 2019-2022 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#pragma once

#include <libyuv.h>

#include <unordered_map>

#include "IImageProcessor.h"

namespace icamera {

class ImageProcessorCore : public IImageProcessor {
public:
    ImageProcessorCore();
    ~ImageProcessorCore() {}

    virtual status_t cropFrame(const std::shared_ptr<CameraBuffer> &input,
                               std::shared_ptr<CameraBuffer> &output);
    virtual status_t scaleFrame(const std::shared_ptr<CameraBuffer> &input,
                                std::shared_ptr<CameraBuffer> &output);
    virtual status_t rotateFrame(const std::shared_ptr<CameraBuffer> &input,
                                 std::shared_ptr<CameraBuffer> &output,
                                 int angle, std::vector<uint8_t> &rotateBuf);
    virtual status_t convertFrame(const std::shared_ptr<CameraBuffer> &input,
                                  std::shared_ptr<CameraBuffer> &output);

private:
    DISALLOW_COPY_AND_ASSIGN(ImageProcessorCore);

    std::unordered_map<int, libyuv::RotationMode> mRotationMode;
};

} /* namespace icamera */
