/*
 * STMP EMI Register Definitions
 *
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 * Copyright 2008 Embedded Alley Solutions, Inc All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * This file is created by xml file. Don't Edit it.
 */

#ifndef __ARCH_ARM___EMI_H
#define __ARCH_ARM___EMI_H  1

#define REGS_EMI_BASE (STMP3XXX_REGS_BASE + 0x20000)
#define REGS_EMI_PHYS (0x80020000)
#define REGS_EMI_SIZE 0x00002000

#define HW_EMI_CTRL	(0x00000000)
#define HW_EMI_CTRL_SET	(0x00000004)
#define HW_EMI_CTRL_CLR	(0x00000008)
#define HW_EMI_CTRL_TOG	(0x0000000c)
#define HW_EMI_CTRL_ADDR  \
		(REGS_EMI_BASE + HW_EMI_CTRL)
#define HW_EMI_CTRL_SET_ADDR \
		(REGS_EMI_BASE + HW_EMI_CTRL_SET)
#define HW_EMI_CTRL_CLR_ADDR \
		(REGS_EMI_BASE + HW_EMI_CTRL_CLR)
#define HW_EMI_CTRL_TOG_ADDR \
		(REGS_EMI_BASE + HW_EMI_CTRL_TOG)

#define BM_EMI_CTRL_SFTRST	0x80000000
#define BM_EMI_CTRL_CLKGATE	0x40000000
#define BM_EMI_CTRL_TRAP_SR	0x20000000
#define BM_EMI_CTRL_TRAP_INIT	0x10000000
#define BP_EMI_CTRL_AXI_DEPTH	26
#define BM_EMI_CTRL_AXI_DEPTH	0x0C000000
#define BF_EMI_CTRL_AXI_DEPTH(v)  \
		(((v) << 26) & BM_EMI_CTRL_AXI_DEPTH)
#define BV_EMI_CTRL_AXI_DEPTH__ONE   0x0
#define BV_EMI_CTRL_AXI_DEPTH__TWO   0x1
#define BV_EMI_CTRL_AXI_DEPTH__THREE 0x2
#define BV_EMI_CTRL_AXI_DEPTH__FOUR  0x3
#define BM_EMI_CTRL_DLL_SHIFT_RESET	0x02000000
#define BM_EMI_CTRL_DLL_RESET	0x01000000
#define BP_EMI_CTRL_ARB_MODE	22
#define BM_EMI_CTRL_ARB_MODE	0x00C00000
#define BF_EMI_CTRL_ARB_MODE(v)  \
		(((v) << 22) & BM_EMI_CTRL_ARB_MODE)
#define BV_EMI_CTRL_ARB_MODE__TIMESTAMP     0x0
#define BV_EMI_CTRL_ARB_MODE__WRITE_HYBRID  0x1
#define BV_EMI_CTRL_ARB_MODE__PORT_PRIORITY 0x2
#define BM_EMI_CTRL_RSVD3	0x00200000
#define BP_EMI_CTRL_PORT_PRIORITY_ORDER	16
#define BM_EMI_CTRL_PORT_PRIORITY_ORDER	0x001F0000
#define BF_EMI_CTRL_PORT_PRIORITY_ORDER(v)  \
		(((v) << 16) & BM_EMI_CTRL_PORT_PRIORITY_ORDER)
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT0123 0x00
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT0312 0x01
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT0231 0x02
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT0321 0x03
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT0213 0x04
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT0132 0x05
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT1023 0x06
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT1302 0x07
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT1230 0x08
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT1320 0x09
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT1203 0x0A
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT1032 0x0B
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT2013 0x0C
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT2301 0x0D
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT2130 0x0E
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT2310 0x0F
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT2103 0x10
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT2031 0x11
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT3012 0x12
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT3201 0x13
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT3120 0x14
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT3210 0x15
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT3102 0x16
#define BV_EMI_CTRL_PORT_PRIORITY_ORDER__PORT3021 0x17
#define BM_EMI_CTRL_RSVD2	0x00008000
#define BP_EMI_CTRL_PRIORITY_WRITE_ITER	12
#define BM_EMI_CTRL_PRIORITY_WRITE_ITER	0x00007000
#define BF_EMI_CTRL_PRIORITY_WRITE_ITER(v)  \
		(((v) << 12) & BM_EMI_CTRL_PRIORITY_WRITE_ITER)
#define BM_EMI_CTRL_RSVD1	0x00000800
#define BP_EMI_CTRL_HIGH_PRIORITY_WRITE	8
#define BM_EMI_CTRL_HIGH_PRIORITY_WRITE	0x00000700
#define BF_EMI_CTRL_HIGH_PRIORITY_WRITE(v)  \
		(((v) << 8) & BM_EMI_CTRL_HIGH_PRIORITY_WRITE)
#define BM_EMI_CTRL_RSVD0	0x00000080
#define BM_EMI_CTRL_MEM_WIDTH	0x00000040
#define BM_EMI_CTRL_WRITE_PROTECT	0x00000020
#define BM_EMI_CTRL_RESET_OUT	0x00000010
#define BP_EMI_CTRL_CE_SELECT	0
#define BM_EMI_CTRL_CE_SELECT	0x0000000F
#define BF_EMI_CTRL_CE_SELECT(v)  \
		(((v) << 0) & BM_EMI_CTRL_CE_SELECT)
#define BV_EMI_CTRL_CE_SELECT__NONE 0x0
#define BV_EMI_CTRL_CE_SELECT__CE0  0x1
#define BV_EMI_CTRL_CE_SELECT__CE1  0x2
#define BV_EMI_CTRL_CE_SELECT__CE2  0x4
#define BV_EMI_CTRL_CE_SELECT__CE3  0x8

#define HW_EMI_STAT	(0x00000010)
#define HW_EMI_STAT_ADDR \
		(REGS_EMI_BASE + HW_EMI_STAT)

#define BM_EMI_STAT_DRAM_PRESENT	0x80000000
#define BM_EMI_STAT_NOR_PRESENT	0x40000000
#define BM_EMI_STAT_LARGE_DRAM_ENABLED	0x20000000
#define BP_EMI_STAT_RSVD0	2
#define BM_EMI_STAT_RSVD0	0x1FFFFFFC
#define BF_EMI_STAT_RSVD0(v)  \
		(((v) << 2) & BM_EMI_STAT_RSVD0)
#define BM_EMI_STAT_DRAM_HALTED	0x00000002
#define BV_EMI_STAT_DRAM_HALTED__NOT_HALTED 0x0
#define BV_EMI_STAT_DRAM_HALTED__HALTED     0x1
#define BM_EMI_STAT_NOR_BUSY	0x00000001
#define BV_EMI_STAT_NOR_BUSY__NOT_BUSY 0x0
#define BV_EMI_STAT_NOR_BUSY__BUSY     0x1

#define HW_EMI_TIME	(0x00000020)
#define HW_EMI_TIME_SET	(0x00000024)
#define HW_EMI_TIME_CLR	(0x00000028)
#define HW_EMI_TIME_TOG	(0x0000002c)
#define HW_EMI_TIME_ADDR  \
		(REGS_EMI_BASE + HW_EMI_TIME)
#define HW_EMI_TIME_SET_ADDR \
		(REGS_EMI_BASE + HW_EMI_TIME_SET)
#define HW_EMI_TIME_CLR_ADDR \
		(REGS_EMI_BASE + HW_EMI_TIME_CLR)
#define HW_EMI_TIME_TOG_ADDR \
		(REGS_EMI_BASE + HW_EMI_TIME_TOG)

#define BP_EMI_TIME_RSVD4	28
#define BM_EMI_TIME_RSVD4	0xF0000000
#define BF_EMI_TIME_RSVD4(v) \
		(((v) << 28) & BM_EMI_TIME_RSVD4)
#define BP_EMI_TIME_THZ	24
#define BM_EMI_TIME_THZ	0x0F000000
#define BF_EMI_TIME_THZ(v)  \
		(((v) << 24) & BM_EMI_TIME_THZ)
#define BP_EMI_TIME_RSVD2	20
#define BM_EMI_TIME_RSVD2	0x00F00000
#define BF_EMI_TIME_RSVD2(v)  \
		(((v) << 20) & BM_EMI_TIME_RSVD2)
#define BP_EMI_TIME_TDH	16
#define BM_EMI_TIME_TDH	0x000F0000
#define BF_EMI_TIME_TDH(v)  \
		(((v) << 16) & BM_EMI_TIME_TDH)
#define BP_EMI_TIME_RSVD1	13
#define BM_EMI_TIME_RSVD1	0x0000E000
#define BF_EMI_TIME_RSVD1(v)  \
		(((v) << 13) & BM_EMI_TIME_RSVD1)
#define BP_EMI_TIME_TDS	8
#define BM_EMI_TIME_TDS	0x00001F00
#define BF_EMI_TIME_TDS(v)  \
		(((v) << 8) & BM_EMI_TIME_TDS)
#define BP_EMI_TIME_RSVD0	4
#define BM_EMI_TIME_RSVD0	0x000000F0
#define BF_EMI_TIME_RSVD0(v)  \
		(((v) << 4) & BM_EMI_TIME_RSVD0)
#define BP_EMI_TIME_TAS	0
#define BM_EMI_TIME_TAS	0x0000000F
#define BF_EMI_TIME_TAS(v)  \
		(((v) << 0) & BM_EMI_TIME_TAS)

#define HW_EMI_DDR_TEST_MODE_CSR	(0x00000030)
#define HW_EMI_DDR_TEST_MODE_CSR_SET	(0x00000034)
#define HW_EMI_DDR_TEST_MODE_CSR_CLR	(0x00000038)
#define HW_EMI_DDR_TEST_MODE_CSR_TOG	(0x0000003c)
#define HW_EMI_DDR_TEST_MODE_CSR_ADDR  \
		(REGS_EMI_BASE + HW_EMI_DDR_TEST_MODE_CSR)
#define HW_EMI_DDR_TEST_MODE_CSR_SET_ADDR \
		(REGS_EMI_BASE + HW_EMI_DDR_TEST_MODE_CSR_SET)
#define HW_EMI_DDR_TEST_MODE_CSR_CLR_ADDR \
		(REGS_EMI_BASE + HW_EMI_DDR_TEST_MODE_CSR_CLR)
#define HW_EMI_DDR_TEST_MODE_CSR_TOG_ADDR \
		(REGS_EMI_BASE + HW_EMI_DDR_TEST_MODE_CSR_TOG)

#define BP_EMI_DDR_TEST_MODE_CSR_RSVD1	2
#define BM_EMI_DDR_TEST_MODE_CSR_RSVD1	0xFFFFFFFC
#define BF_EMI_DDR_TEST_MODE_CSR_RSVD1(v) \
		(((v) << 2) & BM_EMI_DDR_TEST_MODE_CSR_RSVD1)
#define BM_EMI_DDR_TEST_MODE_CSR_DONE	0x00000002
#define BM_EMI_DDR_TEST_MODE_CSR_START	0x00000001

#define HW_EMI_DEBUG	(0x00000080)
#define HW_EMI_DEBUG_ADDR \
		(REGS_EMI_BASE + HW_EMI_DEBUG)

#define BP_EMI_DEBUG_RSVD1	4
#define BM_EMI_DEBUG_RSVD1	0xFFFFFFF0
#define BF_EMI_DEBUG_RSVD1(v) \
		(((v) << 4) & BM_EMI_DEBUG_RSVD1)
#define BP_EMI_DEBUG_NOR_STATE	0
#define BM_EMI_DEBUG_NOR_STATE	0x0000000F
#define BF_EMI_DEBUG_NOR_STATE(v)  \
		(((v) << 0) & BM_EMI_DEBUG_NOR_STATE)

#define HW_EMI_DDR_TEST_MODE_STATUS0	(0x00000090)
#define HW_EMI_DDR_TEST_MODE_STATUS0_ADDR \
		(REGS_EMI_BASE + HW_EMI_DDR_TEST_MODE_STATUS0)

#define BP_EMI_DDR_TEST_MODE_STATUS0_RSVD1	13
#define BM_EMI_DDR_TEST_MODE_STATUS0_RSVD1	0xFFFFE000
#define BF_EMI_DDR_TEST_MODE_STATUS0_RSVD1(v) \
		(((v) << 13) & BM_EMI_DDR_TEST_MODE_STATUS0_RSVD1)
#define BP_EMI_DDR_TEST_MODE_STATUS0_ADDR0	0
#define BM_EMI_DDR_TEST_MODE_STATUS0_ADDR0	0x00001FFF
#define BF_EMI_DDR_TEST_MODE_STATUS0_ADDR0(v)  \
		(((v) << 0) & BM_EMI_DDR_TEST_MODE_STATUS0_ADDR0)

#define HW_EMI_DDR_TEST_MODE_STATUS1	(0x000000a0)
#define HW_EMI_DDR_TEST_MODE_STATUS1_ADDR \
		(REGS_EMI_BASE + HW_EMI_DDR_TEST_MODE_STATUS1)

#define BP_EMI_DDR_TEST_MODE_STATUS1_RSVD1	13
#define BM_EMI_DDR_TEST_MODE_STATUS1_RSVD1	0xFFFFE000
#define BF_EMI_DDR_TEST_MODE_STATUS1_RSVD1(v) \
		(((v) << 13) & BM_EMI_DDR_TEST_MODE_STATUS1_RSVD1)
#define BP_EMI_DDR_TEST_MODE_STATUS1_ADDR1	0
#define BM_EMI_DDR_TEST_MODE_STATUS1_ADDR1	0x00001FFF
#define BF_EMI_DDR_TEST_MODE_STATUS1_ADDR1(v)  \
		(((v) << 0) & BM_EMI_DDR_TEST_MODE_STATUS1_ADDR1)

#define HW_EMI_DDR_TEST_MODE_STATUS2	(0x000000b0)
#define HW_EMI_DDR_TEST_MODE_STATUS2_ADDR \
		(REGS_EMI_BASE + HW_EMI_DDR_TEST_MODE_STATUS2)

#define BP_EMI_DDR_TEST_MODE_STATUS2_DATA0	0
#define BM_EMI_DDR_TEST_MODE_STATUS2_DATA0	0xFFFFFFFF
#define BF_EMI_DDR_TEST_MODE_STATUS2_DATA0(v)	(v)

#define HW_EMI_DDR_TEST_MODE_STATUS3	(0x000000c0)
#define HW_EMI_DDR_TEST_MODE_STATUS3_ADDR \
		(REGS_EMI_BASE + HW_EMI_DDR_TEST_MODE_STATUS3)

#define BP_EMI_DDR_TEST_MODE_STATUS3_DATA1	0
#define BM_EMI_DDR_TEST_MODE_STATUS3_DATA1	0xFFFFFFFF
#define BF_EMI_DDR_TEST_MODE_STATUS3_DATA1(v)	(v)

#define HW_EMI_VERSION	(0x000000f0)
#define HW_EMI_VERSION_ADDR \
		(REGS_EMI_BASE + HW_EMI_VERSION)

#define BP_EMI_VERSION_MAJOR	24
#define BM_EMI_VERSION_MAJOR	0xFF000000
#define BF_EMI_VERSION_MAJOR(v) \
		(((v) << 24) & BM_EMI_VERSION_MAJOR)
#define BP_EMI_VERSION_MINOR	16
#define BM_EMI_VERSION_MINOR	0x00FF0000
#define BF_EMI_VERSION_MINOR(v)  \
		(((v) << 16) & BM_EMI_VERSION_MINOR)
#define BP_EMI_VERSION_STEP	0
#define BM_EMI_VERSION_STEP	0x0000FFFF
#define BF_EMI_VERSION_STEP(v)  \
		(((v) << 0) & BM_EMI_VERSION_STEP)
#endif /* __ARCH_ARM___EMI_H */
