/*
 * Copyright 2005-2007 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

/*
 * @file ipu_regs.h
 *
 * @brief IPU Register definitions
 *
 * @ingroup IPU
 */
#ifndef __IPU_REGS_INCLUDED__
#define __IPU_REGS_INCLUDED__

#define IPU_REG_BASE    IO_ADDRESS(IPU_CTRL_BASE_ADDR)

/* Register addresses */
/* IPU Common registers */
#define IPU_CONF                (IPU_REG_BASE + 0x0000)
#define IPU_CHA_BUF0_RDY        (IPU_REG_BASE + 0x0004)
#define IPU_CHA_BUF1_RDY        (IPU_REG_BASE + 0x0008)
#define IPU_CHA_DB_MODE_SEL     (IPU_REG_BASE + 0x000C)
#define IPU_CHA_CUR_BUF         (IPU_REG_BASE + 0x0010)
#define IPU_FS_PROC_FLOW        (IPU_REG_BASE + 0x0014)
#define IPU_FS_DISP_FLOW        (IPU_REG_BASE + 0x0018)
#define IPU_TASKS_STAT          (IPU_REG_BASE + 0x001C)
#define IPU_IMA_ADDR            (IPU_REG_BASE + 0x0020)
#define IPU_IMA_DATA            (IPU_REG_BASE + 0x0024)
#define IPU_INT_CTRL_1          (IPU_REG_BASE + 0x0028)
#define IPU_INT_CTRL_2          (IPU_REG_BASE + 0x002C)
#define IPU_INT_CTRL_3          (IPU_REG_BASE + 0x0030)
#define IPU_INT_CTRL_4          (IPU_REG_BASE + 0x0034)
#define IPU_INT_CTRL_5          (IPU_REG_BASE + 0x0038)
#define IPU_INT_STAT_1          (IPU_REG_BASE + 0x003C)
#define IPU_INT_STAT_2          (IPU_REG_BASE + 0x0040)
#define IPU_INT_STAT_3          (IPU_REG_BASE + 0x0044)
#define IPU_INT_STAT_4          (IPU_REG_BASE + 0x0048)
#define IPU_INT_STAT_5          (IPU_REG_BASE + 0x004C)
#define IPU_BRK_CTRL_1          (IPU_REG_BASE + 0x0050)
#define IPU_BRK_CTRL_2          (IPU_REG_BASE + 0x0054)
#define IPU_BRK_STAT            (IPU_REG_BASE + 0x0058)
#define IPU_DIAGB_CTRL          (IPU_REG_BASE + 0x005C)
/* CMOS Sensor Interface Registers */
#define CSI_SENS_CONF           (IPU_REG_BASE + 0x0060)
#define CSI_SENS_FRM_SIZE       (IPU_REG_BASE + 0x0064)
#define CSI_ACT_FRM_SIZE        (IPU_REG_BASE + 0x0068)
#define CSI_OUT_FRM_CTRL        (IPU_REG_BASE + 0x006C)
#define CSI_TST_CTRL            (IPU_REG_BASE + 0x0070)
#define CSI_CCIR_CODE_1         (IPU_REG_BASE + 0x0074)
#define CSI_CCIR_CODE_2         (IPU_REG_BASE + 0x0078)
#define CSI_CCIR_CODE_3         (IPU_REG_BASE + 0x007C)
#define CSI_FLASH_STROBE_1      (IPU_REG_BASE + 0x0080)
#define CSI_FLASH_STROBE_2      (IPU_REG_BASE + 0x0084)
/* Image Converter Registers */
#define IC_CONF                 (IPU_REG_BASE + 0x0088)
#define IC_PRP_ENC_RSC          (IPU_REG_BASE + 0x008C)
#define IC_PRP_VF_RSC           (IPU_REG_BASE + 0x0090)
#define IC_PP_RSC               (IPU_REG_BASE + 0x0094)
#define IC_CMBP_1               (IPU_REG_BASE + 0x0098)
#define IC_CMBP_2               (IPU_REG_BASE + 0x009C)
#define PF_CONF                 (IPU_REG_BASE + 0x00A0)
#define IDMAC_CONF              (IPU_REG_BASE + 0x00A4)
#define IDMAC_CHA_EN            (IPU_REG_BASE + 0x00A8)
#define IDMAC_CHA_PRI           (IPU_REG_BASE + 0x00AC)
#define IDMAC_CHA_BUSY          (IPU_REG_BASE + 0x00B0)
/* SDC Registers */
#define SDC_COM_CONF            (IPU_REG_BASE + 0x00B4)
#define SDC_GW_CTRL             (IPU_REG_BASE + 0x00B8)
#define SDC_FG_POS              (IPU_REG_BASE + 0x00BC)
#define SDC_BG_POS              (IPU_REG_BASE + 0x00C0)
#define SDC_CUR_POS             (IPU_REG_BASE + 0x00C4)
#define SDC_PWM_CTRL            (IPU_REG_BASE + 0x00C8)
#define SDC_CUR_MAP             (IPU_REG_BASE + 0x00CC)
#define SDC_HOR_CONF            (IPU_REG_BASE + 0x00D0)
#define SDC_VER_CONF            (IPU_REG_BASE + 0x00D4)
#define SDC_SHARP_CONF_1        (IPU_REG_BASE + 0x00D8)
#define SDC_SHARP_CONF_2        (IPU_REG_BASE + 0x00DC)
/* ADC Registers */
#define ADC_CONF                (IPU_REG_BASE + 0x00E0)
#define ADC_SYSCHA1_SA          (IPU_REG_BASE + 0x00E4)
#define ADC_SYSCHA2_SA          (IPU_REG_BASE + 0x00E8)
#define ADC_PRPCHAN_SA          (IPU_REG_BASE + 0x00EC)
#define ADC_PPCHAN_SA           (IPU_REG_BASE + 0x00F0)
#define ADC_DISP0_CONF          (IPU_REG_BASE + 0x00F4)
#define ADC_DISP0_RD_AP         (IPU_REG_BASE + 0x00F8)
#define ADC_DISP0_RDM           (IPU_REG_BASE + 0x00FC)
#define ADC_DISP0_SS            (IPU_REG_BASE + 0x0100)
#define ADC_DISP1_CONF          (IPU_REG_BASE + 0x0104)
#define ADC_DISP1_RD_AP         (IPU_REG_BASE + 0x0108)
#define ADC_DISP1_RDM           (IPU_REG_BASE + 0x010C)
#define ADC_DISP12_SS           (IPU_REG_BASE + 0x0110)
#define ADC_DISP2_CONF          (IPU_REG_BASE + 0x0114)
#define ADC_DISP2_RD_AP         (IPU_REG_BASE + 0x0118)
#define ADC_DISP2_RDM           (IPU_REG_BASE + 0x011C)
#define ADC_DISP_VSYNC          (IPU_REG_BASE + 0x0120)
/* Display Interface re(sters */
#define DI_DISP_IF_CONF         (IPU_REG_BASE + 0x0124)
#define DI_DISP_SIG_POL         (IPU_REG_BASE + 0x0128)
#define DI_SER_DISP1_CONF       (IPU_REG_BASE + 0x012C)
#define DI_SER_DISP2_CONF       (IPU_REG_BASE + 0x0130)
#define DI_HSP_CLK_PER          (IPU_REG_BASE + 0x0134)
#define DI_DISP0_TIME_CONF_1    (IPU_REG_BASE + 0x0138)
#define DI_DISP0_TIME_CONF_2    (IPU_REG_BASE + 0x013C)
#define DI_DISP0_TIME_CONF_3    (IPU_REG_BASE + 0x0140)
#define DI_DISP1_TIME_CONF_1    (IPU_REG_BASE + 0x0144)
#define DI_DISP1_TIME_CONF_2    (IPU_REG_BASE + 0x0148)
#define DI_DISP1_TIME_CONF_3    (IPU_REG_BASE + 0x014C)
#define DI_DISP2_TIME_CONF_1    (IPU_REG_BASE + 0x0150)
#define DI_DISP2_TIME_CONF_2    (IPU_REG_BASE + 0x0154)
#define DI_DISP2_TIME_CONF_3    (IPU_REG_BASE + 0x0158)
#define DI_DISP3_TIME_CONF      (IPU_REG_BASE + 0x015C)
#define DI_DISP0_DB0_MAP        (IPU_REG_BASE + 0x0160)
#define DI_DISP0_DB1_MAP        (IPU_REG_BASE + 0x0164)
#define DI_DISP0_DB2_MAP        (IPU_REG_BASE + 0x0168)
#define DI_DISP0_CB0_MAP        (IPU_REG_BASE + 0x016C)
#define DI_DISP0_CB1_MAP        (IPU_REG_BASE + 0x0170)
#define DI_DISP0_CB2_MAP        (IPU_REG_BASE + 0x0174)
#define DI_DISP1_DB0_MAP        (IPU_REG_BASE + 0x0178)
#define DI_DISP1_DB1_MAP        (IPU_REG_BASE + 0x017C)
#define DI_DISP1_DB2_MAP        (IPU_REG_BASE + 0x0180)
#define DI_DISP1_CB0_MAP        (IPU_REG_BASE + 0x0184)
#define DI_DISP1_CB1_MAP        (IPU_REG_BASE + 0x0188)
#define DI_DISP1_CB2_MAP        (IPU_REG_BASE + 0x018C)
#define DI_DISP2_DB0_MAP        (IPU_REG_BASE + 0x0190)
#define DI_DISP2_DB1_MAP        (IPU_REG_BASE + 0x0194)
#define DI_DISP2_DB2_MAP        (IPU_REG_BASE + 0x0198)
#define DI_DISP2_CB0_MAP        (IPU_REG_BASE + 0x019C)
#define DI_DISP2_CB1_MAP        (IPU_REG_BASE + 0x01A0)
#define DI_DISP2_CB2_MAP        (IPU_REG_BASE + 0x01A4)
#define DI_DISP3_B0_MAP         (IPU_REG_BASE + 0x01A8)
#define DI_DISP3_B1_MAP         (IPU_REG_BASE + 0x01AC)
#define DI_DISP3_B2_MAP         (IPU_REG_BASE + 0x01B0)
#define DI_DISP_ACC_CC          (IPU_REG_BASE + 0x01B4)
#define DI_DISP_LLA_CONF        (IPU_REG_BASE + 0x01B8)
#define DI_DISP_LLA_DATA        (IPU_REG_BASE + 0x01BC)

#define IPUIRQ_2_STATREG(int)   (IPU_INT_STAT_1 + 4*(int>>5))
#define IPUIRQ_2_CTRLREG(int)   (IPU_INT_CTRL_1 + 4*(int>>5))
#define IPUIRQ_2_MASK(int)      (1UL << (int & 0x1F))

enum {
	IPU_CONF_CSI_EN = 0x00000001,
	IPU_CONF_IC_EN = 0x00000002,
	IPU_CONF_ROT_EN = 0x00000004,
	IPU_CONF_PF_EN = 0x00000008,
	IPU_CONF_SDC_EN = 0x00000010,
	IPU_CONF_ADC_EN = 0x00000020,
	IPU_CONF_DI_EN = 0x00000040,
	IPU_CONF_DU_EN = 0x00000080,
	IPU_CONF_PXL_ENDIAN = 0x00000100,

	FS_PRPVF_ROT_SRC_SEL = 0x00000040,
	FS_PRPENC_ROT_SRC_SEL = 0x00000020,
	FS_PRPENC_DEST_SEL = 0x00000010,
	FS_PP_SRC_SEL_MASK = 0x00000300,
	FS_PP_SRC_SEL_OFFSET = 8,
	FS_PP_ROT_SRC_SEL_MASK = 0x00000C00,
	FS_PP_ROT_SRC_SEL_OFFSET = 10,
	FS_PF_DEST_SEL_MASK = 0x00003000,
	FS_PF_DEST_SEL_OFFSET = 12,
	FS_PRPVF_DEST_SEL_MASK = 0x00070000,
	FS_PRPVF_DEST_SEL_OFFSET = 16,
	FS_PRPVF_ROT_DEST_SEL_MASK = 0x00700000,
	FS_PRPVF_ROT_DEST_SEL_OFFSET = 20,
	FS_PP_DEST_SEL_MASK = 0x07000000,
	FS_PP_DEST_SEL_OFFSET = 24,
	FS_PP_ROT_DEST_SEL_MASK = 0x70000000,
	FS_PP_ROT_DEST_SEL_OFFSET = 28,
	FS_VF_IN_VALID = 0x00000002,
	FS_ENC_IN_VALID = 0x00000001,

	FS_SDC_BG_SRC_SEL_MASK = 0x00000007,
	FS_SDC_BG_SRC_SEL_OFFSET = 0,
	FS_SDC_FG_SRC_SEL_MASK = 0x00000070,
	FS_SDC_FG_SRC_SEL_OFFSET = 4,
	FS_ADC1_SRC_SEL_MASK = 0x00000700,
	FS_ADC1_SRC_SEL_OFFSET = 8,
	FS_ADC2_SRC_SEL_MASK = 0x00007000,
	FS_ADC2_SRC_SEL_OFFSET = 12,
	FS_AUTO_REF_PER_MASK = 0x03FF0000,
	FS_AUTO_REF_PER_OFFSET = 16,

	FS_DEST_ARM = 0,
	FS_DEST_ROT = 1,
	FS_DEST_PP = 1,
	FS_DEST_ADC1 = 2,
	FS_DEST_ADC2 = 3,
	FS_DEST_SDC_BG = 4,
	FS_DEST_SDC_FG = 5,
	FS_DEST_ADC = 6,

	FS_SRC_ARM = 0,
	FS_PP_SRC_PF = 1,
	FS_PP_SRC_ROT = 2,

	FS_ROT_SRC_PP = 1,
	FS_ROT_SRC_PF = 2,

	FS_PF_DEST_PP = 1,
	FS_PF_DEST_ROT = 2,

	FS_SRC_ROT_VF = 1,
	FS_SRC_ROT_PP = 2,
	FS_SRC_VF = 3,
	FS_SRC_PP = 4,
	FS_SRC_SNOOP = 5,
	FS_SRC_AUTOREF = 6,
	FS_SRC_AUTOREF_SNOOP = 7,

	TSTAT_PF_H264_PAUSE = 0x00000001,
	TSTAT_CSI2MEM_MASK = 0x0000000C,
	TSTAT_CSI2MEM_OFFSET = 2,
	TSTAT_VF_MASK = 0x00000600,
	TSTAT_VF_OFFSET = 9,
	TSTAT_VF_ROT_MASK = 0x000C0000,
	TSTAT_VF_ROT_OFFSET = 18,
	TSTAT_ENC_MASK = 0x00000180,
	TSTAT_ENC_OFFSET = 7,
	TSTAT_ENC_ROT_MASK = 0x00030000,
	TSTAT_ENC_ROT_OFFSET = 16,
	TSTAT_PP_MASK = 0x00001800,
	TSTAT_PP_OFFSET = 11,
	TSTAT_PP_ROT_MASK = 0x00300000,
	TSTAT_PP_ROT_OFFSET = 20,
	TSTAT_PF_MASK = 0x00C00000,
	TSTAT_PF_OFFSET = 22,
	TSTAT_ADCSYS1_MASK = 0x03000000,
	TSTAT_ADCSYS1_OFFSET = 24,
	TSTAT_ADCSYS2_MASK = 0x0C000000,
	TSTAT_ADCSYS2_OFFSET = 26,

	TASK_STAT_IDLE = 0,
	TASK_STAT_ACTIVE = 1,
	TASK_STAT_WAIT4READY = 2,

	/* Register bits */
	SDC_COM_TFT_COLOR = 0x00000001UL,
	SDC_COM_FG_EN = 0x00000010UL,
	SDC_COM_GWSEL = 0x00000020UL,
	SDC_COM_GLB_A = 0x00000040UL,
	SDC_COM_KEY_COLOR_G = 0x00000080UL,
	SDC_COM_BG_EN = 0x00000200UL,
	SDC_COM_SHARP = 0x00001000UL,

	SDC_V_SYNC_WIDTH_L = 0x00000001UL,

	ADC_CONF_PRP_EN = 0x00000001L,
	ADC_CONF_PP_EN = 0x00000002L,
	ADC_CONF_MCU_EN = 0x00000004L,

	ADC_DISP_CONF_SL_MASK = 0x00000FFFL,
	ADC_DISP_CONF_TYPE_MASK = 0x00003000L,
	ADC_DISP_CONF_TYPE_XY = 0x00002000L,

	ADC_DISP_VSYNC_D0_MODE_MASK = 0x00000003L,
	ADC_DISP_VSYNC_D0_WIDTH_MASK = 0x003F0000L,
	ADC_DISP_VSYNC_D12_MODE_MASK = 0x0000000CL,
	ADC_DISP_VSYNC_D12_WIDTH_MASK = 0x3F000000L,

	/* Image Converter Register bits */
	IC_CONF_PRPENC_EN = 0x00000001,
	IC_CONF_PRPENC_CSC1 = 0x00000002,
	IC_CONF_PRPENC_ROT_EN = 0x00000004,
	IC_CONF_PRPVF_EN = 0x00000100,
	IC_CONF_PRPVF_CSC1 = 0x00000200,
	IC_CONF_PRPVF_CSC2 = 0x00000400,
	IC_CONF_PRPVF_CMB = 0x00000800,
	IC_CONF_PRPVF_ROT_EN = 0x00001000,
	IC_CONF_PP_EN = 0x00010000,
	IC_CONF_PP_CSC1 = 0x00020000,
	IC_CONF_PP_CSC2 = 0x00040000,
	IC_CONF_PP_CMB = 0x00080000,
	IC_CONF_PP_ROT_EN = 0x00100000,
	IC_CONF_IC_GLB_LOC_A = 0x10000000,
	IC_CONF_KEY_COLOR_EN = 0x20000000,
	IC_CONF_RWS_EN = 0x40000000,
	IC_CONF_CSI_MEM_WR_EN = 0x80000000,

	IDMA_CHAN_INVALID = 0x000000FF,
	IDMA_IC_0 = 0x00000001,
	IDMA_IC_1 = 0x00000002,
	IDMA_IC_2 = 0x00000004,
	IDMA_IC_3 = 0x00000008,
	IDMA_IC_4 = 0x00000010,
	IDMA_IC_5 = 0x00000020,
	IDMA_IC_6 = 0x00000040,
	IDMA_IC_7 = 0x00000080,
	IDMA_IC_8 = 0x00000100,
	IDMA_IC_9 = 0x00000200,
	IDMA_IC_10 = 0x00000400,
	IDMA_IC_11 = 0x00000800,
	IDMA_IC_12 = 0x00001000,
	IDMA_IC_13 = 0x00002000,
	IDMA_SDC_BG = 0x00004000,
	IDMA_SDC_FG = 0x00008000,
	IDMA_SDC_MASK = 0x00010000,
	IDMA_SDC_PARTIAL = 0x00020000,
	IDMA_ADC_SYS1_WR = 0x00040000,
	IDMA_ADC_SYS2_WR = 0x00080000,
	IDMA_ADC_SYS1_CMD = 0x00100000,
	IDMA_ADC_SYS2_CMD = 0x00200000,
	IDMA_ADC_SYS1_RD = 0x00400000,
	IDMA_ADC_SYS2_RD = 0x00800000,
	IDMA_PF_QP = 0x01000000,
	IDMA_PF_BSP = 0x02000000,
	IDMA_PF_Y_IN = 0x04000000,
	IDMA_PF_U_IN = 0x08000000,
	IDMA_PF_V_IN = 0x10000000,
	IDMA_PF_Y_OUT = 0x20000000,
	IDMA_PF_U_OUT = 0x40000000,
	IDMA_PF_V_OUT = 0x80000000,

	CSI_SENS_CONF_DATA_FMT_SHIFT = 8,
	CSI_SENS_CONF_DATA_FMT_RGB_YUV444 = 0x00000000L,
	CSI_SENS_CONF_DATA_FMT_YUV422 = 0x00000200L,
	CSI_SENS_CONF_DATA_FMT_BAYER = 0x00000300L,

	CSI_SENS_CONF_VSYNC_POL_SHIFT = 0,
	CSI_SENS_CONF_HSYNC_POL_SHIFT = 1,
	CSI_SENS_CONF_DATA_POL_SHIFT = 2,
	CSI_SENS_CONF_PIX_CLK_POL_SHIFT = 3,
	CSI_SENS_CONF_SENS_PRTCL_SHIFT = 4,
	CSI_SENS_CONF_SENS_CLKSRC_SHIFT = 7,
	CSI_SENS_CONF_DATA_WIDTH_SHIFT = 10,
	CSI_SENS_CONF_EXT_VSYNC_SHIFT = 15,
	CSI_SENS_CONF_DIVRATIO_SHIFT = 16,

	PF_CONF_TYPE_MASK = 0x00000007,
	PF_CONF_TYPE_SHIFT = 0,
	PF_CONF_PAUSE_EN = 0x00000010,
	PF_CONF_RESET = 0x00008000,
	PF_CONF_PAUSE_ROW_MASK = 0x00FF0000,
	PF_CONF_PAUSE_ROW_SHIFT = 16,

	/* DI_DISP_SIG_POL bits */
	DI_D3_VSYNC_POL_SHIFT = 28,
	DI_D3_HSYNC_POL_SHIFT = 27,
	DI_D3_DRDY_SHARP_POL_SHIFT = 26,
	DI_D3_CLK_POL_SHIFT = 25,
	DI_D3_DATA_POL_SHIFT = 24,

	/* DI_DISP_IF_CONF bits */
	DI_D3_CLK_IDLE_SHIFT = 26,
	DI_D3_CLK_SEL_SHIFT = 25,
	DI_D3_DATAMSK_SHIFT = 24,

	DISPx_IF_CLK_DOWN_OFFSET = 22,
	DISPx_IF_CLK_UP_OFFSET = 12,
	DISPx_IF_CLK_PER_OFFSET = 0,
	DISPx_IF_CLK_READ_EN_OFFSET = 16,
	DISPx_PIX_CLK_PER_OFFSET = 0,

	DI_CONF_DISP0_EN = 0x00000001L,
	DI_CONF_DISP0_IF_MODE_OFFSET = 1,
	DI_CONF_DISP0_BURST_MODE_OFFSET = 3,
	DI_CONF_DISP1_EN = 0x00000100L,
	DI_CONF_DISP1_IF_MODE_OFFSET = 9,
	DI_CONF_DISP1_BURST_MODE_OFFSET = 12,
	DI_CONF_DISP2_EN = 0x00010000L,
	DI_CONF_DISP2_IF_MODE_OFFSET = 17,
	DI_CONF_DISP2_BURST_MODE_OFFSET = 20,

	DI_SER_DISPx_CONF_SER_BIT_NUM_OFFSET = 16,
	DI_SER_DISPx_CONF_PREAMBLE_OFFSET = 8,
	DI_SER_DISPx_CONF_PREAMBLE_LEN_OFFSET = 4,
	DI_SER_DISPx_CONF_RW_CFG_OFFSET = 1,
	DI_SER_DISPx_CONF_BURST_MODE_EN = 0x01000000L,
	DI_SER_DISPx_CONF_PREAMBLE_EN = 0x00000001L,

	/* DI_DISP_ACC_CC */
	DISP0_IF_CLK_CNT_D_MASK = 0x00000003L,
	DISP0_IF_CLK_CNT_D_OFFSET = 0,
	DISP0_IF_CLK_CNT_C_MASK = 0x0000000CL,
	DISP0_IF_CLK_CNT_C_OFFSET = 2,
	DISP1_IF_CLK_CNT_D_MASK = 0x00000030L,
	DISP1_IF_CLK_CNT_D_OFFSET = 4,
	DISP1_IF_CLK_CNT_C_MASK = 0x000000C0L,
	DISP1_IF_CLK_CNT_C_OFFSET = 6,
	DISP2_IF_CLK_CNT_D_MASK = 0x00000300L,
	DISP2_IF_CLK_CNT_D_OFFSET = 8,
	DISP2_IF_CLK_CNT_C_MASK = 0x00000C00L,
	DISP2_IF_CLK_CNT_C_OFFSET = 10,
	DISP3_IF_CLK_CNT_MASK = 0x00003000L,
	DISP3_IF_CLK_CNT_OFFSET = 12,
};

#endif
