/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.proxy;

import org.mockito.asm.Type;
import org.mockito.cglib.proxy.Callback;
import org.mockito.cglib.proxy.CallbackGenerator;
import org.mockito.cglib.proxy.Dispatcher;
import org.mockito.cglib.proxy.DispatcherGenerator;
import org.mockito.cglib.proxy.FixedValue;
import org.mockito.cglib.proxy.FixedValueGenerator;
import org.mockito.cglib.proxy.InvocationHandler;
import org.mockito.cglib.proxy.InvocationHandlerGenerator;
import org.mockito.cglib.proxy.LazyLoader;
import org.mockito.cglib.proxy.LazyLoaderGenerator;
import org.mockito.cglib.proxy.MethodInterceptor;
import org.mockito.cglib.proxy.MethodInterceptorGenerator;
import org.mockito.cglib.proxy.NoOp;
import org.mockito.cglib.proxy.NoOpGenerator;
import org.mockito.cglib.proxy.ProxyRefDispatcher;

class CallbackInfo {
    private Class cls;
    private CallbackGenerator generator;
    private Type type;
    private static final CallbackInfo[] CALLBACKS = new CallbackInfo[]{new CallbackInfo(NoOp.class, NoOpGenerator.INSTANCE), new CallbackInfo(MethodInterceptor.class, MethodInterceptorGenerator.INSTANCE), new CallbackInfo(InvocationHandler.class, InvocationHandlerGenerator.INSTANCE), new CallbackInfo(LazyLoader.class, LazyLoaderGenerator.INSTANCE), new CallbackInfo(Dispatcher.class, DispatcherGenerator.INSTANCE), new CallbackInfo(FixedValue.class, FixedValueGenerator.INSTANCE), new CallbackInfo(ProxyRefDispatcher.class, DispatcherGenerator.PROXY_REF_INSTANCE)};

    public static Type[] determineTypes(Class[] classArray) {
        Type[] typeArray = new Type[classArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i] = CallbackInfo.determineType(classArray[i]);
        }
        return typeArray;
    }

    public static Type[] determineTypes(Callback[] callbackArray) {
        Type[] typeArray = new Type[callbackArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i] = CallbackInfo.determineType(callbackArray[i]);
        }
        return typeArray;
    }

    public static CallbackGenerator[] getGenerators(Type[] typeArray) {
        CallbackGenerator[] callbackGeneratorArray = new CallbackGenerator[typeArray.length];
        for (int i = 0; i < callbackGeneratorArray.length; ++i) {
            callbackGeneratorArray[i] = CallbackInfo.getGenerator(typeArray[i]);
        }
        return callbackGeneratorArray;
    }

    private CallbackInfo(Class clazz, CallbackGenerator callbackGenerator) {
        this.cls = clazz;
        this.generator = callbackGenerator;
        this.type = Type.getType(clazz);
    }

    private static Type determineType(Callback callback) {
        if (callback == null) {
            throw new IllegalStateException("Callback is null");
        }
        return CallbackInfo.determineType(callback.getClass());
    }

    private static Type determineType(Class clazz) {
        Class clazz2 = null;
        for (int i = 0; i < CALLBACKS.length; ++i) {
            CallbackInfo callbackInfo = CALLBACKS[i];
            if (!callbackInfo.cls.isAssignableFrom(clazz)) continue;
            if (clazz2 != null) {
                throw new IllegalStateException("Callback implements both " + clazz2 + " and " + callbackInfo.cls);
            }
            clazz2 = callbackInfo.cls;
        }
        if (clazz2 == null) {
            throw new IllegalStateException("Unknown callback type " + clazz);
        }
        return Type.getType(clazz2);
    }

    private static CallbackGenerator getGenerator(Type type) {
        for (int i = 0; i < CALLBACKS.length; ++i) {
            CallbackInfo callbackInfo = CALLBACKS[i];
            if (!callbackInfo.type.equals(type)) continue;
            return callbackInfo.generator;
        }
        throw new IllegalStateException("Unknown callback type " + type);
    }
}

