/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.proxy;

import java.util.List;
import org.mockito.asm.Type;
import org.mockito.cglib.core.Block;
import org.mockito.cglib.core.ClassEmitter;
import org.mockito.cglib.core.CodeEmitter;
import org.mockito.cglib.core.EmitUtils;
import org.mockito.cglib.core.MethodInfo;
import org.mockito.cglib.core.Signature;
import org.mockito.cglib.core.TypeUtils;
import org.mockito.cglib.proxy.CallbackGenerator;

class InvocationHandlerGenerator
implements CallbackGenerator {
    public static final InvocationHandlerGenerator INSTANCE = new InvocationHandlerGenerator();
    private static final Type INVOCATION_HANDLER = TypeUtils.parseType("org.mockito.cglib.proxy.InvocationHandler");
    private static final Type UNDECLARED_THROWABLE_EXCEPTION = TypeUtils.parseType("org.mockito.cglib.proxy.UndeclaredThrowableException");
    private static final Type METHOD = TypeUtils.parseType("java.lang.reflect.Method");
    private static final Signature INVOKE = TypeUtils.parseSignature("Object invoke(Object, java.lang.reflect.Method, Object[])");

    InvocationHandlerGenerator() {
    }

    @Override
    public void generate(ClassEmitter classEmitter, CallbackGenerator.Context context, List list) {
        for (MethodInfo methodInfo : list) {
            Signature signature = context.getImplSignature(methodInfo);
            classEmitter.declare_field(26, signature.getName(), METHOD, null);
            CodeEmitter codeEmitter = context.beginMethod(classEmitter, methodInfo);
            Block block = codeEmitter.begin_block();
            context.emitCallback(codeEmitter, context.getIndex(methodInfo));
            codeEmitter.load_this();
            codeEmitter.getfield(signature.getName());
            codeEmitter.create_arg_array();
            codeEmitter.invoke_interface(INVOCATION_HANDLER, INVOKE);
            codeEmitter.unbox(methodInfo.getSignature().getReturnType());
            codeEmitter.return_value();
            block.end();
            EmitUtils.wrap_undeclared_throwable(codeEmitter, block, methodInfo.getExceptionTypes(), UNDECLARED_THROWABLE_EXCEPTION);
            codeEmitter.end_method();
        }
    }

    @Override
    public void generateStatic(CodeEmitter codeEmitter, CallbackGenerator.Context context, List list) {
        for (MethodInfo methodInfo : list) {
            EmitUtils.load_method(codeEmitter, methodInfo);
            codeEmitter.putfield(context.getImplSignature(methodInfo).getName());
        }
    }
}

