/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.proxy;

import java.lang.reflect.Method;
import java.util.HashSet;
import org.mockito.asm.ClassVisitor;
import org.mockito.asm.Type;
import org.mockito.cglib.core.ClassEmitter;
import org.mockito.cglib.core.CodeEmitter;
import org.mockito.cglib.core.Constants;
import org.mockito.cglib.core.EmitUtils;
import org.mockito.cglib.core.MethodInfo;
import org.mockito.cglib.core.MethodWrapper;
import org.mockito.cglib.core.ReflectUtils;
import org.mockito.cglib.core.Signature;
import org.mockito.cglib.core.TypeUtils;

class MixinEmitter
extends ClassEmitter {
    private static final String FIELD_NAME = "CGLIB$DELEGATES";
    private static final Signature CSTRUCT_OBJECT_ARRAY = TypeUtils.parseConstructor("Object[]");
    private static final Type MIXIN = TypeUtils.parseType("org.mockito.cglib.proxy.Mixin");
    private static final Signature NEW_INSTANCE = new Signature("newInstance", MIXIN, new Type[]{Constants.TYPE_OBJECT_ARRAY});

    public MixinEmitter(ClassVisitor classVisitor, String string, Class[] classArray, int[] nArray) {
        super(classVisitor);
        this.begin_class(46, 1, string, MIXIN, TypeUtils.getTypes(this.getInterfaces(classArray)), "<generated>");
        EmitUtils.null_constructor(this);
        EmitUtils.factory_method(this, NEW_INSTANCE);
        this.declare_field(2, FIELD_NAME, Constants.TYPE_OBJECT_ARRAY, null);
        CodeEmitter codeEmitter = this.begin_method(1, CSTRUCT_OBJECT_ARRAY, null);
        codeEmitter.load_this();
        codeEmitter.super_invoke_constructor();
        codeEmitter.load_this();
        codeEmitter.load_arg(0);
        codeEmitter.putfield(FIELD_NAME);
        codeEmitter.return_value();
        codeEmitter.end_method();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < classArray.length; ++i) {
            Method[] methodArray = this.getMethods(classArray[i]);
            for (int j = 0; j < methodArray.length; ++j) {
                if (!hashSet.add(MethodWrapper.create(methodArray[j]))) continue;
                MethodInfo methodInfo = ReflectUtils.getMethodInfo(methodArray[j]);
                codeEmitter = EmitUtils.begin_method(this, methodInfo, 1);
                codeEmitter.load_this();
                codeEmitter.getfield(FIELD_NAME);
                codeEmitter.aaload(nArray != null ? nArray[i] : i);
                codeEmitter.checkcast(methodInfo.getClassInfo().getType());
                codeEmitter.load_args();
                codeEmitter.invoke(methodInfo);
                codeEmitter.return_value();
                codeEmitter.end_method();
            }
        }
        this.end_class();
    }

    protected Class[] getInterfaces(Class[] classArray) {
        return classArray;
    }

    protected Method[] getMethods(Class clazz) {
        return clazz.getMethods();
    }
}

