/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.mockito.asm.ClassVisitor;
import org.mockito.asm.Type;
import org.mockito.cglib.core.AbstractClassGenerator;
import org.mockito.cglib.core.ClassEmitter;
import org.mockito.cglib.core.CodeEmitter;
import org.mockito.cglib.core.EmitUtils;
import org.mockito.cglib.core.KeyFactory;
import org.mockito.cglib.core.ReflectUtils;
import org.mockito.cglib.core.TypeUtils;

public abstract class ConstructorDelegate {
    private static final ConstructorKey KEY_FACTORY = (ConstructorKey)((Object)KeyFactory.create(ConstructorKey.class, KeyFactory.CLASS_BY_NAME));

    protected ConstructorDelegate() {
    }

    public static ConstructorDelegate create(Class clazz, Class clazz2) {
        Generator generator = new Generator();
        generator.setTargetClass(clazz);
        generator.setInterface(clazz2);
        return generator.create();
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(ConstructorDelegate.class.getName());
        private static final Type CONSTRUCTOR_DELEGATE = TypeUtils.parseType("org.mockito.cglib.reflect.ConstructorDelegate");
        private Class iface;
        private Class targetClass;

        public Generator() {
            super(SOURCE);
        }

        public void setInterface(Class clazz) {
            this.iface = clazz;
        }

        public void setTargetClass(Class clazz) {
            this.targetClass = clazz;
        }

        public ConstructorDelegate create() {
            this.setNamePrefix(this.targetClass.getName());
            Object object = KEY_FACTORY.newInstance(this.iface.getName(), this.targetClass.getName());
            return (ConstructorDelegate)super.create(object);
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.targetClass.getClassLoader();
        }

        @Override
        public void generateClass(ClassVisitor classVisitor) {
            Constructor constructor;
            this.setNamePrefix(this.targetClass.getName());
            Method method = ReflectUtils.findNewInstance(this.iface);
            if (!method.getReturnType().isAssignableFrom(this.targetClass)) {
                throw new IllegalArgumentException("incompatible return type");
            }
            try {
                constructor = this.targetClass.getDeclaredConstructor(method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException("interface does not match any known constructor");
            }
            ClassEmitter classEmitter = new ClassEmitter(classVisitor);
            classEmitter.begin_class(46, 1, this.getClassName(), CONSTRUCTOR_DELEGATE, new Type[]{Type.getType(this.iface)}, "<generated>");
            Type type = Type.getType(constructor.getDeclaringClass());
            EmitUtils.null_constructor(classEmitter);
            CodeEmitter codeEmitter = classEmitter.begin_method(1, ReflectUtils.getSignature(method), ReflectUtils.getExceptionTypes(method));
            codeEmitter.new_instance(type);
            codeEmitter.dup();
            codeEmitter.load_args();
            codeEmitter.invoke_constructor(type, ReflectUtils.getSignature(constructor));
            codeEmitter.return_value();
            codeEmitter.end_method();
            classEmitter.end_class();
        }

        @Override
        protected Object firstInstance(Class clazz) {
            return ReflectUtils.newInstance(clazz);
        }

        @Override
        protected Object nextInstance(Object object) {
            return object;
        }
    }

    static interface ConstructorKey {
        public Object newInstance(String var1, String var2);
    }
}

