/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mockito.asm.ClassVisitor;
import org.mockito.asm.Type;
import org.mockito.cglib.core.AbstractClassGenerator;
import org.mockito.cglib.core.Constants;
import org.mockito.cglib.core.ReflectUtils;
import org.mockito.cglib.core.Signature;
import org.mockito.cglib.reflect.FastClassEmitter;
import org.mockito.cglib.reflect.FastConstructor;
import org.mockito.cglib.reflect.FastMethod;

public abstract class FastClass {
    private Class type;

    protected FastClass() {
        throw new Error("Using the FastClass empty constructor--please report to the cglib-devel mailing list");
    }

    protected FastClass(Class clazz) {
        this.type = clazz;
    }

    public static FastClass create(Class clazz) {
        return FastClass.create(clazz.getClassLoader(), clazz);
    }

    public static FastClass create(ClassLoader classLoader, Class clazz) {
        Generator generator = new Generator();
        generator.setType(clazz);
        generator.setClassLoader(classLoader);
        return generator.create();
    }

    public Object invoke(String string, Class[] classArray, Object object, Object[] objectArray) throws InvocationTargetException {
        return this.invoke(this.getIndex(string, classArray), object, objectArray);
    }

    public Object newInstance() throws InvocationTargetException {
        return this.newInstance(this.getIndex(Constants.EMPTY_CLASS_ARRAY), null);
    }

    public Object newInstance(Class[] classArray, Object[] objectArray) throws InvocationTargetException {
        return this.newInstance(this.getIndex(classArray), objectArray);
    }

    public FastMethod getMethod(Method method) {
        return new FastMethod(this, method);
    }

    public FastConstructor getConstructor(Constructor constructor) {
        return new FastConstructor(this, constructor);
    }

    public FastMethod getMethod(String string, Class[] classArray) {
        try {
            return this.getMethod(this.type.getMethod(string, classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
    }

    public FastConstructor getConstructor(Class[] classArray) {
        try {
            return this.getConstructor(this.type.getConstructor(classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
    }

    public String getName() {
        return this.type.getName();
    }

    public Class getJavaClass() {
        return this.type;
    }

    public String toString() {
        return this.type.toString();
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FastClass)) {
            return false;
        }
        return this.type.equals(((FastClass)object).type);
    }

    public abstract int getIndex(String var1, Class[] var2);

    public abstract int getIndex(Class[] var1);

    public abstract Object invoke(int var1, Object var2, Object[] var3) throws InvocationTargetException;

    public abstract Object newInstance(int var1, Object[] var2) throws InvocationTargetException;

    public abstract int getIndex(Signature var1);

    public abstract int getMaxIndex();

    protected static String getSignatureWithoutReturnType(String string, Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append('(');
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(Type.getDescriptor(classArray[i]));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(FastClass.class.getName());
        private Class type;

        public Generator() {
            super(SOURCE);
        }

        public void setType(Class clazz) {
            this.type = clazz;
        }

        public FastClass create() {
            this.setNamePrefix(this.type.getName());
            return (FastClass)super.create(this.type.getName());
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.type.getClassLoader();
        }

        @Override
        public void generateClass(ClassVisitor classVisitor) throws Exception {
            new FastClassEmitter(classVisitor, this.getClassName(), this.type);
        }

        @Override
        protected Object firstInstance(Class clazz) {
            return ReflectUtils.newInstance(clazz, new Class[]{Class.class}, new Object[]{this.type});
        }

        @Override
        protected Object nextInstance(Object object) {
            return object;
        }
    }
}

