/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.transform;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import org.mockito.asm.Attribute;
import org.mockito.asm.ClassReader;
import org.mockito.asm.ClassVisitor;
import org.mockito.asm.ClassWriter;
import org.mockito.cglib.core.ClassGenerator;
import org.mockito.cglib.core.CodeGenerationException;
import org.mockito.cglib.core.DebuggingClassWriter;
import org.mockito.cglib.transform.ClassFilter;
import org.mockito.cglib.transform.ClassReaderGenerator;

public abstract class AbstractClassLoader
extends ClassLoader {
    private ClassFilter filter;
    private ClassLoader classPath;
    private static ProtectionDomain DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return AbstractClassLoader.class.getProtectionDomain();
        }
    });

    protected AbstractClassLoader(ClassLoader classLoader, ClassLoader classLoader2, ClassFilter classFilter) {
        super(classLoader);
        this.filter = classFilter;
        this.classPath = classLoader2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String string) throws ClassNotFoundException {
        ClassReader classReader;
        Object object;
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz != null && clazz.getClassLoader() == this) {
            return clazz;
        }
        if (!this.filter.accept(string)) {
            return super.loadClass(string);
        }
        try {
            object = this.classPath.getResourceAsStream(string.replace('.', '/') + ".class");
            if (object == null) {
                throw new ClassNotFoundException(string);
            }
            try {
                classReader = new ClassReader((InputStream)object);
            }
            finally {
                ((InputStream)object).close();
            }
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string + ":" + iOException.getMessage());
        }
        try {
            object = new DebuggingClassWriter(1);
            this.getGenerator(classReader).generateClass((ClassVisitor)object);
            byte[] byArray = ((ClassWriter)object).toByteArray();
            Class<?> clazz2 = super.defineClass(string, byArray, 0, byArray.length, DOMAIN);
            this.postProcess(clazz2);
            return clazz2;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Exception exception) {
            throw new CodeGenerationException(exception);
        }
    }

    protected ClassGenerator getGenerator(ClassReader classReader) {
        return new ClassReaderGenerator(classReader, this.attributes(), this.getFlags());
    }

    protected int getFlags() {
        return 0;
    }

    protected Attribute[] attributes() {
        return null;
    }

    protected void postProcess(Class clazz) {
    }
}

