/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal;

import java.util.LinkedList;
import java.util.List;
import org.mockito.InOrder;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.MockitoCore;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.verification.InOrderContextImpl;
import org.mockito.internal.verification.InOrderWrapper;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.internal.verification.api.InOrderContext;
import org.mockito.internal.verification.api.VerificationInOrderMode;
import org.mockito.verification.VerificationMode;

public class InOrderImpl
implements InOrder,
InOrderContext {
    private final MockitoCore mockitoCore = new MockitoCore();
    private final Reporter reporter = new Reporter();
    private final List<Object> mocksToBeVerifiedInOrder = new LinkedList<Object>();
    private final InOrderContext inOrderContext = new InOrderContextImpl();

    public List<Object> getMocksToBeVerifiedInOrder() {
        return this.mocksToBeVerifiedInOrder;
    }

    public InOrderImpl(List<Object> list) {
        this.mocksToBeVerifiedInOrder.addAll(list);
    }

    @Override
    public <T> T verify(T t) {
        return this.verify(t, VerificationModeFactory.times(1));
    }

    @Override
    public <T> T verify(T t, VerificationMode verificationMode) {
        if (!this.mocksToBeVerifiedInOrder.contains(t)) {
            this.reporter.inOrderRequiresFamiliarMock();
        } else if (!(verificationMode instanceof VerificationInOrderMode)) {
            throw new MockitoException(verificationMode.getClass().getSimpleName() + " is not implemented to work with InOrder");
        }
        return this.mockitoCore.verify(t, new InOrderWrapper((VerificationInOrderMode)((Object)verificationMode), this));
    }

    @Override
    public boolean isVerified(Invocation invocation) {
        return this.inOrderContext.isVerified(invocation);
    }

    @Override
    public void markVerified(Invocation invocation) {
        this.inOrderContext.markVerified(invocation);
    }

    @Override
    public void verifyNoMoreInteractions() {
        this.mockitoCore.verifyNoMoreInteractionsInOrder(this.mocksToBeVerifiedInOrder, this);
    }
}

