/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.progress;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.hamcrest.Matcher;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.misusing.InvalidUseOfMatchersException;
import org.mockito.internal.matchers.And;
import org.mockito.internal.matchers.LocalizedMatcher;
import org.mockito.internal.matchers.Not;
import org.mockito.internal.matchers.Or;
import org.mockito.internal.progress.ArgumentMatcherStorage;
import org.mockito.internal.progress.HandyReturnValues;

public class ArgumentMatcherStorageImpl
implements ArgumentMatcherStorage {
    private Stack<LocalizedMatcher> matcherStack = new Stack();

    @Override
    public HandyReturnValues reportMatcher(Matcher matcher) {
        this.matcherStack.push(new LocalizedMatcher(matcher));
        return new HandyReturnValues();
    }

    @Override
    public List<Matcher> pullMatchers() {
        if (this.matcherStack.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Matcher> arrayList = new ArrayList<Matcher>(this.matcherStack);
        this.matcherStack.clear();
        return arrayList;
    }

    @Override
    public HandyReturnValues reportAnd() {
        this.assertState(!this.matcherStack.isEmpty(), "No matchers found for And(?).");
        And and = new And(this.popLastArgumentMatchers(2));
        this.matcherStack.push(new LocalizedMatcher((Matcher)and));
        return new HandyReturnValues();
    }

    @Override
    public HandyReturnValues reportNot() {
        this.assertState(!this.matcherStack.isEmpty(), "No matchers found for Not(?).");
        Not not = new Not(this.popLastArgumentMatchers(1).get(0));
        this.matcherStack.push(new LocalizedMatcher((Matcher)not));
        return new HandyReturnValues();
    }

    private List<Matcher> popLastArgumentMatchers(int n) {
        this.assertState(!this.matcherStack.isEmpty(), "No matchers found.");
        this.assertState(this.matcherStack.size() >= n, "" + n + " matchers expected, " + this.matcherStack.size() + " recorded.");
        LinkedList<Matcher> linkedList = new LinkedList<Matcher>();
        linkedList.addAll(this.matcherStack.subList(this.matcherStack.size() - n, this.matcherStack.size()));
        for (int i = 0; i < n; ++i) {
            this.matcherStack.pop();
        }
        return linkedList;
    }

    private void assertState(boolean bl, String string) {
        if (!bl) {
            this.matcherStack.clear();
            throw new InvalidUseOfMatchersException(string);
        }
    }

    @Override
    public HandyReturnValues reportOr() {
        this.assertState(!this.matcherStack.isEmpty(), "No matchers found.");
        Or or = new Or(this.popLastArgumentMatchers(2));
        this.matcherStack.push(new LocalizedMatcher((Matcher)or));
        return new HandyReturnValues();
    }

    @Override
    public void validateState() {
        if (!this.matcherStack.isEmpty()) {
            LocalizedMatcher localizedMatcher = (LocalizedMatcher)this.matcherStack.lastElement();
            this.matcherStack.clear();
            new Reporter().misplacedArgumentMatcher(localizedMatcher.getLocation());
        }
    }

    @Override
    public void reset() {
        this.matcherStack.clear();
    }
}

