/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.answers;

import org.mockito.exceptions.Reporter;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.stubbing.answers.CallsRealMethods;
import org.mockito.internal.stubbing.answers.DoesNothing;
import org.mockito.internal.stubbing.answers.Returns;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.stubbing.Answer;

public class AnswersValidator {
    private Reporter reporter = new Reporter();

    public void validate(Answer<?> answer, Invocation invocation) {
        if (answer instanceof ThrowsException) {
            this.validateException((ThrowsException)answer, invocation);
        }
        if (answer instanceof Returns) {
            this.validateReturnValue((Returns)answer, invocation);
        }
        if (answer instanceof DoesNothing) {
            this.validateDoNothing((DoesNothing)answer, invocation);
        }
        if (answer instanceof CallsRealMethods) {
            this.validateMockingConcreteClass((CallsRealMethods)answer, invocation);
        }
    }

    private void validateMockingConcreteClass(CallsRealMethods callsRealMethods, Invocation invocation) {
        if (invocation.isDeclaredOnInterface()) {
            this.reporter.cannotCallRealMethodOnInterface();
        }
    }

    private void validateDoNothing(DoesNothing doesNothing, Invocation invocation) {
        if (!invocation.isVoid()) {
            this.reporter.onlyVoidMethodsCanBeSetToDoNothing();
        }
    }

    private void validateReturnValue(Returns returns, Invocation invocation) {
        if (invocation.isVoid()) {
            this.reporter.cannotStubVoidMethodWithAReturnValue(invocation.getMethod().getName());
        }
        if (returns.returnsNull() && invocation.returnsPrimitive()) {
            this.reporter.wrongTypeOfReturnValue(invocation.printMethodReturnType(), "null", invocation.getMethodName());
        }
        if (!returns.returnsNull() && !invocation.isValidReturnType(returns.getReturnType())) {
            this.reporter.wrongTypeOfReturnValue(invocation.printMethodReturnType(), returns.printReturnType(), invocation.getMethodName());
        }
    }

    private void validateException(ThrowsException throwsException, Invocation invocation) {
        Throwable throwable = throwsException.getThrowable();
        if (throwable == null) {
            this.reporter.cannotStubWithNullThrowable();
        }
        if (throwable instanceof RuntimeException || throwable instanceof Error) {
            return;
        }
        if (!invocation.isValidException(throwable)) {
            this.reporter.checkedExceptionInvalid(throwable);
        }
    }
}

