/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import java.util.List;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.internal.verification.api.VerificationDataInOrder;
import org.mockito.internal.verification.api.VerificationInOrderMode;
import org.mockito.internal.verification.checkers.MissingInvocationChecker;
import org.mockito.internal.verification.checkers.MissingInvocationInOrderChecker;
import org.mockito.internal.verification.checkers.NumberOfInvocationsChecker;
import org.mockito.internal.verification.checkers.NumberOfInvocationsInOrderChecker;
import org.mockito.verification.VerificationMode;

public class Times
implements VerificationInOrderMode,
VerificationMode {
    final int wantedCount;

    public Times(int n) {
        if (n < 0) {
            throw new MockitoException("Negative value is not allowed here");
        }
        this.wantedCount = n;
    }

    @Override
    public void verify(VerificationData verificationData) {
        Object object;
        if (this.wantedCount > 0) {
            object = new MissingInvocationChecker();
            ((MissingInvocationChecker)object).check(verificationData.getAllInvocations(), verificationData.getWanted());
        }
        object = new NumberOfInvocationsChecker();
        ((NumberOfInvocationsChecker)object).check(verificationData.getAllInvocations(), verificationData.getWanted(), this.wantedCount);
    }

    @Override
    public void verifyInOrder(VerificationDataInOrder verificationDataInOrder) {
        Object object;
        List<Invocation> list = verificationDataInOrder.getAllInvocations();
        InvocationMatcher invocationMatcher = verificationDataInOrder.getWanted();
        if (this.wantedCount > 0) {
            object = new MissingInvocationInOrderChecker();
            ((MissingInvocationInOrderChecker)object).check(list, invocationMatcher, this, verificationDataInOrder.getOrderingContext());
        }
        object = new NumberOfInvocationsInOrderChecker();
        ((NumberOfInvocationsInOrderChecker)object).check(list, invocationMatcher, this.wantedCount, verificationDataInOrder.getOrderingContext());
    }

    public String toString() {
        return "Wanted invocations count: " + this.wantedCount;
    }
}

