/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.checkers;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.debugging.Location;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.invocation.InvocationMarker;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.verification.api.InOrderContext;
import org.mockito.internal.verification.checkers.AtLeastDiscrepancy;

public class AtLeastXNumberOfInvocationsInOrderChecker {
    private final Reporter reporter = new Reporter();
    private final InvocationsFinder finder = new InvocationsFinder();
    private final InvocationMarker invocationMarker = new InvocationMarker();
    private final InOrderContext orderingContext;

    public AtLeastXNumberOfInvocationsInOrderChecker(InOrderContext inOrderContext) {
        this.orderingContext = inOrderContext;
    }

    public void check(List<Invocation> list, InvocationMatcher invocationMatcher, int n) {
        List<Invocation> list2 = this.finder.findAllMatchingUnverifiedChunks(list, invocationMatcher, this.orderingContext);
        int n2 = list2.size();
        if (n > n2) {
            Location location = this.finder.getLastLocation(list2);
            this.reporter.tooLittleActualInvocationsInOrder(new AtLeastDiscrepancy(n, n2), invocationMatcher, location);
        }
        this.invocationMarker.markVerifiedInOrder(list2, invocationMatcher, this.orderingContext);
    }
}

