/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.expectation;

import java.lang.reflect.Method;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import org.powermock.api.mockito.expectation.WithOrWithoutExpectedArguments;

public class DefaultMethodExpectationSetup<T>
implements WithOrWithoutExpectedArguments<T> {
    private final Object object;
    private final Method method;

    public DefaultMethodExpectationSetup(Object object, Method method) {
        if (object == null) {
            throw new IllegalArgumentException("object to expect cannot be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method to expect cannot be null");
        }
        this.object = object;
        this.method = method;
        this.method.setAccessible(true);
    }

    @Override
    public OngoingStubbing<T> withArguments(Object object, Object ... objectArray) throws Exception {
        if (objectArray == null || objectArray.length == 0) {
            return Mockito.when((Object)this.method.invoke(this.object, object));
        }
        return Mockito.when((Object)this.method.invoke(this.object, DefaultMethodExpectationSetup.join(object, objectArray)));
    }

    @Override
    public OngoingStubbing<T> withNoArguments() throws Exception {
        return Mockito.when((Object)this.method.invoke(this.object, new Object[0]));
    }

    private static Object[] join(Object object, Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        objectArray2[0] = object;
        System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        return objectArray2;
    }
}

