/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.verification;

import java.lang.reflect.Method;
import org.powermock.api.mockito.verification.PrivateMethodVerification;
import org.powermock.api.mockito.verification.WithOrWithoutVerifiedArguments;
import org.powermock.reflect.Whitebox;

public class DefaultPrivateMethodVerification
implements PrivateMethodVerification {
    private final Object objectToVerify;

    public DefaultPrivateMethodVerification(Object object) {
        this.objectToVerify = object;
    }

    @Override
    public void invoke(Object ... objectArray) throws Exception {
        Whitebox.invokeMethod(this.objectToVerify, objectArray);
    }

    @Override
    public void invoke(String string, Object ... objectArray) throws Exception {
        Whitebox.invokeMethod(this.objectToVerify, string, objectArray);
    }

    @Override
    public WithOrWithoutVerifiedArguments invoke(Method method) throws Exception {
        return new VerificationArguments(method);
    }

    private class VerificationArguments
    implements WithOrWithoutVerifiedArguments {
        private final Method method;

        public VerificationArguments(Method method) {
            if (method == null) {
                throw new IllegalArgumentException("method cannot be null");
            }
            this.method = method;
            this.method.setAccessible(true);
        }

        @Override
        public void withArguments(Object object, Object ... objectArray) throws Exception {
            if (objectArray == null || objectArray.length == 0) {
                this.method.invoke(DefaultPrivateMethodVerification.this.objectToVerify, object);
            } else {
                this.method.invoke(DefaultPrivateMethodVerification.this.objectToVerify, object, objectArray);
            }
        }

        @Override
        public void withNoArguments() throws Exception {
            this.method.invoke(DefaultPrivateMethodVerification.this.objectToVerify, new Object[0]);
        }
    }
}

