/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.verification;

import org.mockito.Mockito;
import org.powermock.api.mockito.internal.invocationcontrol.MockitoMethodInvocationControl;
import org.powermock.api.mockito.internal.invocationcontrol.MockitoNewInvocationControl;
import org.powermock.core.MockRepository;

public class VerifyNoMoreInteractions {
    public static void verifyNoMoreInteractions(Object ... objectArray) {
        for (Object object : objectArray) {
            if (object instanceof Class) {
                VerifyNoMoreInteractions.verifyNoMoreInteractions((Class)object);
                continue;
            }
            MockitoMethodInvocationControl mockitoMethodInvocationControl = (MockitoMethodInvocationControl)MockRepository.getInstanceMethodInvocationControl(object);
            if (mockitoMethodInvocationControl != null) {
                mockitoMethodInvocationControl.verifyNoMoreInteractions();
                continue;
            }
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{object});
        }
    }

    private static void verifyNoMoreInteractions(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            MockitoNewInvocationControl mockitoNewInvocationControl;
            MockitoMethodInvocationControl mockitoMethodInvocationControl = (MockitoMethodInvocationControl)MockRepository.getStaticMethodInvocationControl(clazz);
            if (mockitoMethodInvocationControl != null) {
                mockitoMethodInvocationControl.verifyNoMoreInteractions();
            }
            if ((mockitoNewInvocationControl = (MockitoNewInvocationControl)MockRepository.getNewInstanceControl(clazz)) == null) continue;
            mockitoNewInvocationControl.verifyNoMoreInteractions();
        }
    }
}

