/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core;

import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;

public class ClassReplicaCreator {
    private static final String POWERMOCK_INSTANCE_DELEGATOR_FIELD_NAME = "powerMockInstanceDelegatorField";
    private static AtomicInteger counter = new AtomicInteger(0);

    public Class<?> createClassReplica(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        ClassPool classPool = ClassPool.getDefault();
        String string = clazz.getName();
        CtClass ctClass = null;
        CtClass ctClass2 = classPool.makeClass(this.generateReplicaClassName(clazz));
        try {
            CtMethod[] ctMethodArray;
            ctClass = classPool.get(string);
            for (CtMethod ctMethod : ctMethodArray = ctClass.getDeclaredMethods()) {
                String string2 = this.getReplicaMethodDelegationCode(clazz, ctMethod, null);
                CtNewMethod.make((CtClass)ctMethod.getReturnType(), (String)ctMethod.getName(), (CtClass[])ctMethod.getParameterTypes(), (CtClass[])ctMethod.getExceptionTypes(), (String)string2, (CtClass)ctClass2);
            }
            return ctClass2.toClass(this.getClass().getClassLoader(), this.getClass().getProtectionDomain());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public <T> Class<T> createInstanceReplica(T t) {
        if (t == null) {
            throw new IllegalArgumentException("delegator cannot be null");
        }
        Class<?> clazz = t.getClass();
        ClassPool classPool = ClassPool.getDefault();
        String string = clazz.getName();
        CtClass ctClass = null;
        CtClass ctClass2 = classPool.makeClass(this.generateReplicaClassName(clazz));
        try {
            CtMethod ctMethod;
            CtMethod[] ctMethodArray;
            ctClass = classPool.get(string);
            this.copyFields(ctClass, ctClass2);
            this.addDelegatorField(t, ctClass2);
            CtMethod[] ctMethodArray2 = ctMethodArray = ctClass.getDeclaredMethods();
            int n = ctMethodArray2.length;
            for (int i = 0; i < n; ++i) {
                CtMethod ctMethod2 = ctMethodArray2[i];
                String string2 = this.getReplicaMethodDelegationCode(t.getClass(), ctMethod2, POWERMOCK_INSTANCE_DELEGATOR_FIELD_NAME);
                ctMethod = CtNewMethod.copy((CtMethod)ctMethod2, (CtClass)ctClass2, null);
                ctClass2.addMethod(ctMethod);
            }
            for (CtMethod ctMethod2 : ctMethodArray2 = ctClass.getDeclaredConstructors()) {
                ctMethod = CtNewConstructor.copy((CtConstructor)ctMethod2, (CtClass)ctClass2, null);
                ctClass2.addConstructor((CtConstructor)ctMethod);
            }
            return ctClass2.toClass(this.getClass().getClassLoader(), this.getClass().getProtectionDomain());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private <T> void addDelegatorField(T t, CtClass ctClass) throws CannotCompileException {
        CtField ctField = CtField.make((String)String.format("private %s %s = null;", t.getClass().getName(), POWERMOCK_INSTANCE_DELEGATOR_FIELD_NAME), (CtClass)ctClass);
        ctClass.addField(ctField);
    }

    private <T> String generateReplicaClassName(Class<T> clazz) {
        return "replica." + clazz.getName() + "$$PowerMock" + counter.getAndIncrement();
    }

    private void copyFields(CtClass ctClass, CtClass ctClass2) throws CannotCompileException, NotFoundException {
        CtField[] ctFieldArray = ctClass.getDeclaredFields();
        CtField[] ctFieldArray2 = ctClass.getFields();
        HashSet<CtField> hashSet = new HashSet<CtField>();
        for (CtField ctField : ctFieldArray) {
            hashSet.add(ctField);
        }
        for (CtField ctField : ctFieldArray2) {
            hashSet.add(ctField);
        }
        for (CtField ctField : hashSet) {
            CtField ctField2 = new CtField(ctField.getType(), ctField.getName(), ctClass2);
            ctClass2.addField(ctField2);
        }
    }

    private String getReplicaMethodDelegationCode(Class<?> clazz, CtMethod ctMethod, String string) throws NotFoundException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{java.lang.reflect.Method originalMethod = ");
        stringBuilder.append(clazz.getName());
        stringBuilder.append(".class.getDeclaredMethod(\"");
        stringBuilder.append(ctMethod.getName());
        stringBuilder.append("\", ");
        String string2 = ClassReplicaCreator.getParametersAsString(this.getParameterTypes(ctMethod));
        if ("".equals(string2)) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append(string2);
        }
        stringBuilder.append(");\n");
        stringBuilder.append("originalMethod.setAccessible(true);\n");
        CtClass ctClass = ctMethod.getReturnType();
        boolean bl = ctClass.equals(CtClass.voidType);
        if (!bl) {
            stringBuilder.append("return (");
            stringBuilder.append(ctClass.getName());
            stringBuilder.append(") ");
        }
        stringBuilder.append("originalMethod.invoke(");
        if (Modifier.isStatic((int)ctMethod.getModifiers()) || string == null) {
            stringBuilder.append(clazz.getName());
            stringBuilder.append(".class");
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append(", $args);}");
        return stringBuilder.toString();
    }

    private String[] getParameterTypes(CtMethod ctMethod) throws NotFoundException {
        CtClass[] ctClassArray = ctMethod.getParameterTypes();
        String[] stringArray = new String[ctClassArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ctClassArray[i].getName() + ".class";
        }
        return stringArray;
    }

    private static String getParametersAsString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray != null && stringArray.length == 0) {
            stringBuilder.append("new Class[0]");
        } else {
            stringBuilder.append("new Class[] {");
            if (stringArray != null && stringArray.length != 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuilder.append(stringArray[i]);
                    if (i == stringArray.length - 1) continue;
                    stringBuilder.append(", ");
                }
            }
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }
}

