/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Set;
import org.powermock.core.ConcreteClassGenerator;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.internal.TypeUtils;

public class DefaultFieldValueGenerator {
    public static <T> T fillWithDefaultValues(T t) {
        if (t == null) {
            throw new IllegalArgumentException("object to fill cannot be null");
        }
        Set<Field> set = Whitebox.getAllInstanceFields(t);
        for (Field field : set) {
            Class<?> clazz = field.getType();
            Object object = TypeUtils.getDefaultValue(clazz);
            if (object == null && clazz != t.getClass() && !field.isSynthetic() && (object = DefaultFieldValueGenerator.instantiateFieldType(field)) != null) {
                DefaultFieldValueGenerator.fillWithDefaultValues(object);
            }
            try {
                field.set(t, object);
            }
            catch (Exception exception) {
                throw new RuntimeException("Internal error: Failed to set field.", exception);
            }
        }
        return t;
    }

    private static Object instantiateFieldType(Field field) {
        Object var2_3;
        Class<ClassLoader> clazz = field.getType();
        int n = clazz.getModifiers();
        if (clazz.isAssignableFrom(ClassLoader.class) || DefaultFieldValueGenerator.isClass(clazz)) {
            var2_3 = null;
        } else if (Modifier.isAbstract(n) && !Modifier.isInterface(n) && !clazz.isArray()) {
            Class<?> clazz2 = new ConcreteClassGenerator().createConcreteSubClass(clazz);
            var2_3 = clazz2 == null ? null : Whitebox.newInstance(clazz2);
        } else {
            clazz = DefaultFieldValueGenerator.substituteKnownProblemTypes(clazz);
            var2_3 = Whitebox.newInstance(clazz);
        }
        return var2_3;
    }

    private static boolean isClass(Class<?> clazz) {
        return clazz == Class.class;
    }

    private static Class<?> substituteKnownProblemTypes(Class<?> clazz) {
        if (clazz == InetAddress.class) {
            return Inet4Address.class;
        }
        return clazz;
    }
}

