/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListMap<K, V>
implements Map<K, V> {
    private List<Map.Entry<K, V>> entries = new LinkedList<Map.Entry<K, V>>();

    @Override
    public V remove(Object object) {
        Iterator<Map.Entry<K, V>> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            if (entry.getKey() != object) continue;
            iterator.remove();
            return entry.getValue();
        }
        return null;
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public V get(Object object) {
        for (Map.Entry<K, V> entry : this.entries) {
            if (entry.getKey() != object) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        for (Map.Entry<K, V> entry : this.entries) {
            if (entry.getKey() != k) continue;
            return entry.setValue(v);
        }
        SimpleEntry<K, V> simpleEntry = new SimpleEntry<K, V>(k, v);
        this.entries.add(simpleEntry);
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        for (Map.Entry<K, V> entry : this.entries) {
            if (entry.getValue() != object) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> hashSet = new HashSet<K>();
        for (Map.Entry<K, V> entry : this.entries) {
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Set<Map.Entry<K, V>> set = map.entrySet();
        for (Map.Entry<K, V> entry : set) {
            this.entries.add(entry);
        }
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Collection<V> values() {
        HashSet<V> hashSet = new HashSet<V>();
        for (Map.Entry<K, V> entry : this.entries) {
            hashSet.add(entry.getValue());
        }
        return hashSet;
    }

    private static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public SimpleEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }
    }
}

