/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core;

import java.util.Collection;

public class WildcardMatcher {
    private static final char WILDCARD = '*';

    public static boolean matches(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        string = string + '\u0000';
        string2 = string2 + '\u0000';
        int n = string2.length();
        boolean[] blArray = new boolean[n + 1];
        boolean[] blArray2 = new boolean[n + 1];
        blArray2[0] = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            blArray = new boolean[n + 1];
            for (int j = 0; j < n; ++j) {
                char c2 = string2.charAt(j);
                if (blArray2[j] && c2 == '*') {
                    blArray2[j + 1] = true;
                }
                if (blArray2[j] && c2 == c) {
                    blArray[j + 1] = true;
                }
                if (blArray2[j] && c2 == '*') {
                    blArray[j] = true;
                }
                if (!blArray2[j] || c2 != '*') continue;
                blArray[j + 1] = true;
            }
            blArray2 = blArray;
        }
        return blArray[n];
    }

    public static boolean matchesAny(Collection<String> collection, String string) {
        for (String string2 : collection) {
            if (!WildcardMatcher.matches(string, string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesAny(Iterable<String> iterable, String string) {
        for (String string2 : iterable) {
            if (!WildcardMatcher.matches(string, string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesAny(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!WildcardMatcher.matches(string, string2)) continue;
            return true;
        }
        return false;
    }
}

