/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.common.internal.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.powermock.core.spi.PowerMockTestListener;
import org.powermock.core.spi.testresult.impl.TestSuiteResultImpl;
import org.powermock.modules.junit4.common.internal.JUnit4TestSuiteChunker;
import org.powermock.modules.junit4.common.internal.PowerMockJUnitRunnerDelegate;
import org.powermock.modules.junit4.common.internal.impl.PowerMockJUnit4RunListener;
import org.powermock.tests.utils.TestChunk;
import org.powermock.tests.utils.impl.AbstractTestSuiteChunkerImpl;
import org.powermock.tests.utils.impl.PowerMockTestNotifierImpl;

public class JUnit4TestSuiteChunkerImpl
extends AbstractTestSuiteChunkerImpl<PowerMockJUnitRunnerDelegate>
implements JUnit4TestSuiteChunker,
Filterable,
Sortable {
    private Description description;
    private final Class<? extends PowerMockJUnitRunnerDelegate> runnerDelegateImplementationType;

    public JUnit4TestSuiteChunkerImpl(Class<?> clazz, Class<? extends PowerMockJUnitRunnerDelegate> clazz2) throws Exception {
        super(clazz);
        if (clazz == null) {
            throw new IllegalArgumentException("You must supply a test class");
        }
        if (clazz2 == null) {
            throw new IllegalArgumentException("Runner delegate type cannot be null.");
        }
        this.runnerDelegateImplementationType = clazz2;
        try {
            this.createTestDelegators(clazz, this.getTestChunksEntries(clazz));
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public void run(RunNotifier runNotifier) {
        List<TestChunk> list = this.getTestChunks();
        Iterator<TestChunk> iterator = list.iterator();
        if (this.delegates.size() != this.getChunkSize()) {
            throw new IllegalStateException("Internal error: There must be an equal number of suites and delegates.");
        }
        Class<?> clazz = this.getTestClasses()[0];
        PowerMockTestListener[] powerMockTestListenerArray = (PowerMockTestListener[])this.getPowerMockTestListenersLoadedByASpecificClassLoader(clazz, this.getClass().getClassLoader());
        LinkedHashSet<Method> linkedHashSet = new LinkedHashSet<Method>();
        for (TestChunk object2 : this.getTestChunks()) {
            linkedHashSet.addAll(object2.getTestMethodsToBeExecutedByThisClassloader());
        }
        Method[] methodArray = linkedHashSet.toArray(new Method[0]);
        PowerMockTestNotifierImpl powerMockTestNotifierImpl = new PowerMockTestNotifierImpl(powerMockTestListenerArray);
        powerMockTestNotifierImpl.notifyBeforeTestSuiteStarted(clazz, methodArray);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int testSuiteResultImpl = 0; testSuiteResultImpl < this.delegates.size(); ++testSuiteResultImpl) {
            TestChunk testChunk = iterator.next();
            ClassLoader classLoader = testChunk.getClassLoader();
            PowerMockJUnit4RunListener powerMockJUnit4RunListener = new PowerMockJUnit4RunListener(classLoader, powerMockTestNotifierImpl);
            runNotifier.addListener((RunListener)powerMockJUnit4RunListener);
            PowerMockJUnitRunnerDelegate powerMockJUnitRunnerDelegate = (PowerMockJUnitRunnerDelegate)this.delegates.get(testSuiteResultImpl);
            powerMockJUnitRunnerDelegate.run(runNotifier);
            int n4 = powerMockJUnit4RunListener.getFailureCount();
            int n5 = powerMockJUnit4RunListener.getIgnoreCount();
            n += n4;
            n3 += n5;
            n2 += powerMockJUnitRunnerDelegate.getTestCount() - n4 - n5;
            runNotifier.removeListener((RunListener)powerMockJUnit4RunListener);
        }
        TestSuiteResultImpl testSuiteResultImpl = new TestSuiteResultImpl(n, n2, this.getTestCount(), n3);
        powerMockTestNotifierImpl.notifyAfterTestSuiteEnded(clazz, methodArray, testSuiteResultImpl);
    }

    @Override
    public boolean shouldExecuteTestForMethod(Class<?> clazz, Method method) {
        return method.getName().startsWith("test") && Modifier.isPublic(method.getModifiers()) && method.getReturnType().equals(Void.TYPE) && TestCase.class.isAssignableFrom(clazz) || method.isAnnotationPresent(Test.class);
    }

    @Override
    protected PowerMockJUnitRunnerDelegate createDelegatorFromClassloader(ClassLoader classLoader, Class<?> clazz, List<Method> list) throws Exception {
        GenericDeclaration genericDeclaration2;
        HashSet<String> hashSet = new HashSet<String>();
        for (GenericDeclaration genericDeclaration2 : list) {
            hashSet.add(genericDeclaration2.getName());
        }
        Class<?> clazz2 = Class.forName(clazz.getName(), false, classLoader);
        genericDeclaration2 = Class.forName(PowerMockTestListener[].class.getName(), false, classLoader);
        Class<?> clazz3 = Class.forName(this.runnerDelegateImplementationType.getName(), false, classLoader);
        Constructor<?> constructor = clazz3.getConstructor(new Class[]{Class.class, String[].class, genericDeclaration2});
        PowerMockJUnitRunnerDelegate powerMockJUnitRunnerDelegate = (PowerMockJUnitRunnerDelegate)constructor.newInstance(clazz2, hashSet.toArray(new String[0]), this.getPowerMockTestListenersLoadedByASpecificClassLoader(clazz, classLoader));
        return powerMockJUnitRunnerDelegate;
    }

    @Override
    public synchronized int getTestCount() {
        if (this.testCount == -1) {
            this.testCount = 0;
            for (PowerMockJUnitRunnerDelegate powerMockJUnitRunnerDelegate : this.delegates) {
                this.testCount += powerMockJUnitRunnerDelegate.getTestCount();
            }
        }
        return this.testCount;
    }

    @Override
    public Description getDescription() {
        if (this.description == null) {
            if (this.delegates.size() == 0) {
                return Description.createTestDescription(this.getClass(), (String)"no tests in this class");
            }
            PowerMockJUnitRunnerDelegate powerMockJUnitRunnerDelegate = (PowerMockJUnitRunnerDelegate)this.delegates.get(0);
            this.description = powerMockJUnitRunnerDelegate.getDescription();
            for (int i = 1; i < this.delegates.size(); ++i) {
                ArrayList arrayList = ((PowerMockJUnitRunnerDelegate)this.delegates.get(i)).getDescription().getChildren();
                for (Description description : arrayList) {
                    this.description.addChild(description);
                }
            }
        }
        return this.description;
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        for (PowerMockJUnitRunnerDelegate powerMockJUnitRunnerDelegate : this.delegates) {
            if (!(powerMockJUnitRunnerDelegate instanceof Filterable)) continue;
            ((Filterable)powerMockJUnitRunnerDelegate).filter(filter);
        }
    }

    public void sort(Sorter sorter) {
        for (PowerMockJUnitRunnerDelegate powerMockJUnitRunnerDelegate : this.delegates) {
            if (!(powerMockJUnitRunnerDelegate instanceof Sortable)) continue;
            ((Sortable)powerMockJUnitRunnerDelegate).sort(sorter);
        }
    }
}

