/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.common.internal.impl;

import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.powermock.core.MockRepository;
import org.powermock.reflect.Whitebox;
import org.powermock.tests.utils.PowerMockTestNotifier;

public class PowerMockJUnit4RunListener
extends RunListener {
    private final ClassLoader mockClassLoader;
    private int failureCount;
    private int ignoreCount;
    private boolean currentTestSuccessful = true;
    private final PowerMockTestNotifier powerMockTestNotifier;

    public PowerMockJUnit4RunListener(ClassLoader classLoader, PowerMockTestNotifier powerMockTestNotifier) {
        this.mockClassLoader = classLoader;
        this.powerMockTestNotifier = powerMockTestNotifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFinished(Description description) throws Exception {
        Class<?> clazz = this.mockClassLoader.loadClass(MockRepository.class.getName());
        try {
            this.notifyListenersOfTestResult();
        }
        finally {
            Whitebox.invokeMethod(clazz, "clear", new Object[0]);
        }
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public int getIgnoreCount() {
        return this.ignoreCount;
    }

    public void testFailure(Failure failure) throws Exception {
        this.currentTestSuccessful = false;
        ++this.failureCount;
    }

    public void testIgnored(Description description) throws Exception {
        ++this.ignoreCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfTestResult() {
        try {
            this.powerMockTestNotifier.notifyAfterTestMethod(this.currentTestSuccessful);
        }
        finally {
            this.currentTestSuccessful = true;
        }
    }
}

