/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.internal.impl.testcaseworkaround;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.runners.MethodValidator;
import org.junit.internal.runners.TestClass;
import org.powermock.reflect.Whitebox;

public class PowerMockJUnit4MethodValidator
extends MethodValidator {
    public PowerMockJUnit4MethodValidator(TestClass testClass) {
        super(testClass);
    }

    public void validateInstanceMethods() {
        this.validateTestMethods(After.class, false);
        this.validateTestMethods(Before.class, false);
        this.validateTestMethods(Test.class, false);
        TestClass testClass = (TestClass)Whitebox.getInternalState((Object)this, "fTestClass", MethodValidator.class);
        Class clazz = (Class)Whitebox.getInternalState((Object)testClass, "fClass");
        List list = (List)Whitebox.getInternalState((Object)this, "fErrors", MethodValidator.class);
        List<Method> list2 = this.getTestMethods(testClass, clazz);
        if (list2.size() == 0) {
            list.add(new Exception("No runnable methods"));
        }
    }

    private List<Method> getTestMethods(TestClass testClass, Class<?> clazz) {
        List list = testClass.getAnnotatedMethods(Test.class);
        if (list.isEmpty()) {
            list.addAll(this.getTestMethodsWithNoAnnotation(clazz));
        }
        return list;
    }

    private void validateTestMethods(Class<? extends Annotation> clazz, boolean bl) {
        TestClass testClass = (TestClass)Whitebox.getInternalState((Object)this, "fTestClass", MethodValidator.class);
        Class clazz2 = (Class)Whitebox.getInternalState((Object)testClass, "fClass");
        List<Method> list = TestCase.class.equals(clazz2.getSuperclass()) && !bl ? this.getTestMethodsWithNoAnnotation(clazz2) : testClass.getAnnotatedMethods(clazz);
        List list2 = (List)Whitebox.getInternalState((Object)this, "fErrors", MethodValidator.class);
        for (Method method : list) {
            if (Modifier.isStatic(method.getModifiers()) != bl) {
                String string = bl ? "should" : "should not";
                list2.add(new Exception("Method " + method.getName() + "() " + string + " be static"));
            }
            if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                list2.add(new Exception("Class " + method.getDeclaringClass().getName() + " should be public"));
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                list2.add(new Exception("Method " + method.getName() + " should be public"));
            }
            if (method.getReturnType() != Void.TYPE) {
                list2.add(new Exception("Method " + method.getName() + " should be void"));
            }
            if (method.getParameterTypes().length == 0) continue;
            list2.add(new Exception("Method " + method.getName() + " should have no parameters"));
        }
    }

    private List<Method> getTestMethodsWithNoAnnotation(Class<?> clazz) {
        Method[] methodArray;
        LinkedList<Method> linkedList = new LinkedList<Method>();
        for (Method method : methodArray = clazz.getMethods()) {
            if (!method.getName().startsWith("test")) continue;
            linkedList.add(method);
        }
        return linkedList;
    }
}

