/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.reflect.internal.matcherstrategies;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.powermock.reflect.exceptions.FieldNotFoundException;
import org.powermock.reflect.internal.matcherstrategies.FieldMatcherStrategy;

public class FieldAnnotationMatcherStrategy
extends FieldMatcherStrategy {
    final Class<? extends Annotation>[] annotations;

    public FieldAnnotationMatcherStrategy(Class<? extends Annotation>[] classArray) {
        if (classArray == null || classArray.length == 0) {
            throw new IllegalArgumentException("You must specify atleast one annotation.");
        }
        this.annotations = classArray;
    }

    @Override
    public boolean matches(Field field) {
        for (Class<? extends Annotation> clazz : this.annotations) {
            if (!field.isAnnotationPresent(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void notFound(Class<?> clazz, boolean bl) throws FieldNotFoundException {
        throw new FieldNotFoundException("No field that has any of the annotation types \"" + this.getAnnotationNames() + "\" could be found in the class hierarchy of " + clazz.getName() + ".");
    }

    public String toString() {
        return "annotations " + this.getAnnotationNames();
    }

    private String getAnnotationNames() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.annotations.length; ++i) {
            stringBuilder.append(this.annotations[i].getName());
            if (i == this.annotations.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }
}

