/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: unocrsr.hxx,v $
 * $Revision: 1.5 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef _UNOCRSR_HXX
#define _UNOCRSR_HXX

#ifndef _SWCRSR_HXX
#include <swcrsr.hxx>
#endif
#ifndef _CALBCK_HXX
#include <calbck.hxx>
#endif
namespace binfilter {


class SwUnoCrsr : public virtual SwCursor, public SwModify
{
	BOOL bRemainInSection : 1;
	BOOL bSkipOverHiddenSections : 1;
	BOOL bSkipOverProtectSections : 1;

public:
	SwUnoCrsr( const SwPosition &rPos, SwPaM* pRing = 0 );
	virtual ~SwUnoCrsr();

	virtual operator SwUnoCrsr* ();

//	virtual SwCursor* Create( SwPaM* pRing = 0 ) const;

	// gibt es eine Selection vom Content in die Tabelle
	// Return Wert gibt an, ob der Crsr auf der alten Position verbleibt
	virtual FASTBOOL IsSelOvr( int eFlags =
								( SELOVER_CHECKNODESSECTION |
								  SELOVER_TOGGLE | SELOVER_CHANGEPOS ));

	BOOL IsRemainInSection() const 			{ return bRemainInSection; }
	void SetRemainInSection( BOOL bFlag )	{ bRemainInSection = bFlag; }

	BOOL IsSkipOverProtectSections() const
									{ return bSkipOverProtectSections; }
	void SetSkipOverProtectSections( BOOL bFlag )
									{ bSkipOverProtectSections = bFlag; }

	BOOL IsSkipOverHiddenSections() const
									{ return bSkipOverHiddenSections; }
	void SetSkipOverHiddenSections( BOOL bFlag )
									{ bSkipOverHiddenSections = bFlag; }

	DECL_FIXEDMEMPOOL_NEWDEL( SwUnoCrsr )
};



class SwUnoTableCrsr : public virtual SwUnoCrsr, public virtual SwTableCursor
{
	// die Selection hat die gleiche Reihenfolge wie die
	// TabellenBoxen. D.h., wird aus dem einen Array an einer Position
	// etwas geloescht, dann muss es auch im anderen erfolgen!!
	SwCursor aTblSel;

public:
	SwUnoTableCrsr( const SwPosition& rPos );
	virtual ~SwUnoTableCrsr();

//	virtual SwCursor* Create( SwPaM* pRing = 0 ) const;

	virtual operator SwUnoCrsr* ();
	virtual operator SwUnoTableCrsr* ();
	virtual operator SwTableCursor* ();

	// gibt es eine Selection vom Content in die Tabelle
	// Return Wert gibt an, ob der Crsr auf der alten Position verbleibt
	virtual FASTBOOL IsSelOvr( int eFlags =
								( SELOVER_CHECKNODESSECTION |
								  SELOVER_TOGGLE | SELOVER_CHANGEPOS ));

	void MakeBoxSels();
 		  SwCursor& GetSelRing() 			{ return aTblSel; }
	const SwCursor& GetSelRing() const 		{ return aTblSel; }
};



} //namespace binfilter
#endif
