/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: salvd.cxx,v $
 * $Revision: 1.27 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_vcl.hxx"

#include "salvd.h"
#include "salinst.h"
#include "salgdi.h"
#include "saldata.hxx"
#include "salframe.h"

#include "vcl/sysdata.hxx"

// -----------------------------------------------------------------------

SalVirtualDevice* AquaSalInstance::CreateVirtualDevice( SalGraphics* pGraphics,
	long nDX, long nDY, USHORT nBitCount, const SystemGraphicsData *pData )
{
    // #i92075# can be called first in a thread
    SalData::ensureThreadAutoreleasePool();
    
	return new AquaSalVirtualDevice( static_cast< AquaSalGraphics* >( pGraphics ), nDX, nDY, nBitCount, pData );
}

// -----------------------------------------------------------------------

void AquaSalInstance::DestroyVirtualDevice( SalVirtualDevice* pDevice )
{
	delete pDevice;
}

// =======================================================================

AquaSalVirtualDevice::AquaSalVirtualDevice( AquaSalGraphics* pGraphic, long nDX, long nDY, USHORT nBitCount, const SystemGraphicsData *pData )
:	mbGraphicsUsed( false )
,	mxBitmapContext( NULL )
,	mnBitmapDepth( 0 )
,	mxLayer( NULL )
{
    if( pGraphic && pData && pData->rCGContext )
	{
	    // Create virtual device based on existing SystemGraphicsData
        // We ignore nDx and nDY, as the desired size comes from the SystemGraphicsData
        mbForeignContext = true;        // the mxContext is from pData
	    mpGraphics = new AquaSalGraphics( /*pGraphic*/ );
	    mpGraphics->SetVirDevGraphics( mxLayer, pData->rCGContext );
	}
	else
	{
	    // create empty new virtual device
        mbForeignContext = false;           // the mxContext is created within VCL
        mpGraphics = new AquaSalGraphics(); // never fails
		mnBitmapDepth = nBitCount;

        // inherit resolution from reference device
        if( pGraphic )
        {
            AquaSalFrame* pFrame = pGraphic->getGraphicsFrame();
            if( pFrame && AquaSalFrame::isAlive( pFrame ) )
            {
                mpGraphics->setGraphicsFrame( pFrame );
                mpGraphics->copyResolution( *pGraphic );
            }
        }

        if( nDX && nDY )
            SetSize( nDX, nDY );
        
        // NOTE: if SetSize does not succeed, we just ignore the nDX and nDY
	}
}

// -----------------------------------------------------------------------

AquaSalVirtualDevice::~AquaSalVirtualDevice()
{
	if( mpGraphics )
	{
		mpGraphics->SetVirDevGraphics( NULL, NULL );
		delete mpGraphics;
		mpGraphics = 0;
	}
	Destroy();
}

// -----------------------------------------------------------------------

void AquaSalVirtualDevice::Destroy()
{
    if( mbForeignContext ) {
        // Do not delete mxContext that we have received from outside VCL
		mxLayer = NULL;
        return;
    }

	if( mxLayer )
	{
		if( mpGraphics )
			mpGraphics->SetVirDevGraphics( NULL, NULL );
		CGLayerRelease( mxLayer );
		mxLayer = NULL;
	}

	if( mxBitmapContext )
	{
		void* pRawData = CGBitmapContextGetData( mxBitmapContext );
		rtl_freeMemory( pRawData );
		CGContextRelease( mxBitmapContext );
		mxBitmapContext = NULL;
	}
}

// -----------------------------------------------------------------------

SalGraphics* AquaSalVirtualDevice::GetGraphics()
{
	if( mbGraphicsUsed || !mpGraphics )
		return 0;

	mbGraphicsUsed = true;
	return mpGraphics;
}

// -----------------------------------------------------------------------

void AquaSalVirtualDevice::ReleaseGraphics( SalGraphics *pGraphics )
{
	mbGraphicsUsed = false;
}

// -----------------------------------------------------------------------

BOOL AquaSalVirtualDevice::SetSize( long nDX, long nDY )
{
    if( mbForeignContext )
    {
        // Do not delete/resize mxContext that we have received from outside VCL
        return true;
    }

    if( mxLayer )
    {
    	const CGSize aSize = CGLayerGetSize( mxLayer );
        if( (nDX == aSize.width) && (nDY == aSize.height) )
	    {
	        // Yay, we do not have to do anything :)
			return true;
	    }
    }

    Destroy();

	// create a Quartz layer matching to the intended virdev usage
	CGContextRef xCGContext = NULL;
	if( mnBitmapDepth && (mnBitmapDepth < 16) )
	{
		mnBitmapDepth = 8;  // TODO: are 1bit vdevs worth it?
		const CGColorSpaceRef aCGColorSpace = GetSalData()->mxGraySpace;
		const CGBitmapInfo aCGBmpInfo = kCGImageAlphaNone;
		const int nBytesPerRow = (mnBitmapDepth * nDX + 7) / 8;

		void* pRawData = rtl_allocateMemory( nBytesPerRow * nDY );
		mxBitmapContext = ::CGBitmapContextCreate( pRawData, nDX, nDY,
			mnBitmapDepth, nBytesPerRow, aCGColorSpace, aCGBmpInfo );
		xCGContext = mxBitmapContext;
	}
	else
	{
		// default to a NSView target context
        AquaSalFrame* pSalFrame = mpGraphics->getGraphicsFrame();
        if( !pSalFrame && !GetSalData()->maFrames.empty() )
            pSalFrame = *GetSalData()->maFrames.begin();
        if( pSalFrame )
        {
            NSGraphicsContext* pNSContext = [NSGraphicsContext graphicsContextWithWindow: pSalFrame->getWindow()];
            if( pNSContext )
                xCGContext = reinterpret_cast<CGContextRef>([pNSContext graphicsPort]);
        }
	}
    
    DBG_ASSERT( xCGContext, "no context" );
    
	const CGSize aNewSize = { nDX, nDY };
	mxLayer = CGLayerCreateWithContext( xCGContext, aNewSize, NULL );

	if( mxLayer && mpGraphics )
	{
		// get the matching Quartz context
		CGContextRef xDrawContext = CGLayerGetContext( mxLayer );
		mpGraphics->SetVirDevGraphics( mxLayer, xDrawContext, mnBitmapDepth );
	}

	return (mxLayer != NULL);
}

// -----------------------------------------------------------------------

void AquaSalVirtualDevice::GetSize( long& rWidth, long& rHeight )
{
	if( mxLayer )
	{
    	const CGSize aSize = CGLayerGetSize( mxLayer );
		rWidth = static_cast<long>(aSize.width);
		rHeight = static_cast<long>(aSize.height);
	}
	else
	{
		rWidth = 0;
		rHeight = 0;
	}
}
