/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          AboutDialog.cpp

Description:

    This file implements class AboutDialog.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#include "include/AboutDialog.h"
#include "include/DataMiddle.h"
#include "include/PMGlobalConstant.h"

//(*InternalHeaders(AboutDialog)
#include <wx/bitmap.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
//*)

//(*IdInit(AboutDialog)
const long AboutDialog::ID_STATICBITMAP1 = wxNewId();
const long AboutDialog::ID_STATICTEXT1 = wxNewId();
const long AboutDialog::ID_STATICTEXT2 = wxNewId();
const long AboutDialog::ID_STATICTEXT3 = wxNewId();
const long AboutDialog::ID_STATICTEXT4 = wxNewId();
const long AboutDialog::ID_BUTTON_OK = wxNewId();
const long AboutDialog::ID_STATICLINE1 = wxNewId();
//*)

/**the event mapping*/
BEGIN_EVENT_TABLE(AboutDialog,wxDialog)
	//(*EventTable(AboutDialog)
	//*)
END_EVENT_TABLE()

/**Constructor*/
AboutDialog::AboutDialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	Create(parent, id, _("About Intel (R) Power Manager"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxSize(350,230));
	Move(wxDefaultPosition);
	StaticBitmap1 = new wxStaticBitmap(this, ID_STATICBITMAP1, wxBitmap(wxImage(_T("/etc/ipower-management/pictures/About_BG.png")).Rescale(wxSize(350,230).GetWidth(),wxSize(350,230).GetHeight())), wxPoint(0,5), wxSize(350,230), 0, _T("ID_STATICBITMAP1"));
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Power Manager"), wxPoint(92,70), wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	StaticText2 = new wxStaticText(this, ID_STATICTEXT2, wxEmptyString, wxPoint(92,90), wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	StaticText3 = new wxStaticText(this, ID_STATICTEXT3, _("Copyright(C) 2008 Intel Corporation."), wxPoint(92,130), wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	StaticText4 = new wxStaticText(this, ID_STATICTEXT4, _("All rights reserved."), wxPoint(92,150), wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	Button_OK = new wxButton(this, ID_BUTTON_OK, _("OK"), wxPoint(252,185), wxSize(75,27), wxTAB_TRAVERSAL, wxDefaultValidator, _T("ID_BUTTON_OK"));
	Button_OK->SetDefault();
	Button_OK->SetToolTip(wxT("OK"));
	//StaticLine1 = new wxStaticLine(this, ID_STATICLINE1, wxPoint(0,225), wxSize(435,-1), wxLI_HORIZONTAL, _T("ID_STATICLINE1"));

	Connect(ID_BUTTON_OK,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&AboutDialog::OnButton_OKClick);
	Connect(wxID_ANY,wxEVT_CLOSE_WINDOW,(wxObjectEventFunction)&AboutDialog::OnClose);

    wxString version = _("Version ");
    StaticText2->SetLabel(version + wxT("2.0.0.150"));

    // Set font and foreground colour
    wxFont StaticTextFont(9,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
    wxFont StaticBoldTextFont(11,wxSWISS,wxFONTSTYLE_NORMAL,wxBOLD,false,_T("Sans"),wxFONTENCODING_DEFAULT);

    StaticText1->SetFont(StaticBoldTextFont);
    StaticText1->SetForegroundColour(wxColour(20,80,190));

    StaticText2->SetFont(StaticTextFont);
    StaticText3->SetFont(StaticTextFont);
    StaticText4->SetFont(StaticTextFont);

	DataMiddle::GetInstance()->AttachAboutDlg(this);

}

/**Destructor*/
AboutDialog::~AboutDialog()
{
	DataMiddle::GetInstance()->DettachAboutDlg();
}

/**The OK button click event handler*/
void AboutDialog::OnButton_OKClick(wxCommandEvent& event)
{
    Destroy();
}

/**The windows close event handler*/
void AboutDialog::OnClose(wxCloseEvent& event)
{
    Destroy();
}
