/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          ConfigurationFileEditor.h

Description:

    This file implements class ConfigurationFileEditor.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#include "include/ConfigurationFileEditor.h"
#include "include/PMUtility.h"

/**constructor*/
ConfigurationFileEditor::ConfigurationFileEditor()
{
    InitSchemeFilePath();
}

/**destructor*/
ConfigurationFileEditor::~ConfigurationFileEditor()
{
}

/**************************************************************************************************
* Function Name : InitSchemeFilePath                                                              *
* Description  : get local user's scheme file's path                                              *
* Date   : 08/07/20                                                                               *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
int ConfigurationFileEditor::InitSchemeFilePath()
{
	m_FilePath = PMUtility::GetHomeDir() + OPTIONFILE;

    return 1;
}

/**************************************************************************************************
* Function Name : Add                                                                             *
* Description  : Add  a scheme in file                                                            *
* Date   : 08/07/20                                                                               *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
int ConfigurationFileEditor::Add(PSchemeList_t scheme)
{
    int iRet = -1;
    TiXmlDocument doc(m_FilePath.c_str());

    if ( !doc.LoadFile() )
    {
        return iRet;
    }


    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;
	TiXmlNode * pNode = NULL;

	pNode = doc.FirstChild(ROOT);
	xmlRootElement = pNode->ToElement();
	if (NULL == xmlRootElement)
	{
	    return iRet;
	}

    pNode = xmlRootElement->FirstChild(SCHEME_SUB);
    xmlSubElement = pNode->ToElement();
    if (NULL == xmlSubElement)
	{
	    return iRet;
	}

    TiXmlElement *xmlItemElement = new TiXmlElement(ITEM);
    xmlItemElement->SetAttribute(SCHEMEID.c_str(), ((*scheme).id));
    xmlItemElement->SetAttribute(NAME.c_str(), scheme->name);
    xmlItemElement->SetAttribute(VALUE.c_str(), ((*scheme).value));

    xmlSubElement->InsertEndChild(*xmlItemElement);

    if(doc.SaveFile())
    {
        //cout<<"File Successfully saved"<<endl;
        iRet = 1;
    }

    if (NULL != xmlItemElement)
    {
        xmlItemElement = NULL;
    }

    return iRet;
}

/**************************************************************************************************
* Function Name : Edit                                                                            *
* Description  : Edit  a scheme in file                                                           *
* Date   : 08/07/20                                                                               *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
int ConfigurationFileEditor::Edit(PSchemeList_t scheme)
{
    int iRet = -1;

    TiXmlDocument doc(m_FilePath.c_str());

    if ( !doc.LoadFile() )
    {
        return iRet;
    }


    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;
	TiXmlNode * pNode = NULL;

	pNode = doc.FirstChild(ROOT);
	xmlRootElement = pNode->ToElement();
	if (NULL == xmlRootElement)
	{
	    return iRet;
	}

    pNode = xmlRootElement->FirstChild(SCHEME_SUB);
    xmlSubElement = pNode->ToElement();
    if (NULL == xmlSubElement)
	{
	    return iRet;
	}

    TiXmlElement* xmlItemElement = 0;

    pNode = xmlSubElement->FirstChild(ITEM);

    while(pNode)
    {

        xmlItemElement = pNode->ToElement();
        int idTemp = 0;
        xmlItemElement->Attribute(SCHEMEID.c_str(), &idTemp);
        if ( idTemp == (scheme->id))
        {
            xmlItemElement->SetAttribute(NAME.c_str(), scheme->name);

            break;
        }

        pNode = pNode->NextSibling();
    }

    if(doc.SaveFile())
    {
        iRet = 1;
    }
    return iRet;
}

/**************************************************************************************************
* Function Name : Delete                                                                          *
* Description  : delete a scheme in file                                                          *
* Date   : 08/07/20                                                                               *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
int ConfigurationFileEditor::Delete(int id)
{
    int iRet = -1;

    TiXmlDocument doc(m_FilePath.c_str());

    if ( !doc.LoadFile() )
    {
        return iRet;
    }


    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;
	TiXmlNode * pNode = NULL;

	pNode = doc.FirstChild(ROOT);
	xmlRootElement = pNode->ToElement();
	if (NULL == xmlRootElement)
	{
	    return iRet;
	}

    pNode = xmlRootElement->FirstChild(SCHEME_SUB);
    xmlSubElement = pNode->ToElement();
    if (NULL == xmlSubElement)
	{
	    return iRet;
	}

    TiXmlElement* xmlItemElement = 0;

    pNode = xmlSubElement->FirstChild(ITEM);

    while(pNode)
    {

        xmlItemElement = pNode->ToElement();
        int idTemp = 0;
        xmlItemElement->Attribute(SCHEMEID.c_str(), &idTemp);

        if ( idTemp == id )
        {
            if (xmlSubElement->RemoveChild(pNode))
            {
                iRet = 1;

            }
            break;
        }

        pNode = pNode->NextSibling();
    }

    if(doc.SaveFile())
    {
        iRet = 1;
    }
    return iRet;
}

/**************************************************************************************************
* Function Name : ReadSwitchWarning                                                               *
* Description  : when switch scheme, whether the dialog will pop up                               *
* Date   : 08/07/20                                                                               *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
int ConfigurationFileEditor::ReadSwitchWarning(int &value)
{
    TiXmlDocument doc(m_FilePath.c_str());

    if ( !doc.LoadFile() )
    {
        return -1;
    }


    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;
    TiXmlElement* xmlItemElement = 0;
	TiXmlNode * pNode = 0;

	pNode = doc.FirstChild(ROOT);
	xmlRootElement = pNode->ToElement();
	if (NULL == xmlRootElement)
	{
	    return -1;
	}

	pNode = xmlRootElement->FirstChild(WARNING_SUB);
    xmlSubElement = pNode->ToElement();
    if (NULL == xmlSubElement)
	{
	    return -1;
	}

	pNode = xmlSubElement->FirstChild(SWITCH);
	xmlItemElement = pNode->ToElement();
    if (NULL == xmlItemElement)
	{
	    return -1;
	}

	xmlItemElement->Attribute(VALUE, &value);

	return 1;
}

/**************************************************************************************************
* Function Name : Read                                                                            *
* Description  : get all schemes                                                                  *
* Date   : 08/07/20                                                                               *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
int ConfigurationFileEditor::Read(vector<PSchemeList_t> &schemeVec)
{

    TiXmlDocument doc(m_FilePath.c_str());

    if ( !doc.LoadFile() )
    {
        return -1;
    }


    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;
	TiXmlNode * pNode = NULL;

	pNode = doc.FirstChild(ROOT);
	xmlRootElement = pNode->ToElement();
	if (NULL == xmlRootElement)
	{
	    return -1;
	}

    pNode = xmlRootElement->FirstChild(SCHEME_SUB);
    xmlSubElement = pNode->ToElement();
    if (NULL == xmlSubElement)
	{
	    return -1;
	}

    TiXmlElement* xmlItemElement = 0;
    pNode = xmlSubElement->FirstChild(ITEM);

    while(pNode)
    {
        PSchemeList_t scheme = new SchemeList_t();
        xmlItemElement = pNode->ToElement();

        if ( NULL == xmlItemElement->Attribute(NAME.c_str()) )
        {
            return -1;
        }
        scheme->name = xmlItemElement->Attribute(NAME.c_str());
         xmlItemElement->Attribute(SCHEMEID.c_str(), &(scheme->id));
        xmlItemElement->Attribute(VALUE.c_str(), &(scheme->value));

        schemeVec.push_back(scheme);

        pNode = pNode->NextSibling();
    }

    return 1;

}

/**************************************************************************************************
* Function Name : Save                                                                            *
* Description  : save the Options dialog's value                                                  *
* Date   : 08/07/20                                                                               *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
int ConfigurationFileEditor::Save(int autoStart, int warning)
{
    int iRet = -1;


    if ((0 != autoStart) && (1 != autoStart) )
    {
        autoStart = 1;
    }

    if ((0 != warning) && (1 != warning) )
    {
        warning = 1;
    }

    TiXmlDocument doc(m_FilePath.c_str());

    if ( !doc.LoadFile() )
    {
        return iRet;
    }


    TiXmlElement* xmlRootElement = 0;
//    TiXmlElement* xmlSubElement = 0;
	TiXmlNode * pNode = NULL;

	pNode = doc.FirstChild(ROOT);
	xmlRootElement = pNode->ToElement();
	if (NULL == xmlRootElement)
	{
	    return iRet;
	}

    //
    // Save warning info
    //
    TiXmlElement* xmlWarningElement = 0;
    TiXmlElement* xmlSwitchElement = 0;
    TiXmlElement* xmlAutoElement = 0;

    pNode = xmlRootElement->FirstChild(WARNING_SUB);
    if ( NULL == pNode )
    {
        xmlWarningElement = new TiXmlElement(WARNING_SUB);
        pNode = xmlRootElement->LinkEndChild(xmlWarningElement);
        if ( NULL == pNode )
        {
            return iRet;
        }
    }
    else
    {
        xmlWarningElement = pNode->ToElement();
    }


    pNode = xmlWarningElement->FirstChild(SWITCH);
    if ( NULL == pNode)
    {
        xmlSwitchElement = new TiXmlElement(SWITCH);
        xmlSwitchElement->SetAttribute(VALUE.c_str(), warning);
        pNode = xmlWarningElement->LinkEndChild(xmlSwitchElement);
        if ( NULL == pNode )
        {
            return iRet;
        }

    }
    else
    {
        xmlSwitchElement = pNode->ToElement();
        xmlSwitchElement->SetAttribute(VALUE.c_str(), warning);
    }

    pNode = xmlWarningElement->FirstChild(AUTO_START);
    if ( NULL == pNode)
    {
        xmlAutoElement = new TiXmlElement(AUTO_START);
        xmlAutoElement->SetAttribute(VALUE.c_str(), autoStart);
        pNode = xmlAutoElement->LinkEndChild(xmlAutoElement);
        if ( NULL == pNode )
        {
            return iRet;
        }

    }
    else
    {
        xmlAutoElement = pNode->ToElement();
        xmlAutoElement->SetAttribute(VALUE.c_str(), autoStart);
    }


    // Save file
    if(doc.SaveFile())
    {
        iRet = 1;
    }

    return iRet;
}

/**Deprecated*/
int ConfigurationFileEditor::RecordDevicesOldStatus(int schemeId, vector<string> &deviceVec)
{
    int iRet = -1;

    TiXmlDocument doc(m_FilePath.c_str());
    if ( !doc.LoadFile() )
    {
        return iRet;
    }

    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;
	TiXmlNode * pNode = 0;

	pNode = doc.FirstChild(ROOT);
	if (NULL == pNode)
	{
	    return iRet;
	}
	xmlRootElement = pNode->ToElement();

    pNode = xmlRootElement->FirstChild(DEVICES_SUB);
    if ( NULL == pNode )
    {
        xmlSubElement = new TiXmlElement(DEVICES_SUB);
        if (NULL == xmlSubElement)
        {
            return iRet;
        }

        xmlRootElement->LinkEndChild(xmlSubElement);
    }
    else
    {
        xmlSubElement = pNode->ToElement();
        if (NULL == xmlSubElement)
        {
            return iRet;
        }
    }

    TiXmlElement* xmlItemElement = 0;
    TiXmlElement* xmlDeviceElement = 0;

    xmlItemElement = new TiXmlElement(ITEM);
    if (NULL == xmlItemElement)
    {
        return iRet;
    }

    xmlItemElement->SetAttribute(SCHEMEID, schemeId);
    pNode = xmlSubElement->LinkEndChild(xmlItemElement);
    if (NULL == pNode)
    {
        return iRet;
    }

    for (vector<string>::size_type ix = 0; ix != deviceVec.size(); ++ix)
    {
        xmlDeviceElement = new TiXmlElement(deviceVec[ix]);
        pNode = xmlItemElement->LinkEndChild(xmlDeviceElement);
        if (NULL == pNode)
        {
            return iRet;
        }
    }

    if(doc.SaveFile())
    {
        iRet = 1;
    }
    return iRet;
}

/**Deprecated*/
int ConfigurationFileEditor::ReadDevicesOldStatus(int schemeId, vector<string> &deviceVec)
{
    int iRet = -1;

    TiXmlDocument doc(m_FilePath.c_str());

    if ( !doc.LoadFile() )
    {
        return iRet;
    }

    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;
	TiXmlNode * pNode = 0;

	pNode = doc.FirstChild(ROOT);
	if (NULL == pNode)
	{
	    return iRet;
	}
	xmlRootElement = pNode->ToElement();

    pNode = xmlRootElement->FirstChild(DEVICES_SUB);
    if (NULL == pNode)
    {
        return iRet;
    }
    xmlSubElement = pNode->ToElement();

    TiXmlElement* xmlItemElement = 0;

    pNode = xmlSubElement->FirstChild(ITEM);
    while (pNode)
    {
        xmlItemElement = pNode->ToElement();

        int idTemp = 0;
        xmlItemElement->Attribute(SCHEMEID.c_str(), &idTemp);

        if ( idTemp == schemeId )
        {
            TiXmlNode *child = 0;

            child = xmlItemElement->FirstChild();
            while (child)
            {
                deviceVec.push_back(child->ValueStr());

                child = child->NextSibling();
            }

            if ( !xmlSubElement->RemoveChild(pNode))
            {
                return iRet;
            }

            break;
        }

        pNode = pNode->NextSibling();
    }

    if(doc.SaveFile())
    {
        iRet = 1;
    }

    return iRet;

}

/**************************************************************************************************
* Function Name : GetAutoStart                                                                    *
* Description  : get the autostart value                                                          *
* Date   : 08/07/20                                                                               *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
int ConfigurationFileEditor::GetAutoStart(int &value)
{
    TiXmlDocument doc(m_FilePath.c_str());

    if ( !doc.LoadFile() )
    {
        return -1;
    }


    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;
    TiXmlElement* xmlItemElement = 0;
	TiXmlNode * pNode = 0;

	pNode = doc.FirstChild(ROOT);
	xmlRootElement = pNode->ToElement();
	if (NULL == xmlRootElement)
	{
	    return -1;
	}

	pNode = xmlRootElement->FirstChild(WARNING_SUB);
    xmlSubElement = pNode->ToElement();
    if (NULL == xmlSubElement)
	{
	    return -1;
	}

	pNode = xmlSubElement->FirstChild(AUTO_START);
	xmlItemElement = pNode->ToElement();
    if (NULL == xmlItemElement)
	{
	    return -1;
	}

	xmlItemElement->Attribute(VALUE, &value);

	return 1;
}
