/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          OptionsDialog.cpp

Description:

    This file implements class OptionsDialog.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#include "include/OptionsDialog.h"
#include "include/DataMiddle.h"
#include "include/PMGlobalConstant.h"

//(*InternalHeaders(OptionsDialog)
#include <wx/bitmap.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
#include <wx/msgdlg.h>
//*)

//(*IdInit(OptionsDialog)
const long OptionsDialog::ID_STATICTEXT1 = wxNewId();
const long OptionsDialog::ID_PANEL1 = wxNewId();
const long OptionsDialog::ID_STATICBOX1 = wxNewId();
const long OptionsDialog::ID_CHECKBOX1 = wxNewId();
const long OptionsDialog::ID_BUTTON1 = wxNewId();
const long OptionsDialog::ID_BUTTON2 = wxNewId();
const long OptionsDialog::ID_STATICBITMAP1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(OptionsDialog,wxDialog)
	//(*EventTable(OptionsDialog)
	//*)
END_EVENT_TABLE()

/**constructor*/
OptionsDialog::OptionsDialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(OptionsDialog)
	Create(parent, wxID_ANY, _("General Settings"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	SetClientSize(wxSize(435,340));
	TitleStaticBitmap = new wxStaticBitmap(this, ID_STATICBITMAP1, wxBitmap(wxImage(_T("/etc/ipower-management/pictures/Options_Banner.png")).Rescale(wxSize(435,53).GetWidth(),wxSize(435,53).GetHeight())), wxPoint(0,5), wxSize(435,53), 0, _T("ID_STATICBITMAP1"));
	StaticText1 = new wxStaticText(this, wxID_ANY, _("General Settings"), wxPoint(55,20), wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	//CheckBoxListPanel = new wxPanel(this, ID_PANEL1, wxPoint(16,95), wxSize(405,165), wxSIMPLE_BORDER|wxTAB_TRAVERSAL, _T("ID_PANEL1"));
	//CheckBoxListPanel->SetBackgroundColour(wxColour(255,255,255));

	StaticBox_UI_DeviceDisableSetting = new wxStaticBox(this, ID_STATICBOX1, _("General Settings"), wxPoint(16,95), wxSize(405,145), 0, _T("ID_STATICBOX1"));

	CheckBox_AutoStart = new wxCheckBox(this, wxID_ANY, wxEmptyString,  wxPoint(25,135), wxDefaultSize, 0, wxDefaultValidator, _T("ID_CHECKBOX1"));
    CheckBox_AutoStart->SetValue(true);
    StaticTextAutoStart = new wxStaticText(this, wxID_ANY, _("Run Power Manager when Linux starts."), wxPoint(45,137), wxDefaultSize, 0, _T("ID_STATICTEXT"));
    StaticTextAutoStart->Wrap(360);
    CheckBox_AutoStart->SetFocus();

	CheckBox_Ask = new wxCheckBox(this, ID_CHECKBOX1, wxEmptyString, wxPoint(25,177), wxDefaultSize, 0, wxDefaultValidator, _T("ID_CHECKBOX1"));
	CheckBox_Ask->SetValue(true);
    StaticTextPopDlg = new wxStaticText(this, wxID_ANY,  _("Ask me if device(s) is to be disabled for power saving."), wxPoint(45,179), wxDefaultSize, 0, _T("ID_STATICTEXT"));
    StaticTextPopDlg->Wrap(380);

	Button_Cancel = new wxButton(this, ID_BUTTON1, _("Cancel"), wxPoint(338,300), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button_Cancel->SetDefault();
	Button_OK = new wxButton(this, ID_BUTTON2, _("OK"), wxPoint(230,300), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BUTTON2"));

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&OptionsDialog::OnButton_CancelClick);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&OptionsDialog::OnButton_OKClick);
	Connect(wxID_ANY,wxEVT_CLOSE_WINDOW,(wxObjectEventFunction)&OptionsDialog::OnClose);
	//*)

	// Set font
	wxFont StaticTextBoldFont(14,wxSWISS,wxFONTSTYLE_NORMAL,wxBOLD,false,_T("Sans"),wxFONTENCODING_DEFAULT);
    StaticText1->SetFont(StaticTextBoldFont);
    StaticText1->SetForegroundColour(wxColour(250,250,250));

    wxFont StaticTextFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
    // CheckBoxListPanel->SetFont(StaticTextFont);
    CheckBox_Ask->SetFont(StaticTextFont);

    DataMiddle::GetInstance()->AttachOptionsDlg(this);

    IniDlg();
}

/**destructor*/
OptionsDialog::~OptionsDialog()
{
	//(*Destroy(OptionsDialog)
	//*)
	DataMiddle::GetInstance()->DettachOptionsDlg();
}

/**initial the dialog*/
void OptionsDialog::IniDlg()
{
  //  CheckBoxListPanel->DestroyChildren();
    m_SchemeList.clear();
    m_CheckboxList.clear();

    ConfigurationFileEditor fileEditor;

    int isWarning = 0;
    int isAutoStart = 0;
    fileEditor.ReadSwitchWarning(isWarning);
    if (0 == isWarning)
    {
        CheckBox_Ask->SetValue(false);
    }
    fileEditor.GetAutoStart(isAutoStart);

    if (0 == isAutoStart)
    {
        CheckBox_AutoStart->SetValue(false);
    }


}

/**the OK button click event handler*/
void OptionsDialog::OnButton_OKClick(wxCommandEvent& event)
{
    int isWarning = 0;
    if ( CheckBox_Ask->GetValue() )
    {
        isWarning = 1;
    }

    int isAutoStart = 0;
    if ( CheckBox_AutoStart->GetValue() )
    {
        isAutoStart = 1;
    }

    ConfigurationFileEditor fileEditor;
    fileEditor.Save(isAutoStart, isWarning);

    Destroy();
}

/**the Cancel button click event handler*/
void OptionsDialog::OnButton_CancelClick(wxCommandEvent& event)
{
    Destroy();
}

/**the window close event handler*/
void OptionsDialog::OnClose(wxCloseEvent& event)
{
    Destroy();
}
