/*
 * Easy Network Plugin API
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef DCS_EASYNETWORKMANAGER_PLUGIN_H
#define DCS_EASYNETWORKMANAGER_PLUGIN_H

#include "DCSCommon.h"
/** DCS Easy Network Manager operations exposed to clients. */
typedef enum DCS_ENM_Operation_E {
    ENM_INIT_USER_INFO,
	ENM_ALLOCATE_DH_IP,
    ENM_CLOSE_WLAN_CONNECTION,
    ENM_SEARCH_ADAPTER,
    ENM_UP_ADAPTER,
    ENM_DOWN_ADAPTER,
    ENM_IS_EXIST_UP_ADAPTER,
    ENM_IS_EXIST_CONNECT_ADAPTER,
    ENM_CONNECT_AP,
    ENM_GET_AP_LIST,
    ENM_GET_CURRENT_AP,
    ENM_GET_IP_ADDRESS_HLAN,
    ENM_GET_CONNECT_TYPE_HLAN,
    ENM_GET_IP_ADDRESS_LAN,
    ENM_GET_CONNECT_TYPE_LAN,
    ENM_ENABLE_8021X_AUTHENTICATION,
    ENM_ENABLE_INTERNET_SHARING,
    ENM_OVERWRITE_HOMEPAGE,
    ENM_OVERWRITE_DEFAULT_BROWSER_HOMEPAGE,
    ENM_OVERWRITE_PROXY,
    ENM_GET_NEIGHBORS_INFO,
    ENM_GET_NEIGHBOR_INFO,
    ENM_CHANGE_ADDRESS,
    ENM_ENABLE_FILE_AND_PRINTER_SHARE,
    ENM_ENABLE_WINDOWS_FIREWALL,
    ENM_IS_EXIST_ADAPTER,
    ENM_IMPORT_SCHOOL_SETTINGS,
    ENM_DISPATCH_DISABLE_EVENT,
	NN_EXCUTE_COMMAND,
	NN_TURNON_MESH,
	NN_SET_MESH_SECURITY_INFO,
	NN_SET_MESH_ID,
	NN_SET_MESH_AUTOLINK,
	NN_ADD_MESH_LINK,
	NN_DEL_MESH_LINK,
	NN_SET_MESH_CHANNEL,
	NN_SET_MESH_HOSTNAME,
	NN_ENABLE_MESH_ONLY,
	NN_ENABLE_MESH_FORWARDING,
	NN_SET_MESH_CHANNEL_BAND_WIDTH,
	NN_SET_MESH_CHANNEL_OFFSET,
	NN_GET_MESH_SECURITY_INFO,
	NN_GET_MESH_ID,
	NN_GET_MESH_AUTOLINK,
	NN_GET_MESH_LINKSTATUS,
	NN_LIST_ALL_NEIGHBOR_MPS,
	NN_GET_MESH_ROUTE_LIST,
	NN_GET_MESH_CHANNEL,
	NN_GET_MESH_ONLY_MODE,
	NN_GET_MESH_DEVICE_NAME,
	NN_GET_MESH_CHANNEL_BAND_WIDTH,
	NN_GET_MESH_CHANNEL_OFFSET,
	NN_GET_MESH_HOST_NAME,
	NN_ENABLE_MESH_SERVER,
	NN_ENABLE_MESH_CLIENT,
	NN_GET_GATEWAY_INFO,
	NN_DELETE_PROFILE
} DCS_ENM_Operation;

/** DCS Easy Network Manager events dispatchable to clients. */
typedef enum DCS_ENM_Event_E {
	ENM_NETWORK_MODE_CHANGED=DCS_EVENT_NUM_START,
	ENM_NETWORK_STATUS_INFO_CHANGED,
	ENM_MESH_POINT_INFO_CHANGED,
	ENM_MESH_PORTAL_INFO_CHANGED,
	ENM_MESH_CLIENT_INFO_CHANGED,
	ENM_AP_INFO_CHANGED,
	ENM_NEIGHBORS_INFO_CHANGED,
    ENM_APPLY_PROFILE,
    ENM_LAN_DISABLED,
    ENM_WLAN_DISABLED
} DCS_ENM_Event;

#endif /* DCS_EASYNETWORKMANAGER_PLUGIN_H */
