/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMNew1Dialog.h

Description:

    This file defines class PMNew1Dialog.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Lin Xin 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef PMNEW1DIALOG_H
#define PMNEW1DIALOG_H

#include "wx/wxprec.h"
#include "wx/frame.h"
#include "wx/stattext.h"
#include "wx/log.h"
#include "wx/app.h"
#include "wx/checkbox.h"
#include "wx/checklst.h"
#include "wx/msgdlg.h"
#include "wx/radiobox.h"
#include "wx/menu.h"
#include "wx/sizer.h"
#include "wx/wizard.h"
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/checkbox.h>
#include <wx/statline.h>
#include <wx/panel.h>
#include <wx/statbmp.h>
#include <wx/dialog.h>
#include <wx/combobox.h>
#include <wx/bmpcbox.h>

#include "PMNew2Dialog.h"
#include "PMNew3Dialog.h"

#include "PowerSchemeMgmtProxy.h"
#include "ConfigurationFileEditor.h"
#include <sstream>

class PowerSchemeMgmtProxy;

class PMNew1Dialog : public wxWizard
{
    public:
        //constructor
        PMNew1Dialog(wxWindow *frame);
        //destructor
        ~PMNew1Dialog();
        //get first page
        wxWizardPage *GetFirstPage() const { return m_pagestep1; }

		//(*Declarations(PMNew1Dialog)
		wxStaticBitmap* StaticBitmap_New1Top;
		wxTextCtrl* TextCtrl_SchemeName;
		wxStaticText* StaticText_UI_SchemeName;
		//*)
		wxStaticText* StaticTextBaner;
		wxStaticText* StaticTextBaner2;

	protected:

		//(*Identifiers(PMNew1Dialog)
		static const long ID_STATICTEXT_UI_SCHEMENAME;
		static const long ID_STATICBITMAP_NEW1TOP;
		static const long ID_TEXTCTRL_SCHEMENAME;
		//*)

    private:

        wxWizardPageSimple *m_pagestep1;
        PMNew2Dialog *m_pagestep2;
        PMNew3Dialog *m_pagestep3;
        //initial default scheme name
        void InitSchemeName();
        //next button action
        void OnWizardNext(wxWizardEvent& event);
        //cancel button action
        void OnWizardCancel(wxWizardEvent& event);
        //finish button action
        void OnWizardFinished(wxWizardEvent& event);
        //map event
        DECLARE_EVENT_TABLE()

};
#endif
