#!/bin/bash

export LANG=C

readonly BASEDIR=$(dirname "$0")/../lib
. $BASEDIR/device.db
. $BASEDIR/config.sh

Q()
{
	[ -f $BASEDIR/config.db ] || exit

	sqlite3 $BASEDIR/config.db "$@"
}

Q "SELECT devids FROM configs;" \
| filter_core_devices \
| egrep -v $FILTER_GPU_DEVICES \
| sort \
| uniq \
| filter_unknown_devices
