/* daemon.c generated by valac, the Vala compiler
 * generated from daemon.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <unity.h>
#include <zeitgeist.h>
#include <unity-package-search.h>
#include <gee.h>
#include <gio/gio.h>
#include <dee.h>
#include <gnome-menus/gmenu-tree.h>
#include <glib/gi18n-lib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus.h>


#define UNITY_APPLICATIONS_PLACE_TYPE_DAEMON (unity_applications_place_daemon_get_type ())
#define UNITY_APPLICATIONS_PLACE_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_APPLICATIONS_PLACE_TYPE_DAEMON, UnityApplicationsPlaceDaemon))
#define UNITY_APPLICATIONS_PLACE_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_APPLICATIONS_PLACE_TYPE_DAEMON, UnityApplicationsPlaceDaemonClass))
#define UNITY_APPLICATIONS_PLACE_IS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_APPLICATIONS_PLACE_TYPE_DAEMON))
#define UNITY_APPLICATIONS_PLACE_IS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_APPLICATIONS_PLACE_TYPE_DAEMON))
#define UNITY_APPLICATIONS_PLACE_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_APPLICATIONS_PLACE_TYPE_DAEMON, UnityApplicationsPlaceDaemonClass))

typedef struct _UnityApplicationsPlaceDaemon UnityApplicationsPlaceDaemon;
typedef struct _UnityApplicationsPlaceDaemonClass UnityApplicationsPlaceDaemonClass;
typedef struct _UnityApplicationsPlaceDaemonPrivate UnityApplicationsPlaceDaemonPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _unity_package_searcher_free0(var) ((var == NULL) ? NULL : (var = (unity_package_searcher_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _gmenu_tree_unref0(var) ((var == NULL) ? NULL : (var = (gmenu_tree_unref (var), NULL)))

#define UNITY_APPLICATIONS_PLACE_TYPE_SECTIONS_COLUMN (unity_applications_place_sections_column_get_type ())

#define UNITY_APPLICATIONS_PLACE_TYPE_GROUPS_COLUMN (unity_applications_place_groups_column_get_type ())

#define UNITY_APPLICATIONS_PLACE_TYPE_GROUP (unity_applications_place_group_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define UNITY_APPLICATIONS_PLACE_TYPE_SECTION (unity_applications_place_section_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnityApplicationsPlaceDaemonSearchAsyncData UnityApplicationsPlaceDaemonSearchAsyncData;
#define _unity_package_search_result_free0(var) ((var == NULL) ? NULL : (var = (unity_package_search_result_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

#define UNITY_APPLICATIONS_PLACE_TYPE_RESULTS_COLUMN (unity_applications_place_results_column_get_type ())
typedef struct _UnityApplicationsPlaceDaemonActivateData UnityApplicationsPlaceDaemonActivateData;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _UnityApplicationsPlaceDaemon {
	GObject parent_instance;
	UnityApplicationsPlaceDaemonPrivate * priv;
};

struct _UnityApplicationsPlaceDaemonClass {
	GObjectClass parent_class;
};

struct _UnityApplicationsPlaceDaemonPrivate {
	ZeitgeistLog* log;
	ZeitgeistIndex* zg_index;
	UnityPackageSearcher* pkgsearcher;
	UnityPackageSearcher* appsearcher;
	UnityPlaceController* control;
	UnityPlaceEntryInfo* applications;
	GeeList* section_queries;
	GeeList* section_categories;
	GeeList* image_extensions;
	GHashTable* file_icon_cache;
	UnityPlaceSearch* previous_search;
	UnityPlaceSearch* previous_global_search;
	guint previous_active_section;
	DeeIndex* entry_results_by_group;
	DeeIndex* global_results_by_group;
	GPtrArray* zg_templates;
	guint app_menu_changed_reindex_timeout;
	GMenuTree* app_menu;
};

typedef enum  {
	UNITY_APPLICATIONS_PLACE_SECTIONS_COLUMN_DISPLAY_NAME = 0,
	UNITY_APPLICATIONS_PLACE_SECTIONS_COLUMN_ICON_HINT
} UnityApplicationsPlaceSectionsColumn;

typedef enum  {
	UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_RENDERER = 0,
	UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_DISPLAY_NAME,
	UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_ICON_HINT
} UnityApplicationsPlaceGroupsColumn;

typedef enum  {
	UNITY_APPLICATIONS_PLACE_GROUP_MOST_USED,
	UNITY_APPLICATIONS_PLACE_GROUP_INSTALLED,
	UNITY_APPLICATIONS_PLACE_GROUP_AVAILABLE,
	UNITY_APPLICATIONS_PLACE_GROUP_EMPTY_SEARCH,
	UNITY_APPLICATIONS_PLACE_GROUP_EMPTY_SECTION
} UnityApplicationsPlaceGroup;

typedef enum  {
	UNITY_APPLICATIONS_PLACE_SECTION_ALL_APPLICATIONS = 0,
	UNITY_APPLICATIONS_PLACE_SECTION_ACCESSORIES,
	UNITY_APPLICATIONS_PLACE_SECTION_GAMES,
	UNITY_APPLICATIONS_PLACE_SECTION_INTERNET,
	UNITY_APPLICATIONS_PLACE_SECTION_MEDIA,
	UNITY_APPLICATIONS_PLACE_SECTION_OFFICE,
	UNITY_APPLICATIONS_PLACE_SECTION_SYSTEM,
	UNITY_APPLICATIONS_PLACE_SECTION_LAST_SECTION
} UnityApplicationsPlaceSection;

struct _UnityApplicationsPlaceDaemonSearchAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityApplicationsPlaceDaemon* self;
	UnityPlaceSearch* search;
	UnityApplicationsPlaceSection section;
	DeeModel* results_model;
	DeeModel* groups_model;
	gboolean is_filter_search;
	DeeIndex* results_by_group;
	char* search_string;
	ZeitgeistResultSet* results;
	ZeitgeistTimeRange* _tmp0_;
	ZeitgeistResultSet* _tmp1_;
	char* _tmp2_;
	guint group;
	DeeResultSet* filter_set;
	char* _tmp3_;
	DeeResultSet* _tmp4_;
	GeeSet* app_uris;
	ZeitgeistResultSet* _ev_it;
	ZeitgeistEvent* ev;
	ZeitgeistEvent* _tmp5_;
	char* _tmp6_;
	GError * e;
	GError * _inner_error_;
};

typedef enum  {
	UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_URI = 0,
	UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_ICON_HINT,
	UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_GROUP_ID,
	UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_MIMETYPE,
	UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_DISPLAY_NAME,
	UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_COMMENT
} UnityApplicationsPlaceResultsColumn;

struct _UnityApplicationsPlaceDaemonActivateData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityApplicationsPlaceDaemon* self;
	char* uri;
	guint32 result;
	const char* pkg;
	char** args;
	char** _tmp0_;
	gint _args_size_;
	gint args_length1;
	char* _tmp1_;
	char* _tmp2_;
	GError * e;
	GError * _inner_error_;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};


static gpointer unity_applications_place_daemon_parent_class = NULL;
static UnityPlaceActivationIface* unity_applications_place_daemon_unity_place_activation_parent_iface = NULL;

#define CONFIG_DATADIR "/usr/share"
#define UNITY_APPLICATIONS_PLACE_ICON_PATH CONFIG_DATADIR "/icons/unity-icon-theme/places/svg/"
GType unity_applications_place_daemon_get_type (void) G_GNUC_CONST;
#define UNITY_APPLICATIONS_PLACE_DAEMON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_APPLICATIONS_PLACE_TYPE_DAEMON, UnityApplicationsPlaceDaemonPrivate))
enum  {
	UNITY_APPLICATIONS_PLACE_DAEMON_DUMMY_PROPERTY
};
GType unity_applications_place_sections_column_get_type (void) G_GNUC_CONST;
static void unity_applications_place_daemon_populate_sections (UnityApplicationsPlaceDaemon* self);
GType unity_applications_place_groups_column_get_type (void) G_GNUC_CONST;
GType unity_applications_place_group_get_type (void) G_GNUC_CONST;
static void unity_applications_place_daemon_populate_groups (UnityApplicationsPlaceDaemon* self);
static void unity_applications_place_daemon_populate_global_groups (UnityApplicationsPlaceDaemon* self);
static void unity_applications_place_daemon_populate_section_queries (UnityApplicationsPlaceDaemon* self);
static void unity_applications_place_daemon_populate_section_categories (UnityApplicationsPlaceDaemon* self);
static gboolean unity_applications_place_daemon_build_app_menu_index (UnityApplicationsPlaceDaemon* self);
static gboolean _unity_applications_place_daemon_build_app_menu_index_gsource_func (gpointer self);
static void _lambda0_ (GMenuTree* menu, UnityApplicationsPlaceDaemon* self);
static void __lambda0__gmenu_tree_changed_func (GMenuTree* tree, gpointer self);
static void unity_applications_place_daemon_populate_zg_templates (UnityApplicationsPlaceDaemon* self);
GType unity_applications_place_section_get_type (void) G_GNUC_CONST;
static char* unity_applications_place_daemon_prepare_search_string (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, UnityApplicationsPlaceSection section);
static gboolean unity_applications_place_daemon_check_is_filter_search (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* new_search, UnityPlaceSearch* old_search);
static gboolean unity_applications_place_daemon_check_search_invalid (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search);
static void unity_applications_place_daemon_search_async_data_free (gpointer _data);
static void unity_applications_place_daemon_search_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void unity_applications_place_daemon_append_events_with_group (UnityApplicationsPlaceDaemon* self, ZeitgeistResultSet* events, DeeModel* results, guint group_id, gint section_filter);
void unity_applications_place_utils_apply_uri_filter (GeeSet* valid_uris, DeeResultSet* filter_set);
static gboolean unity_applications_place_daemon_update_pkg_search (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, UnityApplicationsPlaceSection section, DeeModel* model, gboolean is_filter_search, DeeIndex* results_by_group);
void unity_applications_place_daemon_check_empty_section (UnityApplicationsPlaceDaemon* self, UnityApplicationsPlaceSection section, DeeModel* results_model);
void unity_applications_place_daemon_check_empty_search (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, DeeModel* results_model);
static void unity_applications_place_daemon_search_async (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, UnityApplicationsPlaceSection section, DeeModel* results_model, DeeModel* groups_model, gboolean is_filter_search, DeeIndex* results_by_group, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_applications_place_daemon_search_finish (UnityApplicationsPlaceDaemon* self, GAsyncResult* _res_);
static gboolean unity_applications_place_daemon_search_async_co (UnityApplicationsPlaceDaemonSearchAsyncData* data);
static char* unity_applications_place_daemon_prepare_pkg_search_string (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, UnityApplicationsPlaceSection section);
static GIcon* unity_applications_place_daemon_find_pkg_icon (UnityApplicationsPlaceDaemon* self, UnityPackageInfo* pkginfo);
static void unity_applications_place_daemon_on_appinfo_changed (UnityApplicationsPlaceDaemon* self, const char* id, GAppInfo* appinfo);
static gboolean unity_applications_place_daemon_search_is_invalid (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search);
static void unity_applications_place_daemon_add_pkg_search_result (UnityApplicationsPlaceDaemon* self, UnityPackageSearchResult* results, GeeSet* installed_uris, GeeSet* available_uris, DeeModel* model, UnityApplicationsPlaceGroup group, DeeIndex* results_by_group, gboolean is_filter_search);
GType unity_applications_place_results_column_get_type (void) G_GNUC_CONST;
static void unity_applications_place_daemon_real_activate_data_free (gpointer _data);
static void unity_applications_place_daemon_real_activate (UnityPlaceActivation* base, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_applications_place_daemon_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean unity_applications_place_daemon_real_activate_co (UnityApplicationsPlaceDaemonActivateData* data);
GAppInfo* unity_applications_place_utils_get_app_info_for_actor (const char* actor);
UnityApplicationsPlaceDaemon* unity_applications_place_daemon_new (void);
UnityApplicationsPlaceDaemon* unity_applications_place_daemon_construct (GType object_type);
#define CONFIG_PREFIX "/usr"
static void _lambda1_ (GObject* obj, GParamSpec* pspec, UnityApplicationsPlaceDaemon* self);
static void __lambda1__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean unity_applications_place_utils_search_has_really_changed (UnityPlaceSearch* old_search, UnityPlaceSearch* new_search);
static void _lambda2_ (GObject* obj, GParamSpec* pspec, UnityApplicationsPlaceDaemon* self);
static void __lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda3_ (GObject* obj, GParamSpec* pspec, UnityApplicationsPlaceDaemon* self);
static void __lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _unity_applications_place_daemon_on_appinfo_changed_unity_app_info_manager_changed (UnityAppInfoManager* _sender, const char* id, GAppInfo* new_appinfo, gpointer self);
static GObject * unity_applications_place_daemon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void unity_applications_place_daemon_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _unity_applications_place_daemon_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult unity_applications_place_daemon_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_unity_applications_place_daemon_introspect (UnityApplicationsPlaceDaemon* self, DBusConnection* connection, DBusMessage* message);
static void unity_applications_place_daemon_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const DBusObjectPathVTable _unity_applications_place_daemon_dbus_path_vtable = {_unity_applications_place_daemon_dbus_unregister, unity_applications_place_daemon_dbus_message};
static const _DBusObjectVTable _unity_applications_place_daemon_dbus_vtable = {unity_applications_place_daemon_dbus_register_object};


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void unity_applications_place_daemon_populate_sections (UnityApplicationsPlaceDaemon* self) {
	DeeModel* sections;
	g_return_if_fail (self != NULL);
	sections = _g_object_ref0 (unity_place_entry_info_get_sections_model (self->priv->applications));
	if (dee_model_get_n_rows (sections) != 0) {
		g_critical ("daemon.vala:239: The sections model should be empty before initial pop" \
"ulation");
		dee_model_clear (sections);
	}
	dee_model_append (sections, UNITY_APPLICATIONS_PLACE_SECTIONS_COLUMN_DISPLAY_NAME, _ ("All Applications"), UNITY_APPLICATIONS_PLACE_SECTIONS_COLUMN_ICON_HINT, "", -1, NULL);
	dee_model_append (sections, UNITY_APPLICATIONS_PLACE_SECTIONS_COLUMN_DISPLAY_NAME, _ ("Accessories"), UNITY_APPLICATIONS_PLACE_SECTIONS_COLUMN_ICON_HINT, "", -1, NULL);
	dee_model_append (sections, UNITY_APPLICATIONS_PLACE_SECTIONS_COLUMN_DISPLAY_NAME, _ ("Games"), UNITY_APPLICATIONS_PLACE_SECTIONS_COLUMN_ICON_HINT, "", -1, NULL);
	dee_model_append (sections, UNITY_APPLICATIONS_PLACE_SECTIONS_COLUMN_DISPLAY_NAME, _ ("Internet"), UNITY_APPLICATIONS_PLACE_SECTIONS_COLUMN_ICON_HINT, "", -1, NULL);
	dee_model_append (sections, UNITY_APPLICATIONS_PLACE_SECTIONS_COLUMN_DISPLAY_NAME, _ ("Media"), UNITY_APPLICATIONS_PLACE_SECTIONS_COLUMN_ICON_HINT, "", -1, NULL);
	dee_model_append (sections, UNITY_APPLICATIONS_PLACE_SECTIONS_COLUMN_DISPLAY_NAME, _ ("Office"), UNITY_APPLICATIONS_PLACE_SECTIONS_COLUMN_ICON_HINT, "", -1, NULL);
	dee_model_append (sections, UNITY_APPLICATIONS_PLACE_SECTIONS_COLUMN_DISPLAY_NAME, _ ("System"), UNITY_APPLICATIONS_PLACE_SECTIONS_COLUMN_ICON_HINT, "", -1, NULL);
	_g_object_unref0 (sections);
}


static void unity_applications_place_daemon_populate_groups (UnityApplicationsPlaceDaemon* self) {
	DeeModel* groups;
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	groups = _g_object_ref0 (unity_place_renderer_info_get_groups_model (unity_place_entry_info_get_entry_renderer_info (self->priv->applications)));
	if (dee_model_get_n_rows (groups) != 0) {
		g_critical ("daemon.vala:265: The groups model should be empty before initial popul" \
"ation");
		dee_model_clear (groups);
	}
	dee_model_append (groups, UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_RENDERER, "UnityShowcaseRenderer", UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_DISPLAY_NAME, _ ("Most Used"), UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_ICON_HINT, UNITY_APPLICATIONS_PLACE_ICON_PATH "group-mostused.svg", -1, NULL);
	dee_model_append (groups, UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_RENDERER, "UnityDefaultRenderer", UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_DISPLAY_NAME, _ ("Installed"), UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_ICON_HINT, UNITY_APPLICATIONS_PLACE_ICON_PATH "group-installed.svg", -1, NULL);
	dee_model_append (groups, UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_RENDERER, "UnityDefaultRenderer", UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_DISPLAY_NAME, _ ("Available"), UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_ICON_HINT, UNITY_APPLICATIONS_PLACE_ICON_PATH "group-available.svg", -1, NULL);
	dee_model_append (groups, UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_RENDERER, "UnityEmptySearchRenderer", UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_DISPLAY_NAME, "No search results", UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_ICON_HINT, "", -1, NULL);
	dee_model_append (groups, UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_RENDERER, "UnityEmptySectionRenderer", UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_DISPLAY_NAME, "Empty section", UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_ICON_HINT, "", -1, NULL);
	unity_place_renderer_info_set_hint (unity_place_entry_info_get_entry_renderer_info (self->priv->applications), "ExpandedGroups", _tmp0_ = g_strdup_printf ("%u", (guint) UNITY_APPLICATIONS_PLACE_GROUP_INSTALLED));
	_g_free0 (_tmp0_);
	_g_object_unref0 (groups);
}


static void unity_applications_place_daemon_populate_global_groups (UnityApplicationsPlaceDaemon* self) {
	DeeModel* groups;
	g_return_if_fail (self != NULL);
	groups = _g_object_ref0 (unity_place_renderer_info_get_groups_model (unity_place_entry_info_get_global_renderer_info (self->priv->applications)));
	if (dee_model_get_n_rows (groups) != 0) {
		g_critical ("daemon.vala:296: %s", "The global groups model should be empty " "before initial population");
		dee_model_clear (groups);
	}
	dee_model_append (groups, UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_RENDERER, "UnityDefaultRenderer", UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_DISPLAY_NAME, "", UNITY_APPLICATIONS_PLACE_GROUPS_COLUMN_ICON_HINT, UNITY_APPLICATIONS_PLACE_ICON_PATH "apps.svg", -1, NULL);
	_g_object_unref0 (groups);
}


static void unity_applications_place_daemon_populate_section_queries (UnityApplicationsPlaceDaemon* self) {
	g_return_if_fail (self != NULL);
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "NOT category:XYZ");
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "category:Utility");
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "category:Game");
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "category:Network");
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "(category:AudioVideo OR category:Graphics)");
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "category:Office");
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "(category:System OR category:Settings)");
}


static void unity_applications_place_daemon_populate_section_categories (UnityApplicationsPlaceDaemon* self) {
	GeeSet* cat;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	g_return_if_fail (self != NULL);
	cat = (GeeSet*) gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	gee_collection_add ((GeeCollection*) cat, "AudioVideo");
	gee_collection_add ((GeeCollection*) cat, "Development");
	gee_collection_add ((GeeCollection*) cat, "Education");
	gee_collection_add ((GeeCollection*) cat, "Game");
	gee_collection_add ((GeeCollection*) cat, "Graphics");
	gee_collection_add ((GeeCollection*) cat, "Network");
	gee_collection_add ((GeeCollection*) cat, "Office");
	gee_collection_add ((GeeCollection*) cat, "Settings");
	gee_collection_add ((GeeCollection*) cat, "System");
	gee_collection_add ((GeeCollection*) cat, "Utility");
	gee_collection_add ((GeeCollection*) self->priv->section_categories, cat);
	cat = (_tmp0_ = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL), _g_object_unref0 (cat), _tmp0_);
	gee_collection_add ((GeeCollection*) cat, "Utility");
	gee_collection_add ((GeeCollection*) self->priv->section_categories, cat);
	cat = (_tmp1_ = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL), _g_object_unref0 (cat), _tmp1_);
	gee_collection_add ((GeeCollection*) cat, "Game");
	gee_collection_add ((GeeCollection*) self->priv->section_categories, cat);
	cat = (_tmp2_ = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL), _g_object_unref0 (cat), _tmp2_);
	gee_collection_add ((GeeCollection*) cat, "Network");
	gee_collection_add ((GeeCollection*) self->priv->section_categories, cat);
	cat = (_tmp3_ = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL), _g_object_unref0 (cat), _tmp3_);
	gee_collection_add ((GeeCollection*) cat, "AudioVideo");
	gee_collection_add ((GeeCollection*) cat, "Graphics");
	gee_collection_add ((GeeCollection*) self->priv->section_categories, cat);
	cat = (_tmp4_ = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL), _g_object_unref0 (cat), _tmp4_);
	gee_collection_add ((GeeCollection*) cat, "Office");
	gee_collection_add ((GeeCollection*) self->priv->section_categories, cat);
	cat = (_tmp5_ = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL), _g_object_unref0 (cat), _tmp5_);
	gee_collection_add ((GeeCollection*) cat, "Settings");
	gee_collection_add ((GeeCollection*) cat, "System");
	gee_collection_add ((GeeCollection*) self->priv->section_categories, cat);
	_g_object_unref0 (cat);
}


static gpointer _gmenu_tree_ref0 (gpointer self) {
	return self ? gmenu_tree_ref (self) : NULL;
}


static gboolean _unity_applications_place_daemon_build_app_menu_index_gsource_func (gpointer self) {
	gboolean result;
	result = unity_applications_place_daemon_build_app_menu_index (self);
	return result;
}


static void _lambda0_ (GMenuTree* menu, UnityApplicationsPlaceDaemon* self) {
	g_return_if_fail (menu != NULL);
	if (self->priv->app_menu_changed_reindex_timeout != 0) {
		g_source_remove (self->priv->app_menu_changed_reindex_timeout);
	}
	self->priv->app_menu_changed_reindex_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _unity_applications_place_daemon_build_app_menu_index_gsource_func, g_object_ref (self), g_object_unref);
}


static void __lambda0__gmenu_tree_changed_func (GMenuTree* tree, gpointer self) {
	_lambda0_ (tree, self);
}


static gboolean unity_applications_place_daemon_build_app_menu_index (UnityApplicationsPlaceDaemon* self) {
	gboolean result = FALSE;
	UnityPackageSearcher* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->app_menu == NULL) {
		GMenuTree* _tmp0_;
		g_debug ("daemon.vala:377: Building initial application menu");
		self->priv->app_menu = (_tmp0_ = _gmenu_tree_ref0 (gmenu_tree_lookup ("unity-place-applications.menu", GMENU_TREE_FLAGS_INCLUDE_NODISPLAY)), _gmenu_tree_unref0 (self->priv->app_menu), _tmp0_);
		gmenu_tree_add_monitor (self->priv->app_menu, __lambda0__gmenu_tree_changed_func, self);
	}
	g_debug ("daemon.vala:398: Indexing application menu");
	self->priv->appsearcher = (_tmp1_ = unity_package_searcher_new_for_menu (self->priv->app_menu), _unity_package_searcher_free0 (self->priv->appsearcher), _tmp1_);
	self->priv->app_menu_changed_reindex_timeout = (guint) 0;
	result = FALSE;
	return result;
}


static void unity_applications_place_daemon_populate_zg_templates (UnityApplicationsPlaceDaemon* self) {
	GPtrArray* _tmp0_;
	ZeitgeistSubject* _tmp1_;
	ZeitgeistEvent* _tmp2_;
	ZeitgeistEvent* ev;
	ZeitgeistEvent* _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->zg_templates = (_tmp0_ = g_ptr_array_sized_new ((guint) 1), _g_ptr_array_unref0 (self->priv->zg_templates), _tmp0_);
	ev = (_tmp2_ = g_object_ref_sink (zeitgeist_event_new_full (ZEITGEIST_ZG_ACCESS_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, "", _tmp1_ = g_object_ref_sink (zeitgeist_subject_new_full ("application://*", "", "", "", "", "", "")), NULL)), _g_object_unref0 (_tmp1_), _tmp2_);
	g_ptr_array_add (self->priv->zg_templates, g_object_ref ((_tmp3_ = ev, G_IS_OBJECT (_tmp3_) ? ((GObject*) _tmp3_) : NULL)));
	_g_object_unref0 (ev);
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static const char* string_to_string (const char* self) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static char* unity_applications_place_daemon_prepare_search_string (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, UnityApplicationsPlaceSection section) {
	char* result = NULL;
	char* s;
	char* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	s = NULL;
	if (search != NULL) {
		char* _tmp0_;
		s = (_tmp0_ = unity_place_search_get_search_string (search), _g_free0 (s), _tmp0_);
	} else {
		char* _tmp1_;
		s = (_tmp1_ = g_strdup (""), _g_free0 (s), _tmp1_);
	}
	s = (_tmp2_ = string_strip (s), _g_free0 (s), _tmp2_);
	if (!g_str_has_suffix (s, "*")) {
		_tmp3_ = _vala_strcmp0 (s, "") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		char* _tmp4_;
		s = (_tmp4_ = g_strconcat (s, "*", NULL), _g_free0 (s), _tmp4_);
	}
	if (_vala_strcmp0 (s, "") != 0) {
		char* _tmp5_;
		s = (_tmp5_ = g_strconcat ("app:(", string_to_string (s), ")", NULL), _g_free0 (s), _tmp5_);
	} else {
		result = (char*) gee_list_get (self->priv->section_queries, (gint) section);
		_g_free0 (s);
		return result;
	}
	if (section == UNITY_APPLICATIONS_PLACE_SECTION_ALL_APPLICATIONS) {
		result = s;
		return result;
	} else {
		char* _tmp7_;
		char* _tmp6_;
		char* _tmp8_;
		result = (_tmp8_ = g_strconcat (s, _tmp7_ = g_strconcat (" AND ", string_to_string (_tmp6_ = (char*) gee_list_get (self->priv->section_queries, (gint) section)), NULL), NULL), _g_free0 (_tmp7_), _g_free0 (_tmp6_), _tmp8_);
		_g_free0 (s);
		return result;
	}
	_g_free0 (s);
}


static gboolean unity_applications_place_daemon_check_is_filter_search (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* new_search, UnityPlaceSearch* old_search) {
	gboolean result = FALSE;
	gboolean is_filter_search;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_search != NULL, FALSE);
	is_filter_search = FALSE;
	if (old_search != NULL) {
		char* previous_search_string;
		gboolean _tmp0_ = FALSE;
		previous_search_string = unity_place_search_get_search_string (old_search);
		if (previous_search_string != NULL) {
			_tmp0_ = _vala_strcmp0 (previous_search_string, "") != 0;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			char* _tmp1_;
			is_filter_search = g_str_has_prefix (_tmp1_ = unity_place_search_get_search_string (new_search), previous_search_string);
			_g_free0 (_tmp1_);
		}
		_g_free0 (previous_search_string);
	}
	result = is_filter_search;
	return result;
}


static gboolean unity_applications_place_daemon_check_search_invalid (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (search == NULL) {
		_tmp1_ = TRUE;
	} else {
		char* _tmp2_;
		_tmp1_ = (_tmp2_ = unity_place_search_get_search_string (search)) == NULL;
		_g_free0 (_tmp2_);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		char* _tmp3_;
		_tmp0_ = _vala_strcmp0 (_tmp3_ = unity_place_search_get_search_string (search), "") == 0;
		_g_free0 (_tmp3_);
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void unity_applications_place_daemon_search_async_data_free (gpointer _data) {
	UnityApplicationsPlaceDaemonSearchAsyncData* data;
	data = _data;
	_g_object_unref0 (data->search);
	_g_object_unref0 (data->results_model);
	_g_object_unref0 (data->groups_model);
	_g_object_unref0 (data->results_by_group);
	g_object_unref (data->self);
	g_slice_free (UnityApplicationsPlaceDaemonSearchAsyncData, data);
}


static void unity_applications_place_daemon_search_async (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, UnityApplicationsPlaceSection section, DeeModel* results_model, DeeModel* groups_model, gboolean is_filter_search, DeeIndex* results_by_group, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityApplicationsPlaceDaemonSearchAsyncData* _data_;
	_data_ = g_slice_new0 (UnityApplicationsPlaceDaemonSearchAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_applications_place_daemon_search_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_applications_place_daemon_search_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->search = _g_object_ref0 (search);
	_data_->section = section;
	_data_->results_model = _g_object_ref0 (results_model);
	_data_->groups_model = _g_object_ref0 (groups_model);
	_data_->is_filter_search = is_filter_search;
	_data_->results_by_group = _g_object_ref0 (results_by_group);
	unity_applications_place_daemon_search_async_co (_data_);
}


static void unity_applications_place_daemon_search_finish (UnityApplicationsPlaceDaemon* self, GAsyncResult* _res_) {
	UnityApplicationsPlaceDaemonSearchAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_applications_place_daemon_search_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityApplicationsPlaceDaemonSearchAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_applications_place_daemon_search_async_co (data);
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static gboolean unity_applications_place_daemon_search_async_co (UnityApplicationsPlaceDaemonSearchAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->search_string = unity_applications_place_daemon_prepare_search_string (data->self, data->search, data->section);
		{
			data->_state_ = 1;
			zeitgeist_index_search (data->self->priv->zg_index, data->search_string, data->_tmp0_ = g_object_ref_sink (zeitgeist_time_range_new_anytime ()), _g_ptr_array_ref0 (data->self->priv->zg_templates), (guint32) ZEITGEIST_STORAGE_STATE_ANY, (guint32) 20, ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, NULL, unity_applications_place_daemon_search_async_ready, data);
			return FALSE;
			_state_1:
			data->results = (data->_tmp1_ = zeitgeist_index_search_finish (data->self->priv->zg_index, data->_res_, &data->_inner_error_), _g_object_unref0 (data->_tmp0_), data->_tmp1_);
			if (data->_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
			if (!data->is_filter_search) {
				dee_model_clear (data->results_model);
				unity_applications_place_daemon_append_events_with_group (data->self, data->results, data->results_model, (guint) UNITY_APPLICATIONS_PLACE_GROUP_MOST_USED, (gint) data->section);
			} else {
				g_debug ("daemon.vala:493: Doing filter search on Most Used apps: '%s'", data->_tmp2_ = unity_place_search_get_search_string (data->search));
				_g_free0 (data->_tmp2_);
				data->group = (guint) UNITY_APPLICATIONS_PLACE_GROUP_MOST_USED;
				data->filter_set = (data->_tmp4_ = dee_index_lookup (data->results_by_group, data->_tmp3_ = g_strdup_printf ("%u", data->group), DEE_TERM_MATCH_EXACT), _g_free0 (data->_tmp3_), data->_tmp4_);
				data->app_uris = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
				{
					data->_ev_it = _vala_zeitgeist_result_set_iterator (data->results);
					while (TRUE) {
						if (!((data->ev = (data->_tmp5_ = _g_object_ref0 (_vala_zeitgeist_result_set_next_value (data->_ev_it)), _g_object_unref0 (data->ev), data->_tmp5_)) != NULL)) {
							break;
						}
						if (zeitgeist_event_num_subjects (data->ev) > 0) {
							gee_collection_add ((GeeCollection*) data->app_uris, zeitgeist_subject_get_uri (zeitgeist_event_get_subject (data->ev, 0)));
						}
					}
					_g_object_unref0 (data->ev);
					_g_object_unref0 (data->_ev_it);
				}
				unity_applications_place_utils_apply_uri_filter (data->app_uris, data->filter_set);
				_g_object_unref0 (data->app_uris);
				_g_object_unref0 (data->filter_set);
			}
			g_debug ("daemon.vala:510: Found %u/%u Most Used apps for query '%s'", zeitgeist_result_set_size (data->results), zeitgeist_result_set_estimated_matches (data->results), data->search_string);
			_g_object_unref0 (data->results);
		}
		goto __finally0;
		__catch0_g_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("daemon.vala:514: Error performing search '%s': %s", data->_tmp6_ = unity_place_search_get_search_string (data->search), data->e->message);
				_g_free0 (data->_tmp6_);
				_g_error_free0 (data->e);
			}
		}
		__finally0:
		if (data->_inner_error_ != NULL) {
			_g_free0 (data->search_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		unity_applications_place_daemon_update_pkg_search (data->self, data->search, data->section, data->results_model, data->is_filter_search, data->results_by_group);
		if (unity_applications_place_daemon_check_search_invalid (data->self, data->search)) {
			unity_applications_place_daemon_check_empty_section (data->self, data->section, data->results_model);
		} else {
			unity_applications_place_daemon_check_empty_search (data->self, data->search, data->results_model);
		}
		_g_free0 (data->search_string);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static char* unity_applications_place_daemon_prepare_pkg_search_string (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, UnityApplicationsPlaceSection section) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (unity_applications_place_daemon_check_search_invalid (self, search)) {
		if (section == UNITY_APPLICATIONS_PLACE_SECTION_ALL_APPLICATIONS) {
			result = g_strdup ("type:Application");
			return result;
		} else {
			char* _tmp0_;
			char* _tmp1_;
			result = (_tmp1_ = g_strconcat ("type:Application AND ", string_to_string (_tmp0_ = (char*) gee_list_get (self->priv->section_queries, (gint) section)), NULL), _g_free0 (_tmp0_), _tmp1_);
			return result;
		}
	} else {
		char* s;
		char* _tmp2_;
		s = unity_place_search_get_search_string (search);
		s = (_tmp2_ = string_strip (s), _g_free0 (s), _tmp2_);
		if (!g_str_has_suffix (s, "*")) {
			char* _tmp3_;
			s = (_tmp3_ = g_strconcat (s, "*", NULL), _g_free0 (s), _tmp3_);
		}
		if (section == UNITY_APPLICATIONS_PLACE_SECTION_ALL_APPLICATIONS) {
			result = g_strconcat ("(", string_to_string (s), ") AND type:Application", NULL);
			_g_free0 (s);
			return result;
		} else {
			char* _tmp4_;
			char* _tmp5_;
			result = (_tmp5_ = g_strconcat ("(", string_to_string (s), ") AND type:Application AND ", string_to_string (_tmp4_ = (char*) gee_list_get (self->priv->section_queries, (gint) section)), NULL), _g_free0 (_tmp4_), _tmp5_);
			_g_free0 (s);
			return result;
		}
		_g_free0 (s);
	}
}


static GIcon* unity_applications_place_daemon_find_pkg_icon (UnityApplicationsPlaceDaemon* self, UnityPackageInfo* pkginfo) {
	GIcon* result = NULL;
	char* desktop_id;
	GAppInfo* _tmp1_;
	UnityAppInfoManager* _tmp0_;
	gboolean _tmp2_;
	gboolean installed;
	GThemedIcon* icon;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pkginfo != NULL, NULL);
	desktop_id = g_path_get_basename (pkginfo->desktop_file);
	installed = (_tmp2_ = (_tmp1_ = unity_app_info_manager_lookup (_tmp0_ = unity_app_info_manager_get_instance (), desktop_id)) != NULL, _g_object_unref0 (_tmp1_), _g_object_unref0 (_tmp0_), _tmp2_);
	if (installed) {
		result = (GIcon*) ((GThemedIcon*) g_themed_icon_new (pkginfo->icon));
		_g_free0 (desktop_id);
		return result;
	}
	if (g_str_has_prefix (pkginfo->icon, "/")) {
		GFile* _tmp3_;
		GIcon* _tmp4_;
		result = (_tmp4_ = (GIcon*) ((GFileIcon*) g_file_icon_new (_tmp3_ = g_file_new_for_path (pkginfo->icon))), _g_object_unref0 (_tmp3_), _tmp4_);
		_g_free0 (desktop_id);
		return result;
	} else {
		GIcon* icon;
		icon = _g_object_ref0 ((GIcon*) g_hash_table_lookup (self->priv->file_icon_cache, pkginfo->icon));
		if (icon != NULL) {
			result = icon;
			_g_free0 (desktop_id);
			return result;
		}
		{
			GeeIterator* _ext_it;
			_ext_it = gee_iterable_iterator ((GeeIterable*) self->priv->image_extensions);
			while (TRUE) {
				char* ext;
				char* path;
				GFile* f;
				if (!gee_iterator_next (_ext_it)) {
					break;
				}
				ext = (char*) gee_iterator_get (_ext_it);
				path = g_strconcat (string_to_string (CONFIG_DATADIR), "/app-install/icons/", string_to_string (pkginfo->icon), ".", string_to_string (ext), NULL);
				f = g_file_new_for_path (path);
				if (g_file_query_exists (f, NULL)) {
					GIcon* _tmp5_;
					icon = (_tmp5_ = (GIcon*) ((GFileIcon*) g_file_icon_new (f)), _g_object_unref0 (icon), _tmp5_);
					g_hash_table_insert (self->priv->file_icon_cache, g_strdup (pkginfo->icon), _g_object_ref0 (icon));
					result = icon;
					_g_object_unref0 (f);
					_g_free0 (path);
					_g_free0 (ext);
					_g_object_unref0 (_ext_it);
					_g_free0 (desktop_id);
					return result;
				}
				_g_object_unref0 (f);
				_g_free0 (path);
				_g_free0 (ext);
			}
			_g_object_unref0 (_ext_it);
		}
		_g_object_unref0 (icon);
	}
	icon = (GThemedIcon*) g_themed_icon_new ("applications-other");
	g_hash_table_insert (self->priv->file_icon_cache, g_strdup (pkginfo->icon), _g_object_ref0 ((GIcon*) icon));
	result = (GIcon*) icon;
	_g_free0 (desktop_id);
	return result;
}


static void unity_applications_place_daemon_on_appinfo_changed (UnityApplicationsPlaceDaemon* self, const char* id, GAppInfo* appinfo) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_debug ("daemon.vala:599: Application changed: %s", id);
}


static gboolean unity_applications_place_daemon_search_is_invalid (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search) {
	gboolean result = FALSE;
	char* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (search == NULL) {
		result = TRUE;
		return result;
	} else {
		char* _tmp0_;
		gboolean _tmp1_;
		if ((_tmp1_ = (_tmp0_ = unity_place_search_get_search_string (search)) == NULL, _g_free0 (_tmp0_), _tmp1_)) {
			result = TRUE;
			return result;
		}
	}
	result = (_tmp3_ = _vala_strcmp0 (_tmp2_ = unity_place_search_get_search_string (search), "") == 0, _g_free0 (_tmp2_), _tmp3_);
	return result;
}


static gboolean unity_applications_place_daemon_update_pkg_search (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, UnityApplicationsPlaceSection section, DeeModel* model, gboolean is_filter_search, DeeIndex* results_by_group) {
	gboolean result = FALSE;
	char* search_string;
	gboolean has_search;
	GTimer* timer;
	UnityPackageSearchResult* appresults;
	GeeSet* installed_uris;
	GeeSet* available_uris;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (results_by_group != NULL, FALSE);
	search_string = unity_applications_place_daemon_prepare_pkg_search_string (self, search, section);
	has_search = !unity_applications_place_daemon_search_is_invalid (self, search);
	timer = g_timer_new ();
	appresults = unity_package_searcher_search (self->priv->appsearcher, search_string);
	installed_uris = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	available_uris = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	unity_applications_place_daemon_add_pkg_search_result (self, appresults, installed_uris, available_uris, model, UNITY_APPLICATIONS_PLACE_GROUP_INSTALLED, results_by_group, is_filter_search);
	g_timer_stop (timer);
	g_debug ("daemon.vala:633: Listed %i Installed apps in %fms for query: %s", appresults->num_hits, g_timer_elapsed (timer, NULL) * 1000, search_string);
	if (has_search) {
		UnityPackageSearchResult* pkgresults;
		g_timer_start (timer);
		pkgresults = unity_package_searcher_search (self->priv->pkgsearcher, search_string);
		unity_applications_place_daemon_add_pkg_search_result (self, pkgresults, installed_uris, available_uris, model, UNITY_APPLICATIONS_PLACE_GROUP_AVAILABLE, results_by_group, is_filter_search);
		g_timer_stop (timer);
		g_debug ("daemon.vala:645: Listed %i Available apps in %fms for query: %s", pkgresults->num_hits, g_timer_elapsed (timer, NULL) * 1000, search_string);
		_unity_package_search_result_free0 (pkgresults);
	}
	result = FALSE;
	_g_object_unref0 (available_uris);
	_g_object_unref0 (installed_uris);
	_unity_package_search_result_free0 (appresults);
	_g_timer_destroy0 (timer);
	_g_free0 (search_string);
	return result;
}


static void unity_applications_place_daemon_add_pkg_search_result (UnityApplicationsPlaceDaemon* self, UnityPackageSearchResult* results, GeeSet* installed_uris, GeeSet* available_uris, DeeModel* model, UnityApplicationsPlaceGroup group, DeeIndex* results_by_group, gboolean is_filter_search) {
	UnityAppInfoManager* appmanager;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results != NULL);
	g_return_if_fail (installed_uris != NULL);
	g_return_if_fail (available_uris != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (results_by_group != NULL);
	appmanager = unity_app_info_manager_get_instance ();
	{
		GSList* pkginfo_collection;
		GSList* pkginfo_it;
		pkginfo_collection = results->results;
		for (pkginfo_it = pkginfo_collection; pkginfo_it != NULL; pkginfo_it = pkginfo_it->next) {
			UnityPackageInfo* pkginfo;
			pkginfo = (UnityPackageInfo*) pkginfo_it->data;
			{
				char* desktop_id;
				GAppInfo* app;
				char* uri;
				gboolean _tmp0_ = FALSE;
				char* display_name;
				char* comment;
				gboolean _tmp7_ = FALSE;
				GIcon* icon;
				if (pkginfo->desktop_file == NULL) {
					continue;
				}
				desktop_id = g_path_get_basename (pkginfo->desktop_file);
				app = unity_app_info_manager_lookup (appmanager, desktop_id);
				uri = g_strconcat ("application://", string_to_string (desktop_id), NULL);
				if (gee_collection_contains ((GeeCollection*) installed_uris, uri)) {
					_tmp0_ = TRUE;
				} else {
					_tmp0_ = gee_collection_contains ((GeeCollection*) available_uris, uri);
				}
				if (_tmp0_) {
					_g_free0 (uri);
					_g_object_unref0 (app);
					_g_free0 (desktop_id);
					continue;
				}
				display_name = NULL;
				comment = NULL;
				switch (group) {
					case UNITY_APPLICATIONS_PLACE_GROUP_INSTALLED:
					{
						char* _tmp1_;
						char* _tmp2_;
						gee_collection_add ((GeeCollection*) installed_uris, uri);
						display_name = (_tmp1_ = g_strdup (g_app_info_get_display_name (app)), _g_free0 (display_name), _tmp1_);
						comment = (_tmp2_ = g_strdup (g_app_info_get_description (app)), _g_free0 (comment), _tmp2_);
						break;
					}
					case UNITY_APPLICATIONS_PLACE_GROUP_AVAILABLE:
					{
						char* _tmp3_;
						char* _tmp4_;
						gee_collection_add ((GeeCollection*) available_uris, uri);
						display_name = (_tmp3_ = g_strdup (pkginfo->application_name), _g_free0 (display_name), _tmp3_);
						comment = (_tmp4_ = g_strdup (""), _g_free0 (comment), _tmp4_);
						break;
					}
					default:
					{
						char* _tmp6_;
						GEnumValue* _tmp5_;
						g_warning ("daemon.vala:693: %s", _tmp6_ = g_strconcat ("Illegal group for package search ", (_tmp5_ = g_enum_get_value (g_type_class_ref (UNITY_APPLICATIONS_PLACE_TYPE_GROUP), (int) group), (_tmp5_ != NULL) ? _tmp5_->value_name : NULL), NULL));
						_g_free0 (_tmp6_);
						continue;
					}
				}
				if (app != NULL) {
					_tmp7_ = !g_app_info_should_show (app);
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_g_free0 (comment);
					_g_free0 (display_name);
					_g_free0 (uri);
					_g_object_unref0 (app);
					_g_free0 (desktop_id);
					continue;
				}
				if (group == UNITY_APPLICATIONS_PLACE_GROUP_AVAILABLE) {
					char* _tmp8_;
					if (app != NULL) {
						_g_free0 (comment);
						_g_free0 (display_name);
						_g_free0 (uri);
						_g_object_unref0 (app);
						_g_free0 (desktop_id);
						continue;
					}
					uri = (_tmp8_ = g_strconcat ("unity-install://", string_to_string (pkginfo->package_name), "/", string_to_string (pkginfo->application_name), NULL), _g_free0 (uri), _tmp8_);
					gee_collection_add ((GeeCollection*) available_uris, uri);
				}
				icon = unity_applications_place_daemon_find_pkg_icon (self, pkginfo);
				if (!is_filter_search) {
					dee_model_append (model, UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_URI, uri, UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_ICON_HINT, g_icon_to_string (icon), UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_GROUP_ID, group, UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_MIMETYPE, "application/x-desktop", UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_DISPLAY_NAME, display_name, UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_COMMENT, comment, -1, NULL);
				}
				_g_object_unref0 (icon);
				_g_free0 (comment);
				_g_free0 (display_name);
				_g_free0 (uri);
				_g_object_unref0 (app);
				_g_free0 (desktop_id);
			}
		}
	}
	if (is_filter_search) {
		char* _tmp9_;
		DeeResultSet* _tmp10_;
		DeeResultSet* filter_set;
		filter_set = (_tmp10_ = dee_index_lookup (results_by_group, _tmp9_ = g_strdup_printf ("%u", (guint) group), DEE_TERM_MATCH_EXACT), _g_free0 (_tmp9_), _tmp10_);
		switch (group) {
			case UNITY_APPLICATIONS_PLACE_GROUP_INSTALLED:
			{
				unity_applications_place_utils_apply_uri_filter (installed_uris, filter_set);
				break;
			}
			case UNITY_APPLICATIONS_PLACE_GROUP_AVAILABLE:
			{
				unity_applications_place_utils_apply_uri_filter (available_uris, filter_set);
				break;
			}
			default:
			{
				char* _tmp12_;
				GEnumValue* _tmp11_;
				g_warning ("daemon.vala:748: %s", _tmp12_ = g_strconcat ("Illegal group for package search ", (_tmp11_ = g_enum_get_value (g_type_class_ref (UNITY_APPLICATIONS_PLACE_TYPE_GROUP), (int) group), (_tmp11_ != NULL) ? _tmp11_->value_name : NULL), NULL));
				_g_free0 (_tmp12_);
				break;
			}
		}
		_g_object_unref0 (filter_set);
	}
	_g_object_unref0 (appmanager);
}


static void unity_applications_place_daemon_real_activate_data_free (gpointer _data) {
	UnityApplicationsPlaceDaemonActivateData* data;
	data = _data;
	_g_free0 (data->uri);
	g_object_unref (data->self);
	g_slice_free (UnityApplicationsPlaceDaemonActivateData, data);
}


static void unity_applications_place_daemon_real_activate (UnityPlaceActivation* base, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityApplicationsPlaceDaemon * self;
	UnityApplicationsPlaceDaemonActivateData* _data_;
	self = (UnityApplicationsPlaceDaemon*) base;
	_data_ = g_slice_new0 (UnityApplicationsPlaceDaemonActivateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_applications_place_daemon_real_activate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_applications_place_daemon_real_activate_data_free);
	_data_->self = g_object_ref (self);
	_data_->uri = g_strdup (uri);
	unity_applications_place_daemon_real_activate_co (_data_);
}


static guint32 unity_applications_place_daemon_real_activate_finish (UnityPlaceActivation* base, GAsyncResult* _res_, GError** error) {
	guint32 result;
	UnityApplicationsPlaceDaemonActivateData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void unity_applications_place_daemon_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityApplicationsPlaceDaemonActivateData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_applications_place_daemon_real_activate_co (data);
}


static gboolean unity_applications_place_daemon_real_activate_co (UnityApplicationsPlaceDaemonActivateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		if (!g_str_has_prefix (data->uri, "unity-install://")) {
			g_debug ("daemon.vala:762: Declined activation of URI '%s': Expected URI scheme " \
"unity-install://", data->uri);
			data->result = (guint32) UNITY_PLACE_ACTIVATION_STATUS_NOT_ACTIVATED;
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->pkg = g_utf8_offset_to_pointer (data->uri, (glong) 16);
		g_debug ("daemon.vala:767: Installing: %s", data->pkg);
		data->args = (data->_tmp0_ = g_new0 (char*, 2 + 1), data->args_length1 = 2, data->_args_size_ = data->args_length1, data->_tmp0_);
		data->args[0] = (data->_tmp1_ = g_strdup ("software-center"), _g_free0 (data->args[0]), data->_tmp1_);
		data->args[1] = (data->_tmp2_ = g_strdup (data->pkg), _g_free0 (data->args[1]), data->_tmp2_);
		{
			g_spawn_async (NULL, data->args, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				if (data->_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch1_g_spawn_error;
				}
				data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		goto __finally1;
		__catch1_g_spawn_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("daemon.vala:775: Failed to spawn software-center for URI '%s': %s", data->uri, data->e->message);
				data->result = (guint32) UNITY_PLACE_ACTIVATION_STATUS_NOT_ACTIVATED;
				_g_error_free0 (data->e);
				data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				_g_error_free0 (data->e);
			}
		}
		__finally1:
		if (data->_inner_error_ != NULL) {
			data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		data->result = (guint32) UNITY_PLACE_ACTIVATION_STATUS_ACTIVATED_HIDE_DASH;
		data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


void unity_applications_place_daemon_append_events_with_group (UnityApplicationsPlaceDaemon* self, ZeitgeistResultSet* events, DeeModel* results, guint group_id, gint section_filter) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	g_return_if_fail (results != NULL);
	{
		ZeitgeistResultSet* _ev_it;
		ZeitgeistEvent* ev;
		_ev_it = _vala_zeitgeist_result_set_iterator (events);
		ev = NULL;
		while (TRUE) {
			char* app_uri;
			GAppInfo* app;
			if (!((ev = _vala_zeitgeist_result_set_next_value (_ev_it)) != NULL)) {
				break;
			}
			app_uri = NULL;
			if (zeitgeist_event_num_subjects (ev) > 0) {
				char* _tmp0_;
				app_uri = (_tmp0_ = g_strdup (zeitgeist_subject_get_uri (zeitgeist_event_get_subject (ev, 0))), _g_free0 (app_uri), _tmp0_);
			} else {
				g_warning ("daemon.vala:831: Unexpected event without subject");
				_g_free0 (app_uri);
				continue;
			}
			app = unity_applications_place_utils_get_app_info_for_actor (app_uri);
			if (app == NULL) {
				_g_object_unref0 (app);
				_g_free0 (app_uri);
				continue;
			}
			if (!g_app_info_should_show (app)) {
				_g_object_unref0 (app);
				_g_free0 (app_uri);
				continue;
			}
			dee_model_append (results, UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_URI, app_uri, UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_ICON_HINT, g_icon_to_string (g_app_info_get_icon (app)), UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_GROUP_ID, group_id, UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_MIMETYPE, "application/x-desktop", UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_DISPLAY_NAME, g_app_info_get_display_name (app), UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_COMMENT, g_app_info_get_description (app), -1, NULL);
			_g_object_unref0 (app);
			_g_free0 (app_uri);
		}
		_g_object_unref0 (_ev_it);
	}
}


void unity_applications_place_daemon_check_empty_search (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, DeeModel* results_model) {
	char* _tmp1_;
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results_model != NULL);
	if (dee_model_get_n_rows (results_model) > 0) {
		return;
	}
	if (unity_applications_place_daemon_search_is_invalid (self, search)) {
		return;
	}
	dee_model_append (results_model, UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_URI, "", UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_ICON_HINT, "", UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_GROUP_ID, UNITY_APPLICATIONS_PLACE_GROUP_EMPTY_SEARCH, UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_MIMETYPE, "", UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_DISPLAY_NAME, _ ("Your search did not match any applications"), UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_COMMENT, "", -1, NULL);
	dee_model_append (results_model, UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_URI, _tmp1_ = g_strconcat ("http://google.com/#q=", string_to_string (_tmp0_ = unity_place_search_get_search_string (search)), NULL), UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_ICON_HINT, "", UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_GROUP_ID, UNITY_APPLICATIONS_PLACE_GROUP_EMPTY_SEARCH, UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_MIMETYPE, "", UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_DISPLAY_NAME, _ ("Search the web"), UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_COMMENT, "", -1, NULL);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
}


void unity_applications_place_daemon_check_empty_section (UnityApplicationsPlaceDaemon* self, UnityApplicationsPlaceSection section, DeeModel* results_model) {
	char* section_name;
	char* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results_model != NULL);
	if (dee_model_get_n_rows (results_model) > 0) {
		return;
	}
	section_name = NULL;
	switch (section) {
		case UNITY_APPLICATIONS_PLACE_SECTION_ALL_APPLICATIONS:
		{
			char* _tmp0_;
			section_name = (_tmp0_ = g_strdup (_ ("applications")), _g_free0 (section_name), _tmp0_);
			break;
		}
		case UNITY_APPLICATIONS_PLACE_SECTION_ACCESSORIES:
		{
			char* _tmp1_;
			section_name = (_tmp1_ = g_strdup (_ ("accessories")), _g_free0 (section_name), _tmp1_);
			break;
		}
		case UNITY_APPLICATIONS_PLACE_SECTION_GAMES:
		{
			char* _tmp2_;
			section_name = (_tmp2_ = g_strdup (_ ("games")), _g_free0 (section_name), _tmp2_);
			break;
		}
		case UNITY_APPLICATIONS_PLACE_SECTION_INTERNET:
		{
			char* _tmp3_;
			section_name = (_tmp3_ = g_strdup (_ ("internet applications")), _g_free0 (section_name), _tmp3_);
			break;
		}
		case UNITY_APPLICATIONS_PLACE_SECTION_MEDIA:
		{
			char* _tmp4_;
			section_name = (_tmp4_ = g_strdup (_ ("media applications")), _g_free0 (section_name), _tmp4_);
			break;
		}
		case UNITY_APPLICATIONS_PLACE_SECTION_OFFICE:
		{
			char* _tmp5_;
			section_name = (_tmp5_ = g_strdup (_ ("office applications")), _g_free0 (section_name), _tmp5_);
			break;
		}
		case UNITY_APPLICATIONS_PLACE_SECTION_SYSTEM:
		{
			char* _tmp6_;
			section_name = (_tmp6_ = g_strdup (_ ("system applications")), _g_free0 (section_name), _tmp6_);
			break;
		}
		default:
		{
			char* _tmp7_;
			section_name = (_tmp7_ = g_strdup (_ ("applications")), _g_free0 (section_name), _tmp7_);
			g_warning ("daemon.vala:915: Unknown section: %u", (guint) section);
			break;
		}
	}
	dee_model_append (results_model, UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_URI, "", UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_ICON_HINT, "", UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_GROUP_ID, UNITY_APPLICATIONS_PLACE_GROUP_EMPTY_SECTION, UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_MIMETYPE, "", UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_DISPLAY_NAME, _tmp8_ = g_strdup_printf (_ ("There are no %s installed on this computer"), section_name), UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_COMMENT, "", -1, NULL);
	_g_free0 (_tmp8_);
	_g_free0 (section_name);
}


UnityApplicationsPlaceDaemon* unity_applications_place_daemon_construct (GType object_type) {
	UnityApplicationsPlaceDaemon * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


UnityApplicationsPlaceDaemon* unity_applications_place_daemon_new (void) {
	return unity_applications_place_daemon_construct (UNITY_APPLICATIONS_PLACE_TYPE_DAEMON);
}


static void _lambda1_ (GObject* obj, GParamSpec* pspec, UnityApplicationsPlaceDaemon* self) {
	DeeModel* _results_model;
	DeeModel* _groups_model;
	UnityPlaceSearch* search;
	UnityPlaceSearch* _tmp0_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	if (self->priv->previous_active_section == unity_place_entry_info_get_active_section (self->priv->applications)) {
		return;
	}
	_results_model = _g_object_ref0 (unity_place_renderer_info_get_results_model (unity_place_entry_info_get_entry_renderer_info (self->priv->applications)));
	_groups_model = _g_object_ref0 (unity_place_renderer_info_get_groups_model (unity_place_entry_info_get_entry_renderer_info (self->priv->applications)));
	search = _g_object_ref0 (unity_place_entry_info_get_active_search (self->priv->applications));
	unity_applications_place_daemon_search_async (self, search, (UnityApplicationsPlaceSection) unity_place_entry_info_get_active_section (self->priv->applications), _results_model, _groups_model, FALSE, self->priv->entry_results_by_group, NULL, NULL);
	self->priv->previous_search = (_tmp0_ = _g_object_ref0 (search), _g_object_unref0 (self->priv->previous_search), _tmp0_);
	self->priv->previous_active_section = unity_place_entry_info_get_active_section (self->priv->applications);
	_g_object_unref0 (search);
	_g_object_unref0 (_groups_model);
	_g_object_unref0 (_results_model);
}


static void __lambda1__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda1_ (_sender, pspec, self);
}


static void _lambda2_ (GObject* obj, GParamSpec* pspec, UnityApplicationsPlaceDaemon* self) {
	UnityPlaceSearch* search;
	DeeModel* _results_model;
	DeeModel* _groups_model;
	UnityPlaceSearch* _tmp0_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	search = _g_object_ref0 (unity_place_entry_info_get_active_search (self->priv->applications));
	if (!unity_applications_place_utils_search_has_really_changed (self->priv->previous_search, search)) {
		_g_object_unref0 (search);
		return;
	}
	_results_model = _g_object_ref0 (unity_place_renderer_info_get_results_model (unity_place_entry_info_get_entry_renderer_info (self->priv->applications)));
	_groups_model = _g_object_ref0 (unity_place_renderer_info_get_groups_model (unity_place_entry_info_get_entry_renderer_info (self->priv->applications)));
	unity_applications_place_daemon_search_async (self, search, (UnityApplicationsPlaceSection) unity_place_entry_info_get_active_section (self->priv->applications), _results_model, _groups_model, unity_applications_place_daemon_check_is_filter_search (self, search, self->priv->previous_search), self->priv->entry_results_by_group, NULL, NULL);
	self->priv->previous_search = (_tmp0_ = _g_object_ref0 (search), _g_object_unref0 (self->priv->previous_search), _tmp0_);
	_g_object_unref0 (_groups_model);
	_g_object_unref0 (_results_model);
	_g_object_unref0 (search);
}


static void __lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda2_ (_sender, pspec, self);
}


static void _lambda3_ (GObject* obj, GParamSpec* pspec, UnityApplicationsPlaceDaemon* self) {
	UnityPlaceSearch* search;
	DeeModel* _results_model;
	DeeModel* _groups_model;
	gboolean _is_filter_search;
	UnityPlaceSearch* _tmp0_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	search = _g_object_ref0 (unity_place_entry_info_get_active_global_search (self->priv->applications));
	if (!unity_applications_place_utils_search_has_really_changed (self->priv->previous_search, search)) {
		_g_object_unref0 (search);
		return;
	}
	_results_model = _g_object_ref0 (unity_place_renderer_info_get_results_model (unity_place_entry_info_get_global_renderer_info (self->priv->applications)));
	_groups_model = _g_object_ref0 (unity_place_renderer_info_get_groups_model (unity_place_entry_info_get_global_renderer_info (self->priv->applications)));
	_is_filter_search = unity_applications_place_daemon_check_is_filter_search (self, search, self->priv->previous_global_search);
	if (!_is_filter_search) {
		dee_model_clear (_results_model);
	}
	unity_applications_place_daemon_update_pkg_search (self, search, UNITY_APPLICATIONS_PLACE_SECTION_ALL_APPLICATIONS, _results_model, _is_filter_search, self->priv->global_results_by_group);
	self->priv->previous_global_search = (_tmp0_ = _g_object_ref0 (search), _g_object_unref0 (self->priv->previous_global_search), _tmp0_);
	_g_object_unref0 (_groups_model);
	_g_object_unref0 (_results_model);
	_g_object_unref0 (search);
}


static void __lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda3_ (_sender, pspec, self);
}


static void _unity_applications_place_daemon_on_appinfo_changed_unity_app_info_manager_changed (UnityAppInfoManager* _sender, const char* id, GAppInfo* new_appinfo, gpointer self) {
	unity_applications_place_daemon_on_appinfo_changed (self, id, new_appinfo);
}


static GObject * unity_applications_place_daemon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityApplicationsPlaceDaemon * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (unity_applications_place_daemon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_APPLICATIONS_PLACE_DAEMON (obj);
	_inner_error_ = NULL;
	{
		DeeSharedModel* sections_model;
		DeeSharedModel* groups_model;
		DeeSharedModel* global_groups_model;
		DeeSharedModel* results_model;
		DeeSharedModel* global_results_model;
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		UnityPlaceEntryInfo* _tmp2_;
		char* _tmp3_;
		ZeitgeistLog* _tmp4_;
		ZeitgeistIndex* _tmp5_;
		UnityPackageSearcher* _tmp6_;
		GeeList* _tmp7_;
		UnityPlaceSearch* _tmp8_;
		UnityPlaceSearch* _tmp9_;
		DeeAnalyzer* analyzer;
		DeeIndex* _tmp10_;
		DeeIndex* _tmp11_;
		GHashTable* _tmp12_;
		UnityAppInfoManager* _tmp13_;
		UnityPlaceController* _tmp14_;
		sections_model = (DeeSharedModel*) dee_shared_model_new ("com.canonical.Unity.ApplicationsPlace.SectionsModel", (guint) 2, G_TYPE_STRING, G_TYPE_STRING, NULL);
		groups_model = (DeeSharedModel*) dee_shared_model_new ("com.canonical.Unity.ApplicationsPlace.GroupsModel", (guint) 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, NULL);
		global_groups_model = (DeeSharedModel*) dee_shared_model_new ("com.canonical.Unity.ApplicationsPlace.GlobalGroupsModel", (guint) 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, NULL);
		results_model = (DeeSharedModel*) dee_shared_model_new ("com.canonical.Unity.ApplicationsPlace.ResultsModel", (guint) 6, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, NULL);
		global_results_model = (DeeSharedModel*) dee_shared_model_new ("com.canonical.Unity.ApplicationsPlace.GlobalResultsModel", (guint) 6, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, NULL);
		self->priv->section_queries = (_tmp0_ = (GeeList*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (self->priv->section_queries), _tmp0_);
		self->priv->section_categories = (_tmp1_ = (GeeList*) gee_array_list_new (GEE_TYPE_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->section_categories), _tmp1_);
		unity_applications_place_daemon_populate_section_queries (self);
		unity_applications_place_daemon_populate_section_categories (self);
		unity_applications_place_daemon_populate_zg_templates (self);
		self->priv->applications = (_tmp2_ = unity_place_entry_info_new ("/com/canonical/unity/applicationsplace/applications"), _g_object_unref0 (self->priv->applications), _tmp2_);
		unity_place_entry_info_set_sections_model (self->priv->applications, (DeeModel*) sections_model);
		unity_place_renderer_info_set_groups_model (unity_place_entry_info_get_entry_renderer_info (self->priv->applications), (DeeModel*) groups_model);
		unity_place_renderer_info_set_results_model (unity_place_entry_info_get_entry_renderer_info (self->priv->applications), (DeeModel*) results_model);
		unity_place_renderer_info_set_groups_model (unity_place_entry_info_get_global_renderer_info (self->priv->applications), (DeeModel*) global_groups_model);
		unity_place_renderer_info_set_results_model (unity_place_entry_info_get_global_renderer_info (self->priv->applications), (DeeModel*) global_results_model);
		unity_applications_place_daemon_populate_sections (self);
		unity_applications_place_daemon_populate_groups (self);
		unity_applications_place_daemon_populate_global_groups (self);
		unity_place_entry_info_set_icon (self->priv->applications, _tmp3_ = g_strconcat (string_to_string (CONFIG_PREFIX), "/share/unity/applications.png", NULL));
		_g_free0 (_tmp3_);
		self->priv->log = (_tmp4_ = zeitgeist_log_new (), _g_object_unref0 (self->priv->log), _tmp4_);
		self->priv->zg_index = (_tmp5_ = zeitgeist_index_new (), _g_object_unref0 (self->priv->zg_index), _tmp5_);
		self->priv->pkgsearcher = (_tmp6_ = unity_package_searcher_new (), _unity_package_searcher_free0 (self->priv->pkgsearcher), _tmp6_);
		self->priv->image_extensions = (_tmp7_ = (GeeList*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (self->priv->image_extensions), _tmp7_);
		gee_collection_add ((GeeCollection*) self->priv->image_extensions, "png");
		gee_collection_add ((GeeCollection*) self->priv->image_extensions, "xpm");
		gee_collection_add ((GeeCollection*) self->priv->image_extensions, "svg");
		gee_collection_add ((GeeCollection*) self->priv->image_extensions, "tiff");
		gee_collection_add ((GeeCollection*) self->priv->image_extensions, "ico");
		gee_collection_add ((GeeCollection*) self->priv->image_extensions, "tif");
		gee_collection_add ((GeeCollection*) self->priv->image_extensions, "jpg");
		self->priv->previous_search = (_tmp8_ = NULL, _g_object_unref0 (self->priv->previous_search), _tmp8_);
		self->priv->previous_global_search = (_tmp9_ = NULL, _g_object_unref0 (self->priv->previous_global_search), _tmp9_);
		self->priv->previous_active_section = (guint) UNITY_APPLICATIONS_PLACE_SECTION_LAST_SECTION;
		analyzer = dee_analyzer_new_for_uint_column ((guint) UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_GROUP_ID);
		self->priv->entry_results_by_group = (_tmp10_ = (DeeIndex*) dee_hash_index_new ((DeeModel*) results_model, analyzer), _g_object_unref0 (self->priv->entry_results_by_group), _tmp10_);
		self->priv->global_results_by_group = (_tmp11_ = (DeeIndex*) dee_hash_index_new ((DeeModel*) global_results_model, analyzer), _g_object_unref0 (self->priv->global_results_by_group), _tmp11_);
		unity_applications_place_daemon_build_app_menu_index (self);
		self->priv->file_icon_cache = (_tmp12_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref), _g_hash_table_unref0 (self->priv->file_icon_cache), _tmp12_);
		g_signal_connect_object ((GObject*) self->priv->applications, "notify::active-section", (GCallback) __lambda1__g_object_notify, self, 0);
		g_signal_connect_object ((GObject*) self->priv->applications, "notify::active-search", (GCallback) __lambda2__g_object_notify, self, 0);
		g_signal_connect_object ((GObject*) self->priv->applications, "notify::active-global-search", (GCallback) __lambda3__g_object_notify, self, 0);
		g_signal_connect_object (_tmp13_ = unity_app_info_manager_get_instance (), "changed", (GCallback) _unity_applications_place_daemon_on_appinfo_changed_unity_app_info_manager_changed, self, 0);
		_g_object_unref0 (_tmp13_);
		dee_shared_model_connect (sections_model);
		dee_shared_model_connect (groups_model);
		dee_shared_model_connect (global_groups_model);
		dee_shared_model_connect (results_model);
		dee_shared_model_connect (global_results_model);
		self->priv->control = (_tmp14_ = unity_place_controller_new ("/com/canonical/unity/applicationsplace"), _g_object_unref0 (self->priv->control), _tmp14_);
		unity_place_controller_add_entry (self->priv->control, self->priv->applications);
		unity_place_controller_set_activation (self->priv->control, (UnityPlaceActivation*) self);
		{
			unity_place_controller_export (self->priv->control, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DBUS_GERROR) {
					goto __catch2_dbus_gerror;
				}
				_g_free0 (analyzer);
				_g_object_unref0 (global_results_model);
				_g_object_unref0 (results_model);
				_g_object_unref0 (global_groups_model);
				_g_object_unref0 (groups_model);
				_g_object_unref0 (sections_model);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
		}
		goto __finally2;
		__catch2_dbus_gerror:
		{
			GError * _error_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("daemon.vala:227: Failed to export DBus service for '%s': %s", unity_place_controller_get_dbus_path (self->priv->control), _error_->message);
				_g_error_free0 (_error_);
			}
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_free0 (analyzer);
			_g_object_unref0 (global_results_model);
			_g_object_unref0 (results_model);
			_g_object_unref0 (global_groups_model);
			_g_object_unref0 (groups_model);
			_g_object_unref0 (sections_model);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_free0 (analyzer);
		_g_object_unref0 (global_results_model);
		_g_object_unref0 (results_model);
		_g_object_unref0 (global_groups_model);
		_g_object_unref0 (groups_model);
		_g_object_unref0 (sections_model);
	}
	return obj;
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _unity_applications_place_daemon_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_unity_applications_place_daemon_introspect (UnityApplicationsPlaceDaemon* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"com.canonical.Unity.Activation\">\n  <method name=\"Activate\">\n    <arg name=\"uri\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult unity_applications_place_daemon_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_unity_applications_place_daemon_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (unity_place_activation_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void unity_applications_place_daemon_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_unity_applications_place_daemon_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	unity_place_activation_dbus_register_object (connection, path, object);
}


static void unity_applications_place_daemon_class_init (UnityApplicationsPlaceDaemonClass * klass) {
	unity_applications_place_daemon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityApplicationsPlaceDaemonPrivate));
	G_OBJECT_CLASS (klass)->constructor = unity_applications_place_daemon_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_applications_place_daemon_finalize;
	g_type_set_qdata (UNITY_APPLICATIONS_PLACE_TYPE_DAEMON, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_unity_applications_place_daemon_dbus_vtable));
}


static void unity_applications_place_daemon_unity_place_activation_interface_init (UnityPlaceActivationIface * iface) {
	unity_applications_place_daemon_unity_place_activation_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = unity_applications_place_daemon_real_activate;
	iface->activate_finish = unity_applications_place_daemon_real_activate_finish;
}


static void unity_applications_place_daemon_instance_init (UnityApplicationsPlaceDaemon * self) {
	self->priv = UNITY_APPLICATIONS_PLACE_DAEMON_GET_PRIVATE (self);
	self->priv->app_menu_changed_reindex_timeout = (guint) 0;
	self->priv->app_menu = NULL;
}


static void unity_applications_place_daemon_finalize (GObject* obj) {
	UnityApplicationsPlaceDaemon * self;
	self = UNITY_APPLICATIONS_PLACE_DAEMON (obj);
	_g_object_unref0 (self->priv->log);
	_g_object_unref0 (self->priv->zg_index);
	_unity_package_searcher_free0 (self->priv->pkgsearcher);
	_unity_package_searcher_free0 (self->priv->appsearcher);
	_g_object_unref0 (self->priv->control);
	_g_object_unref0 (self->priv->applications);
	_g_object_unref0 (self->priv->section_queries);
	_g_object_unref0 (self->priv->section_categories);
	_g_object_unref0 (self->priv->image_extensions);
	_g_hash_table_unref0 (self->priv->file_icon_cache);
	_g_object_unref0 (self->priv->previous_search);
	_g_object_unref0 (self->priv->previous_global_search);
	_g_object_unref0 (self->priv->entry_results_by_group);
	_g_object_unref0 (self->priv->global_results_by_group);
	_g_ptr_array_unref0 (self->priv->zg_templates);
	_gmenu_tree_unref0 (self->priv->app_menu);
	G_OBJECT_CLASS (unity_applications_place_daemon_parent_class)->finalize (obj);
}


GType unity_applications_place_daemon_get_type (void) {
	static volatile gsize unity_applications_place_daemon_type_id__volatile = 0;
	if (g_once_init_enter (&unity_applications_place_daemon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityApplicationsPlaceDaemonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_applications_place_daemon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityApplicationsPlaceDaemon), 0, (GInstanceInitFunc) unity_applications_place_daemon_instance_init, NULL };
		static const GInterfaceInfo unity_place_activation_info = { (GInterfaceInitFunc) unity_applications_place_daemon_unity_place_activation_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_applications_place_daemon_type_id;
		unity_applications_place_daemon_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityApplicationsPlaceDaemon", &g_define_type_info, 0);
		g_type_add_interface_static (unity_applications_place_daemon_type_id, UNITY_PLACE_TYPE_ACTIVATION, &unity_place_activation_info);
		g_once_init_leave (&unity_applications_place_daemon_type_id__volatile, unity_applications_place_daemon_type_id);
	}
	return unity_applications_place_daemon_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




