/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* vim:expandtab:shiftwidth=4:tabstop=4:
 */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Brian Ryner <bryner@brianryner.com>
 *   Chris Lord <chris@linux.intel.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsLookAndFeel.h"

//-------------------------------------------------------------------------
//
// Query interface implementation
//
//-------------------------------------------------------------------------
nsLookAndFeel::nsLookAndFeel() : nsXPLookAndFeel()
{
}

nsLookAndFeel::~nsLookAndFeel()
{
}

nsresult nsLookAndFeel::NativeGetColor(const nsColorID aID, nscolor& aColor)
{
    nsresult res = NS_OK;

    switch (aID) {
        // These colors don't seem to be used for anything anymore in Mozilla
        // (except here at least TextSelectBackground and TextSelectForeground)
        // The CSS2 colors below are used.
    case eColor_WindowBackground:
        aColor = NS_RGB(0xff,0xff,0xff);
        break;
    case eColor_WindowForeground:
        aColor = NS_RGB(0x00,0x00,0x00);
        break;
    case eColor_WidgetBackground:
        aColor = NS_RGB(0xde,0xde,0xde);
        break;
    case eColor_WidgetForeground:
        aColor = NS_RGB(0x00,0x00,0x00);
        break;
    case eColor_WidgetSelectBackground:
        aColor = NS_RGB(0xde,0xd5,0xed);
        break;
    case eColor_WidgetSelectForeground:
        aColor = NS_RGB(0x00,0x00,0x00);
        break;
    case eColor_Widget3DHighlight:
        aColor = NS_RGB(0xa0,0xa0,0xa0);
        break;
    case eColor_Widget3DShadow:
        aColor = NS_RGB(0x40,0x40,0x40);
        break;
    case eColor_TextBackground:
        // not used?
        aColor = NS_RGB(0xff,0xff,0xff);
        break;
    case eColor_TextForeground: 
        // not used?
        aColor = NS_RGB(0x00,0x00,0x00);
        break;
    case eColor_TextSelectBackground:
    case eColor_IMESelectedRawTextBackground:
    case eColor_IMESelectedConvertedTextBackground:
        // still used
        aColor = NS_RGB(0xde,0xd5,0xed);
        break;
    case eColor_TextSelectForeground:
    case eColor_IMESelectedRawTextForeground:
    case eColor_IMESelectedConvertedTextForeground:
        // still used
        aColor = NS_RGB(0x00,0x00,0x00);
        break;
    case eColor_IMERawInputBackground:
    case eColor_IMEConvertedTextBackground:
        aColor = NS_TRANSPARENT;
        break;
    case eColor_IMERawInputForeground:
    case eColor_IMEConvertedTextForeground:
        aColor = NS_SAME_AS_FOREGROUND_COLOR;
        break;
    case eColor_IMERawInputUnderline:
    case eColor_IMEConvertedTextUnderline:
        aColor = NS_SAME_AS_FOREGROUND_COLOR;
        break;
    case eColor_IMESelectedRawTextUnderline:
    case eColor_IMESelectedConvertedTextUnderline:
        aColor = NS_TRANSPARENT;
        break;

        // css2  http://www.w3.org/TR/REC-CSS2/ui.html#system-colors
    case eColor_activeborder:
        // active window border
        aColor = NS_RGB(0xde,0xde,0xde);
        break;
    case eColor_activecaption:
        // active window caption background
        aColor = NS_RGB(0xde,0xde,0xde);
        break;
    case eColor_appworkspace:
        // MDI background color
        aColor = NS_RGB(0xde,0xde,0xde);
        break;
    case eColor_background:
        // desktop background
        aColor = NS_RGB(0xde,0xde,0xde);
        break;
    case eColor_captiontext:
        // text in active window caption, size box, and scrollbar arrow box (!)
        aColor = NS_RGB(0x00,0x00,0x00);
        break;
    case eColor_graytext:
        // disabled text in windows, menus, etc.
        aColor = NS_RGB(0xea,0xea,0xea);
        break;
    case eColor_highlight:
        // background of selected item
        aColor = NS_RGB(0xde,0xd5,0xed);
        break;
    case eColor_highlighttext:
        // text of selected item
        aColor = NS_RGB(0x00,0x00,0x00);
        break;
    case eColor_inactiveborder:
        // inactive window border
        aColor = NS_RGB(0xde,0xde,0xde);
        break;
    case eColor_inactivecaption:
        // inactive window caption
        aColor = NS_RGB(0xde,0xde,0xde);
        break;
    case eColor_inactivecaptiontext:
        // text in inactive window caption
        aColor = NS_RGB(0xea,0xea,0xea);
        break;
    case eColor_infobackground:
        // tooltip background color
        aColor = NS_RGB(0xef,0xe6,0xc3);
        break;
    case eColor_infotext:
        // tooltip text color
        aColor = NS_RGB(0x00,0x00,0x00);
        break;
    case eColor_menu:
        // menu background
        aColor = NS_RGB(0xde,0xde,0xde);
        break;
    case eColor_menutext:
        // menu text
        aColor = NS_RGB(0x00,0x00,0x00);
        break;
    case eColor_scrollbar:
        // scrollbar gray area
        aColor = NS_RGB(0xee,0xee,0xee);
        break;

    case eColor_threedface:
    case eColor_buttonface:
        // 3-D face color
        aColor = NS_RGB(0xde,0xde,0xde);
        break;

    case eColor_buttontext:
        // text on push buttons
        aColor = NS_RGB(0x00,0x00,0x00);
        break;

    case eColor_buttonhighlight:
        // 3-D highlighted edge color
    case eColor_threedhighlight:
        // 3-D highlighted outer edge color
        aColor = NS_RGB(0xea,0xea,0xea);
        break;

    case eColor_threedlightshadow:
        // 3-D highlighted inner edge color
        aColor = NS_RGB(0xde,0xde,0xde);
        break;

    case eColor_buttonshadow:
        // 3-D shadow edge color
    case eColor_threedshadow:
        // 3-D shadow inner edge color
        aColor = NS_RGB(0x9c,0x9c,0x9c);
        break;

    case eColor_threeddarkshadow:
        // 3-D shadow outer edge color
        aColor = NS_RGB(0x00,0x00,0x00);
        break;

    case eColor_window:
    case eColor_windowframe:
        aColor = NS_RGB(0xde,0xde,0xde);
        break;

    case eColor_windowtext:
        aColor = NS_RGB(0x00,0x00,0x00);
        break;

    case eColor__moz_eventreerow:
    case eColor__moz_field:
        aColor = NS_RGB(0xff,0xff,0xff);
        break;
    case eColor__moz_fieldtext:
        aColor = NS_RGB(0x00,0x00,0x00);
        break;
    case eColor__moz_dialog:
        aColor = NS_RGB(0xde,0xde,0xde);
        break;
    case eColor__moz_dialogtext:
        aColor = NS_RGB(0x00,0x00,0x00);
        break;
    case eColor__moz_dragtargetzone:
        aColor = NS_RGB(0xde,0xd5,0xed);
        break; 
    case eColor__moz_buttondefault:
        // default button border color
        aColor = NS_RGB(0x00,0x00,0x00);
        break;
    case eColor__moz_buttonhoverface:
        aColor = NS_RGB(0xea,0xea,0xea);
        break;
    case eColor__moz_buttonhovertext:
        aColor = NS_RGB(0x00,0x00,0x00);
        break;
    case eColor__moz_cellhighlight:
    case eColor__moz_html_cellhighlight:
        aColor = NS_RGB(0xde,0xd5,0xed);
        break;
    case eColor__moz_cellhighlighttext:
    case eColor__moz_html_cellhighlighttext:
        aColor = NS_RGB(0x00,0x00,0x00);
        break;
    case eColor__moz_menuhover:
        aColor = NS_RGB(0xde,0xd5,0xed);
        break;
    case eColor__moz_menuhovertext:
        aColor = NS_RGB(0xff,0xff,0xff);
        break;
    case eColor__moz_oddtreerow:
        aColor = NS_RGB(0xea,0xea,0xea);
        break;
    case eColor__moz_nativehyperlinktext:
        aColor = NS_RGB(0x3c,0x3c,0xfd);
        break;
    case eColor__moz_comboboxtext:
        aColor = NS_RGB(0x00,0x00,0x00);
        break;
    case eColor__moz_combobox:
        aColor = NS_RGB(0xff,0xff,0xff);
        break;
    default:
        // default color is BLACK
        aColor = 0;
        res    = NS_ERROR_FAILURE;
        break;
    }

    return res;
}

NS_IMETHODIMP nsLookAndFeel::GetMetric(const nsMetricID aID, PRInt32 & aMetric)
{
    nsresult res = NS_OK;

    // Set these before they can get overrided in the nsXPLookAndFeel. 
    switch (aID) {
    case eMetric_ScrollButtonLeftMouseButtonAction:
        aMetric = 0;
        return NS_OK;
    case eMetric_ScrollButtonMiddleMouseButtonAction:
        aMetric = 1;
        return NS_OK;
    case eMetric_ScrollButtonRightMouseButtonAction:
        aMetric = 2;
        return NS_OK;
    default:
        break;
    }

    res = nsXPLookAndFeel::GetMetric(aID, aMetric);
    if (NS_SUCCEEDED(res))
        return res;
    res = NS_OK;

    switch (aID) {
    case eMetric_WindowTitleHeight:
        aMetric = 0;
        break;
    case eMetric_WindowBorderWidth:
        // XXXldb Why is this commented out?
        //    aMetric = mStyle->klass->xthickness;
        break;
    case eMetric_WindowBorderHeight:
        // XXXldb Why is this commented out?
        //    aMetric = mStyle->klass->ythickness;
        break;
    case eMetric_Widget3DBorder:
        // XXXldb Why is this commented out?
        //    aMetric = 4;
        break;
    case eMetric_TextFieldHeight:
        aMetric = 0;
        break;
    case eMetric_TextFieldBorder:
        aMetric = 2;
        break;
    case eMetric_TextVerticalInsidePadding:
        aMetric = 0;
        break;
    case eMetric_TextShouldUseVerticalInsidePadding:
        aMetric = 0;
        break;
    case eMetric_TextHorizontalInsideMinimumPadding:
        aMetric = 15;
        break;
    case eMetric_TextShouldUseHorizontalInsideMinimumPadding:
        aMetric = 1;
        break;
    case eMetric_ButtonHorizontalInsidePaddingNavQuirks:
        aMetric = 10;
        break;
    case eMetric_ButtonHorizontalInsidePaddingOffsetNavQuirks:
        aMetric = 8;
        break;
    case eMetric_CheckboxSize:
        aMetric = 15;
        break;
    case eMetric_RadioboxSize:
        aMetric = 15;
        break;
    case eMetric_ListShouldUseHorizontalInsideMinimumPadding:
        aMetric = 15;
        break;
    case eMetric_ListHorizontalInsideMinimumPadding:
        aMetric = 15;
        break;
    case eMetric_ListShouldUseVerticalInsidePadding:
        aMetric = 1;
        break;
    case eMetric_ListVerticalInsidePadding:
        aMetric = 1;
        break;
    case eMetric_CaretBlinkTime:
        aMetric = 1200;
        break;
    case eMetric_CaretWidth:
        aMetric = 1;
        break;
    case eMetric_ShowCaretDuringSelection:
        aMetric = 0;
        break;
    case eMetric_SelectTextfieldsOnKeyFocus:
        aMetric = 1;
        break;
    case eMetric_SubmenuDelay:
        aMetric = 1000;
        break;
    case eMetric_MenusCanOverlapOSBar:
        // we want XUL popups to be able to overlap the task bar.
        aMetric = 1;
        break;
    case eMetric_SkipNavigatingDisabledMenuItem:
        aMetric = 1;
        break;
    case eMetric_DragFullWindow:
        aMetric = 1;
        break;
    case eMetric_DragThresholdX:
    case eMetric_DragThresholdY:
        aMetric = 8;
        break;
    case eMetric_ScrollArrowStyle:
        aMetric = nsILookAndFeel::eMetric_ScrollArrowStyleSingle;
        break;
    case eMetric_ScrollSliderStyle:
        aMetric = eMetric_ScrollThumbStyleProportional;
        break;
    case eMetric_TreeOpenDelay:
        aMetric = 1000;
        break;
    case eMetric_TreeCloseDelay:
        aMetric = 1000;
        break;
    case eMetric_TreeLazyScrollDelay:
        aMetric = 150;
        break;
    case eMetric_TreeScrollDelay:
        aMetric = 100;
        break;
    case eMetric_TreeScrollLinesMax:
        aMetric = 3;
        break;
    case eMetric_DWMCompositor:
    case eMetric_WindowsClassic:
    case eMetric_WindowsDefaultTheme:
        aMetric = 0;
        res = NS_ERROR_NOT_IMPLEMENTED;
        break;
    case eMetric_IMERawInputUnderlineStyle:
    case eMetric_IMEConvertedTextUnderlineStyle:
        aMetric = NS_UNDERLINE_STYLE_SOLID;
        break;
    case eMetric_IMESelectedRawTextUnderlineStyle:
    case eMetric_IMESelectedConvertedTextUnderline:
        aMetric = NS_UNDERLINE_STYLE_NONE;
        break;
    case eMetric_ImagesInMenus:
        aMetric = 1;
        break;
    default:
        aMetric = 0;
        res     = NS_ERROR_FAILURE;
    }

    return res;
}

NS_IMETHODIMP nsLookAndFeel::GetMetric(const nsMetricFloatID aID,
                                       float & aMetric)
{
    nsresult res = NS_OK;
    res = nsXPLookAndFeel::GetMetric(aID, aMetric);
    if (NS_SUCCEEDED(res))
        return res;
    res = NS_OK;

    switch (aID) {
    case eMetricFloat_TextFieldVerticalInsidePadding:
        aMetric = 0.25f;
        break;
    case eMetricFloat_TextFieldHorizontalInsidePadding:
        aMetric = 0.95f; // large number on purpose so minimum padding is used
        break;
    case eMetricFloat_TextAreaVerticalInsidePadding:
        aMetric = 0.40f;    
        break;
    case eMetricFloat_TextAreaHorizontalInsidePadding:
        aMetric = 0.40f; // large number on purpose so minimum padding is used
        break;
    case eMetricFloat_ListVerticalInsidePadding:
        aMetric = 0.10f;
        break;
    case eMetricFloat_ListHorizontalInsidePadding:
        aMetric = 0.40f;
        break;
    case eMetricFloat_ButtonVerticalInsidePadding:
        aMetric = 0.25f;
        break;
    case eMetricFloat_ButtonHorizontalInsidePadding:
        aMetric = 0.25f;
        break;
    case eMetricFloat_IMEUnderlineRelativeSize:
        aMetric = 1.0f;
        break;
    case eMetricFloat_CaretAspectRatio:
        aMetric = 0.04f;
        break;
    default:
        aMetric = -1.0;
        res = NS_ERROR_FAILURE;
    }
    return res;
}

