/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* vim:expandtab:shiftwidth=4:tabstop=4:
 */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is Christopher Blizzard
 * <blizzard@mozilla.org>.  Portions created by the Initial Developer
 * are Copyright (C) 2001 the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Masayuki Nakano <masayuki@d-toybox.com>
 *   Vladimir Vukicevic <vladimir@pobox.com>
 *   Chris Lord <chris@linux.intel.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __nsWindow_h__
#define __nsWindow_h__

#include "nsAutoPtr.h"
#include "nsBaseWidget.h"
#include "nsGUIEvent.h"
#include "nsWeakReference.h"
#include "nsWidgetAtoms.h"
#include "nsIRegion.h"

#include "moz-drawing-area.h"

#include "gfxASurface.h"

#include "cairo.h"
#ifdef MOZ_ENABLE_GTK2_PLUGINS
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#endif

#ifdef MOZ_LOGGING

// make sure that logging is enabled before including prlog.h
#define FORCE_PR_LOG

#include "prlog.h"

extern PRLogModuleInfo *gWidgetLog;
extern PRLogModuleInfo *gWidgetFocusLog;
extern PRLogModuleInfo *gWidgetIMLog;
extern PRLogModuleInfo *gWidgetDrawLog;

#define LOG(args) PR_LOG(gWidgetLog, 4, args)
#define LOGFOCUS(args) PR_LOG(gWidgetFocusLog, 4, args)
#define LOGIM(args) PR_LOG(gWidgetIMLog, 4, args)
#define LOGDRAW(args) PR_LOG(gWidgetDrawLog, 4, args)

#else

#define LOG(args)
#define LOGFOCUS(args)
#define LOGIM(args)
#define LOGDRAW(args)

#endif /* MOZ_LOGGING */

class nsWindow : public nsBaseWidget,
                 public nsSupportsWeakReference
{
public:
    nsWindow();
    virtual ~nsWindow();

    NS_DECL_ISUPPORTS_INHERITED

    virtual nsIWidget *GetParent(void);

    NS_IMETHOD Create(nsIWidget        *aParent,
                      const nsIntRect  &aRect,
                      EVENT_CALLBACK   aHandleEventFunction,
                      nsIDeviceContext *aContext,
                      nsIAppShell      *aAppShell = nsnull,
                      nsIToolkit       *aToolkit = nsnull,
                      nsWidgetInitData *aInitData = nsnull);
    NS_IMETHOD Create(nsNativeWidget    aParent,
                      const nsIntRect  &aRect,
                      EVENT_CALLBACK   aHandleEventFunction,
                      nsIDeviceContext *aContext,
                      nsIAppShell      *aAppShell = nsnull,
                      nsIToolkit       *aToolkit = nsnull,
                      nsWidgetInitData *aInitData = nsnull);

//    NS_IMETHOD  GetClientData(void*& aClientData);
//    NS_IMETHOD  SetClientData(void* aClientData);

    NS_IMETHOD Destroy(void);

    NS_IMETHOD SetParent(nsIWidget* aNewParent);

    NS_IMETHOD Show(PRBool aState);

    NS_IMETHOD SetModal(PRBool aModal);

    NS_IMETHOD IsVisible(PRBool & aState);

    NS_IMETHOD ConstrainPosition(PRBool aAllowSlop,
                                 PRInt32 *aX,
                                 PRInt32 *aY);

    NS_IMETHOD Move(PRInt32 aX, PRInt32 aY);

    NS_IMETHOD Resize(PRInt32 aWidth,
                      PRInt32 aHeight,
                      PRBool   aRepaint);
    NS_IMETHOD Resize(PRInt32 aX,
                      PRInt32 aY,
                      PRInt32 aWidth,
                      PRInt32 aHeight,
                      PRBool   aRepaint);

    NS_IMETHOD SetZIndex(PRInt32 aZIndex);
//    NS_IMETHOD GetZIndex(PRInt32* aZIndex);

    NS_IMETHOD PlaceBehind(nsTopLevelWidgetZPlacement aPlacement,
                           nsIWidget *aWidget, PRBool aActivate);

    NS_IMETHOD SetSizeMode(PRInt32 aMode);
//    NS_IMETHOD GetSizeMode(PRInt32* aMode);

    NS_IMETHOD Enable(PRBool aState);
    NS_IMETHOD IsEnabled(PRBool *aState);

    NS_IMETHOD SetFocus(PRBool aRaise = PR_FALSE);

    virtual void UpdatePluginWindowBounds();
    NS_IMETHOD SetBounds(const nsIntRect &aRect);
    NS_IMETHOD GetBounds(nsIntRect &aRect);
    
//    NS_IMETHOD GetScreenBounds(nsRect &aRect);
//    NS_IMETHOD GetClientBounds(nsRect &aRect);

//    NS_IMETHOD GetBorderSize(PRInt32 &aWidth, PRInt32 &aHeight);

    NS_IMETHOD SetForegroundColor(const nscolor &aColor);
    NS_IMETHOD SetBackgroundColor(const nscolor &aColor);
    NS_IMETHOD SetCursor(nsCursor aCursor);

//    NS_IMETHOD SetCursor(imgIContainer* aCursor,
//                         PRUint32 aHotspotX, PRUint32 aHotspotY);

//    NS_IMETHOD GetWindowType(nsWindowType& aWindowType);

    NS_IMETHOD HideWindowChrome(PRBool aShouldHide);

    NS_IMETHOD MakeFullScreen(PRBool aFullScreen);

    NS_IMETHOD Validate();

    NS_IMETHOD Invalidate(PRBool aIsSynchronous);
    NS_IMETHOD Invalidate(const nsIntRect &aRect, PRBool aIsSynchronous);

    NS_IMETHOD Update();

//    NS_IMETHOD AddEventListener(nsIEventListener * aListener);

    NS_IMETHOD Scroll(PRInt32 aDx, PRInt32 aDy, nsIntRect *aClipRect);
    NS_IMETHOD ScrollWidgets(PRInt32 aDx, PRInt32 aDy);

    NS_IMETHOD SetBorderStyle(nsBorderStyle aBorderStyle);

    NS_IMETHOD SetTitle(const nsAString& aTitle);

    NS_IMETHOD SetIcon(const nsAString& anIconSpec);

    NS_IMETHOD SetMenuBar(void* aMenuBar);
    NS_IMETHOD ShowMenuBar(PRBool aShow);

    virtual nsIntPoint WidgetToScreenOffset();

    NS_IMETHOD BeginResizingChildren(void);
    NS_IMETHOD EndResizingChildren(void);

    NS_IMETHOD GetPreferredSize(PRInt32& aWidth, PRInt32& aHeight);
    NS_IMETHOD SetPreferredSize(PRInt32 aWidth, PRInt32 aHeight);

    PRBool     DispatchCommandEvent(nsIAtom* aCommand);
    void       DispatchResizeEvent(nsIntRect &aRect, nsEventStatus &aStatus);
    NS_IMETHOD DispatchEvent(nsGUIEvent* event, nsEventStatus & aStatus);

//    NS_IMETHOD EnableDragDrop(PRBool aEnable);
    virtual void ConvertToDeviceCoordinates(nscoord &aX,
                                            nscoord &aY);

    NS_IMETHOD CaptureMouse(PRBool aCapture);

    NS_IMETHOD SetWindowClass(const nsAString& xulWinType);

    NS_IMETHOD CaptureRollupEvents(nsIRollupListener * aListener, PRBool aDoCapture, PRBool aConsumeRollupEvent);

//    NS_IMETHOD ModalEventFilter(PRBool aRealEvent, void *aEvent, PRBool *aForWindow);

    NS_IMETHOD GetAttention(PRInt32 aCycleCount);

//    NS_IMETHOD GetLastInputEventTime(PRUint32& aTime);

//    NS_IMETHOD BeginSecureKeyboardInput();
//    NS_IMETHOD EndSecureKeyboardInput();

//    NS_IMETHOD SetWindowTitlebarColor(nscolor aColor, PRBool aActive);

    NS_IMETHOD BeginResizeDrag(nsGUIEvent* aEvent, PRInt32 aHorizontal, PRInt32 aVertical);

//    NS_IMETHOD SetIMEOpenState(PRBool aState);
//    NS_IMETHOD GetIMEOpenState(PRBool* aState);

//    NS_IMETHOD GetToggledKeyState(PRUint32 aKeyCode, PRBool* aLEDState);

    virtual void               ScrollInvalidRegion(PRInt32 aDx, PRInt32 aDy);
    virtual void               PropagateInvalidRegionUp(nsIRegion *aRegion, PRBool aFirstCall);
    virtual void               PropagateInvalidRegionDown(nsIRegion *aRegion, PRBool recurse);
    virtual void               PropagateInvalidRegions(void);
    virtual void               Redraw(void);
    virtual void               ScheduleExpose(PRBool aSynchronous);
    virtual void*              GetNativeData(PRUint32 aDataType);
    virtual nsTransparencyMode GetTransparencyMode();

    PRBool IsKeyDown(PRUint32 aKeyCode) {
        PRUint32 mask;
        PRUint32* flag = GetFlagWord32(aKeyCode, &mask);
        return ((*flag) & mask) != 0;
    }

    void SetKeyDownFlag(PRUint32 aKeyCode) {
        PRUint32 mask;
        PRUint32* flag = GetFlagWord32(aKeyCode, &mask);
        *flag |= mask;
    }

    void ClearKeyDownFlag(PRUint32 aKeyCode) {
        PRUint32 mask;
        PRUint32* flag = GetFlagWord32(aKeyCode, &mask);
        *flag &= ~mask;
    }

    GtkWidget* GetPluginPort() {
        return mPluginPort;
    }

    void ShowPluginWindows(MozDrawingArea *aDrawingArea, PRBool aState);
#ifdef SUPPORT_IM
    void   IMEComposeStart (void);
    void   IMEComposeText  (const PRUnichar *aText,
                            const PRInt32 aLen,
                            const gchar *aPreeditString,
                            const gint aCursorPos);
    void   IMEComposeEnd   (void);
    PRBool IMEIsComposing  (void);

    NS_IMETHOD ResetInputState      (void);
    NS_IMETHOD SetIMEEnabled        (PRUint32 aState);
    NS_IMETHOD GetIMEEnabled        (PRUint32* aState);
    NS_IMETHOD CancelIMEComposition (void);
    NS_IMETHOD OnIMEFocusChange     (PRBool aFocus);
#endif

protected:
#ifdef SUPPORT_IM
    void   IMESetCursorPosition (void);
    PRBool GetCaretRect         (nsIntRect &aCaretRect);
#endif
    PRPackedBool           mIsDestroyed;
    PRPackedBool           mIsShown;
    PRPackedBool           mIsModal;
    PRPackedBool           mEnabled;
    PRUint32               mPreferredWidth;
    PRUint32               mPreferredHeight;
    nsCOMPtr<nsIWidget>    mParent;

    nsresult               NativeCreate(nsIWidget        *aParent,
                                        nsNativeWidget    aNativeParent,
                                        const nsIntRect  &aRect,
                                        EVENT_CALLBACK    aHandleEventFunction,
                                        nsIDeviceContext *aContext,
                                        nsIAppShell      *aAppShell,
                                        nsIToolkit       *aToolkit,
                                        nsWidgetInitData *aInitData);

    gfxASurface           *GetThebesSurface();

private:
#ifdef MOZ_ENABLE_GTK2_PLUGINS
    void                  *SetupPluginPort(void);
    GtkWidget             *mPluginPort;
    nsRect                 mPluginPortBounds;
    GdkWindow             *mTopLevelGdkWindow;

    enum PluginType {
        PluginType_NONE = 0,   /* do not have any plugin */
        PluginType_XEMBED,     /* the plugin support xembed */
        PluginType_NONXEMBED   /* the plugin does not support xembed */
    };
    PluginType             mPluginType;

    void                   GetAbsBounds(nsRect &aRect);
    void                   SetPluginType(PluginType aPluginType);
#ifdef MOZ_X11
    void                   SetNonXEmbedPluginFocus(void);
    void                   LoseNonXEmbedPluginFocus(void);
    Window                 mOldFocusWindow;
    static GdkFilterReturn PluginWindowXClientMessageFilter(GdkXEvent *gdk_xevent,
                                                            GdkEvent *event,
                                                            gpointer data);
    static GdkFilterReturn PluginWindowXEventFilterFunc(GdkXEvent *gdk_xevent,
                                                        GdkEvent *event,
                                                        gpointer data);
#endif /* MOZ_X11 */
#endif

    MozDrawingArea        *mDrawingarea;
    nsRefPtr<gfxASurface>  mThebesSurface;
    nsIRegion             *mInvalidRegion;
    gulong                 mExposeSignals[2];
    gulong                 mSurfaceSignal;
    gulong                 mBoundsSignals[4];
    gulong                 mUpdateDebug;
#ifdef SUPPORT_IM
    gulong                 mEventSignals[7];
    PRUint32               mIMEEnabled;
    PRBool                 mIsComposing;
#else
    gulong                 mEventSignals[5];
#endif

    /* Key Down event is DOM Virtual Key driven, needs 256 bits. */
    PRUint32 mKeyDownFlags[8];

    /* Helper methods for DOM Key Down event suppression. */
    PRUint32* GetFlagWord32(PRUint32 aKeyCode, PRUint32* aMask) {
        /* Mozilla DOM Virtual Key Code is from 0 to 224. */
        NS_ASSERTION((aKeyCode <= 0xFF), "Invalid DOM Key Code");
        aKeyCode &= 0xFF;

        /* 32 = 2^5 = 0x20 */
        *aMask = PRUint32(1) << (aKeyCode & 0x1F);
        return &mKeyDownFlags[(aKeyCode >> 5)];
    }

};

class nsChildWindow : public nsWindow {
public:
    nsChildWindow();
    ~nsChildWindow();
};

#endif // __nsWindow_h__

